/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Set;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;

public record LootItemConditionRandomChanceWithLooting(float b, float c) implements LootItemCondition
{
    private final float b;
    private final float c;
    public static final Codec<LootItemConditionRandomChanceWithLooting> a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("chance").forGetter(LootItemConditionRandomChanceWithLooting::c), (App)Codec.FLOAT.fieldOf("looting_multiplier").forGetter(LootItemConditionRandomChanceWithLooting::d)).apply((Applicative)instance, LootItemConditionRandomChanceWithLooting::new));

    @Override
    public LootItemConditionType b() {
        return LootItemConditions.f;
    }

    @Override
    public Set<LootContextParameter<?>> a() {
        return ImmutableSet.of(LootContextParameters.d);
    }

    public boolean a(LootTableInfo loottableinfo) {
        Entity entity = loottableinfo.c(LootContextParameters.d);
        int i2 = 0;
        if (entity instanceof EntityLiving) {
            i2 = EnchantmentManager.h((EntityLiving)entity);
        }
        if (loottableinfo.a(LootContextParameters.LOOTING_MOD)) {
            i2 = loottableinfo.c(LootContextParameters.LOOTING_MOD);
        }
        return loottableinfo.b().i() < this.b + (float)i2 * this.c;
    }

    public static LootItemCondition.a a(float chance, float lootingMultiplier) {
        return () -> new LootItemConditionRandomChanceWithLooting(chance, lootingMultiplier);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{LootItemConditionRandomChanceWithLooting.class, "percent;lootingMultiplier", "b", "c"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LootItemConditionRandomChanceWithLooting.class, "percent;lootingMultiplier", "b", "c"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LootItemConditionRandomChanceWithLooting.class, "percent;lootingMultiplier", "b", "c"}, this, o2);
    }

    public float c() {
        return this.b;
    }

    public float d() {
        return this.c;
    }
}

