/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.providers.number;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.util.function.Function;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.ScoreboardValue;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class NumberProviders {
    private static final Codec<NumberProvider> f = BuiltInRegistries.J.q().dispatch(NumberProvider::b, LootNumberProviderType::a);
    public static final Codec<NumberProvider> a = ExtraCodecs.a(() -> {
        Codec<UniformGenerator> codec = ExtraCodecs.e(f, UniformGenerator.a);
        return Codec.either(ConstantValue.b, codec).xmap(either -> (NumberProvider)either.map(Function.identity(), Function.identity()), numberProvider -> {
            Either<Object, NumberProvider> either;
            if (numberProvider instanceof ConstantValue) {
                ConstantValue constantValue = (ConstantValue)numberProvider;
                either = Either.left(constantValue);
            } else {
                either = Either.right(numberProvider);
            }
            return either;
        });
    });
    public static final LootNumberProviderType b = NumberProviders.a("constant", ConstantValue.a);
    public static final LootNumberProviderType c = NumberProviders.a("uniform", UniformGenerator.a);
    public static final LootNumberProviderType d = NumberProviders.a("binomial", BinomialDistributionGenerator.a);
    public static final LootNumberProviderType e = NumberProviders.a("score", ScoreboardValue.a);

    private static LootNumberProviderType a(String id, Codec<? extends NumberProvider> codec) {
        return IRegistry.a(BuiltInRegistries.J, new MinecraftKey(id), new LootNumberProviderType(codec));
    }
}

