/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import com.google.common.math.DoubleMath;
import io.papermc.paper.util.CollisionUtil;
import io.papermc.paper.util.collisions.CachedShapeData;
import io.papermc.paper.util.collisions.CachedToAABBs;
import io.papermc.paper.util.collisions.FlatBitsetUtil;
import io.papermc.paper.util.collisions.MergedORCache;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumAxisCycle;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.MathHelper;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.DoubleListOffset;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShapeArray;
import net.minecraft.world.phys.shapes.VoxelShapeDiscrete;
import net.minecraft.world.phys.shapes.VoxelShapeSlice;
import net.minecraft.world.phys.shapes.VoxelShapes;

public abstract class VoxelShape {
    public final VoxelShapeDiscrete a;
    @Nullable
    private VoxelShape[] b;
    private double offsetX;
    private double offsetY;
    private double offsetZ;
    private AxisAlignedBB singleAABBRepresentation;
    private double[] rootCoordinatesX;
    private double[] rootCoordinatesY;
    private double[] rootCoordinatesZ;
    private CachedShapeData cachedShapeData;
    private boolean isEmpty;
    private CachedToAABBs cachedToAABBs;
    private AxisAlignedBB cachedBounds;
    private Boolean isFullBlock;
    private Boolean occludesFullBlock;
    private static final int MERGED_CACHE_SIZE = 16;
    private MergedORCache[] mergedORCache;
    private VoxelShape[] faceShapeClampedCache;

    public final double offsetX() {
        return this.offsetX;
    }

    public final double offsetY() {
        return this.offsetY;
    }

    public final double offsetZ() {
        return this.offsetZ;
    }

    public final AxisAlignedBB getSingleAABBRepresentation() {
        return this.singleAABBRepresentation;
    }

    public final double[] rootCoordinatesX() {
        return this.rootCoordinatesX;
    }

    public final double[] rootCoordinatesY() {
        return this.rootCoordinatesY;
    }

    public final double[] rootCoordinatesZ() {
        return this.rootCoordinatesZ;
    }

    private static double[] extractRawArray(DoubleList list) {
        if (list instanceof DoubleArrayList) {
            int expected;
            DoubleArrayList rawList = (DoubleArrayList)list;
            double[] raw = rawList.elements();
            if (raw.length == (expected = rawList.size())) {
                return raw;
            }
            return Arrays.copyOf(raw, expected);
        }
        return list.toDoubleArray();
    }

    public final void initCache() {
        DoubleListOffset offsetDoubleList;
        this.cachedShapeData = this.a.getOrCreateCachedShapeData();
        this.isEmpty = this.cachedShapeData.isEmpty();
        DoubleList xList = this.a(EnumDirection.EnumAxis.a);
        DoubleList yList = this.a(EnumDirection.EnumAxis.b);
        DoubleList zList = this.a(EnumDirection.EnumAxis.c);
        if (xList instanceof DoubleListOffset) {
            offsetDoubleList = (DoubleListOffset)xList;
            this.offsetX = offsetDoubleList.b;
            this.rootCoordinatesX = VoxelShape.extractRawArray(offsetDoubleList.a);
        } else {
            this.rootCoordinatesX = VoxelShape.extractRawArray(xList);
        }
        if (yList instanceof DoubleListOffset) {
            offsetDoubleList = (DoubleListOffset)yList;
            this.offsetY = offsetDoubleList.b;
            this.rootCoordinatesY = VoxelShape.extractRawArray(offsetDoubleList.a);
        } else {
            this.rootCoordinatesY = VoxelShape.extractRawArray(yList);
        }
        if (zList instanceof DoubleListOffset) {
            offsetDoubleList = (DoubleListOffset)zList;
            this.offsetZ = offsetDoubleList.b;
            this.rootCoordinatesZ = VoxelShape.extractRawArray(offsetDoubleList.a);
        } else {
            this.rootCoordinatesZ = VoxelShape.extractRawArray(zList);
        }
        if (this.cachedShapeData.hasSingleAABB()) {
            this.cachedBounds = this.singleAABBRepresentation = new AxisAlignedBB(this.rootCoordinatesX[0] + this.offsetX, this.rootCoordinatesY[0] + this.offsetY, this.rootCoordinatesZ[0] + this.offsetZ, this.rootCoordinatesX[1] + this.offsetX, this.rootCoordinatesY[1] + this.offsetY, this.rootCoordinatesZ[1] + this.offsetZ);
        }
    }

    public final CachedShapeData getCachedVoxelData() {
        return this.cachedShapeData;
    }

    public final VoxelShape getFaceShapeClamped(EnumDirection direction) {
        VoxelShape ret;
        if (this.isEmpty) {
            return this;
        }
        if (this == VoxelShapes.b()) {
            return this;
        }
        VoxelShape[] cache = this.faceShapeClampedCache;
        if (cache != null && (ret = cache[direction.ordinal()]) != null) {
            return ret;
        }
        if (cache == null) {
            this.faceShapeClampedCache = cache = new VoxelShape[6];
        }
        EnumDirection.EnumAxis axis = direction.o();
        VoxelShape ret2 = direction.f() == EnumDirection.EnumAxisDirection.a ? (DoubleMath.fuzzyEquals((double)this.c(axis), (double)1.0, (double)1.0E-7) ? VoxelShape.tryForceBlock(new VoxelShapeSlice(this, axis, this.a.c(axis) - 1)) : VoxelShapes.a()) : (DoubleMath.fuzzyEquals((double)this.b(axis), (double)0.0, (double)1.0E-7) ? VoxelShape.tryForceBlock(new VoxelShapeSlice(this, axis, 0)) : VoxelShapes.a());
        cache[direction.ordinal()] = ret2;
        return ret2;
    }

    private static VoxelShape tryForceBlock(VoxelShape other) {
        if (other == VoxelShapes.b()) {
            return other;
        }
        AxisAlignedBB otherAABB = other.getSingleAABBRepresentation();
        if (otherAABB == null) {
            return other;
        }
        if (VoxelShapes.b().getSingleAABBRepresentation().equals(otherAABB)) {
            return VoxelShapes.b();
        }
        return other;
    }

    private boolean computeOccludesFullBlock() {
        if (this.isEmpty) {
            this.occludesFullBlock = Boolean.FALSE;
            return false;
        }
        if (this.isFullBlock()) {
            this.occludesFullBlock = Boolean.TRUE;
            return true;
        }
        AxisAlignedBB singleAABB = this.singleAABBRepresentation;
        if (singleAABB != null) {
            boolean ret = singleAABB.b <= 1.0E-7 && singleAABB.e >= 0.9999999 && singleAABB.a <= 1.0E-7 && singleAABB.d >= 0.9999999 && singleAABB.c <= 1.0E-7 && singleAABB.f >= 0.9999999;
            this.occludesFullBlock = ret;
            return ret;
        }
        boolean ret = !VoxelShapes.c(VoxelShapes.b(), this, OperatorBoolean.e);
        this.occludesFullBlock = ret;
        return ret;
    }

    public final boolean occludesFullBlock() {
        Boolean ret = this.occludesFullBlock;
        if (ret != null) {
            return ret;
        }
        return this.computeOccludesFullBlock();
    }

    public final boolean occludesFullBlockIfCached() {
        Boolean ret = this.occludesFullBlock;
        return ret != null ? ret : false;
    }

    private static int hash(VoxelShape key) {
        return HashCommon.mix((int)System.identityHashCode(key));
    }

    public final VoxelShape orUnoptimized(VoxelShape other) {
        MergedORCache otherCache;
        MergedORCache cached;
        if (this == other) {
            return other;
        }
        if (this.isEmpty) {
            return other;
        }
        if (other.c()) {
            return this;
        }
        int thisCacheKey = VoxelShape.hash(other) & 0xF;
        MergedORCache mergedORCache = cached = this.mergedORCache == null ? null : this.mergedORCache[thisCacheKey];
        if (cached != null && cached.key() == other) {
            return cached.result();
        }
        int otherCacheKey = VoxelShape.hash(this) & 0xF;
        MergedORCache mergedORCache2 = otherCache = other.mergedORCache == null ? null : other.mergedORCache[otherCacheKey];
        if (otherCache != null && otherCache.key() == this) {
            return otherCache.result();
        }
        VoxelShape result = VoxelShapes.b(this, other, OperatorBoolean.o);
        if (cached != null && otherCache == null) {
            if (other.mergedORCache == null) {
                other.mergedORCache = new MergedORCache[16];
            }
            other.mergedORCache[otherCacheKey] = new MergedORCache(this, result);
        } else {
            if (this.mergedORCache == null) {
                this.mergedORCache = new MergedORCache[16];
            }
            this.mergedORCache[thisCacheKey] = new MergedORCache(other, result);
        }
        return result;
    }

    private boolean computeFullBlock() {
        Boolean ret;
        block10: {
            if (this.isEmpty) {
                ret = Boolean.FALSE;
            } else if (this == VoxelShapes.b()) {
                ret = Boolean.TRUE;
            } else {
                AxisAlignedBB singleAABB = this.singleAABBRepresentation;
                if (singleAABB == null) {
                    CachedShapeData shapeData = this.cachedShapeData;
                    int sMinX = shapeData.minFullX();
                    int sMinY = shapeData.minFullY();
                    int sMinZ = shapeData.minFullZ();
                    int sMaxX = shapeData.maxFullX();
                    int sMaxY = shapeData.maxFullY();
                    int sMaxZ = shapeData.maxFullZ();
                    if (Math.abs(this.rootCoordinatesX[sMinX] + this.offsetX) <= 1.0E-7 && Math.abs(this.rootCoordinatesY[sMinY] + this.offsetY) <= 1.0E-7 && Math.abs(this.rootCoordinatesZ[sMinZ] + this.offsetZ) <= 1.0E-7 && Math.abs(1.0 - (this.rootCoordinatesX[sMaxX] + this.offsetX)) <= 1.0E-7 && Math.abs(1.0 - (this.rootCoordinatesY[sMaxY] + this.offsetY)) <= 1.0E-7 && Math.abs(1.0 - (this.rootCoordinatesZ[sMaxZ] + this.offsetZ)) <= 1.0E-7) {
                        int sizeY = shapeData.sizeY();
                        int sizeZ = shapeData.sizeZ();
                        long[] bitset = shapeData.voxelSet();
                        ret = Boolean.TRUE;
                        for (int x2 = sMinX; x2 < sMaxX; ++x2) {
                            for (int y2 = sMinY; y2 < sMaxY; ++y2) {
                                int baseIndex = y2 * sizeZ + x2 * (sizeZ * sizeY);
                                if (FlatBitsetUtil.isRangeSet(bitset, baseIndex + sMinZ, baseIndex + sMaxZ)) continue;
                                ret = Boolean.FALSE;
                                break block10;
                            }
                        }
                    } else {
                        ret = Boolean.FALSE;
                    }
                } else {
                    ret = Math.abs(singleAABB.a) <= 1.0E-7 && Math.abs(singleAABB.b) <= 1.0E-7 && Math.abs(singleAABB.c) <= 1.0E-7 && Math.abs(1.0 - singleAABB.d) <= 1.0E-7 && Math.abs(1.0 - singleAABB.e) <= 1.0E-7 && Math.abs(1.0 - singleAABB.f) <= 1.0E-7;
                }
            }
        }
        this.isFullBlock = ret;
        return ret;
    }

    public boolean isFullBlock() {
        Boolean ret = this.isFullBlock;
        if (ret != null) {
            return ret;
        }
        return this.computeFullBlock();
    }

    protected VoxelShape(VoxelShapeDiscrete voxels) {
        this.a = voxels;
    }

    public double b(EnumDirection.EnumAxis axis) {
        CachedShapeData shapeData = this.cachedShapeData;
        switch (axis) {
            case a: {
                int idx = shapeData.minFullX();
                return idx >= shapeData.sizeX() ? Double.POSITIVE_INFINITY : this.rootCoordinatesX[idx] + this.offsetX;
            }
            case b: {
                int idx = shapeData.minFullY();
                return idx >= shapeData.sizeY() ? Double.POSITIVE_INFINITY : this.rootCoordinatesY[idx] + this.offsetY;
            }
            case c: {
                int idx = shapeData.minFullZ();
                return idx >= shapeData.sizeZ() ? Double.POSITIVE_INFINITY : this.rootCoordinatesZ[idx] + this.offsetZ;
            }
        }
        return Double.POSITIVE_INFINITY;
    }

    public double c(EnumDirection.EnumAxis axis) {
        CachedShapeData shapeData = this.cachedShapeData;
        switch (axis) {
            case a: {
                int idx = shapeData.maxFullX();
                return idx <= 0 ? Double.NEGATIVE_INFINITY : this.rootCoordinatesX[idx] + this.offsetX;
            }
            case b: {
                int idx = shapeData.maxFullY();
                return idx <= 0 ? Double.NEGATIVE_INFINITY : this.rootCoordinatesY[idx] + this.offsetY;
            }
            case c: {
                int idx = shapeData.maxFullZ();
                return idx <= 0 ? Double.NEGATIVE_INFINITY : this.rootCoordinatesZ[idx] + this.offsetZ;
            }
        }
        return Double.NEGATIVE_INFINITY;
    }

    public AxisAlignedBB a() {
        if (this.isEmpty) {
            throw SystemUtils.b(new UnsupportedOperationException("No bounds for empty shape."));
        }
        AxisAlignedBB cached = this.cachedBounds;
        if (cached != null) {
            return cached;
        }
        CachedShapeData shapeData = this.cachedShapeData;
        double[] coordsX = this.rootCoordinatesX;
        double[] coordsY = this.rootCoordinatesY;
        double[] coordsZ = this.rootCoordinatesZ;
        double offX = this.offsetX;
        double offY = this.offsetY;
        double offZ = this.offsetZ;
        this.cachedBounds = cached = new AxisAlignedBB(coordsX[shapeData.minFullX()] + offX, coordsY[shapeData.minFullY()] + offY, coordsZ[shapeData.minFullZ()] + offZ, coordsX[shapeData.maxFullX()] + offX, coordsY[shapeData.maxFullY()] + offY, coordsZ[shapeData.maxFullZ()] + offZ);
        return cached;
    }

    public VoxelShape b() {
        return this.c() ? VoxelShapes.a() : VoxelShapes.a(this.b(EnumDirection.EnumAxis.a), this.b(EnumDirection.EnumAxis.b), this.b(EnumDirection.EnumAxis.c), this.c(EnumDirection.EnumAxis.a), this.c(EnumDirection.EnumAxis.b), this.c(EnumDirection.EnumAxis.c));
    }

    protected double a(EnumDirection.EnumAxis axis, int index) {
        return this.a(axis).getDouble(index);
    }

    protected abstract DoubleList a(EnumDirection.EnumAxis var1);

    public boolean c() {
        return this.isEmpty;
    }

    private static DoubleList offsetList(DoubleList src, double by) {
        if (src instanceof DoubleListOffset) {
            DoubleListOffset offsetDoubleList = (DoubleListOffset)src;
            return new DoubleListOffset(offsetDoubleList.a, by + offsetDoubleList.b);
        }
        return new DoubleListOffset(src, by);
    }

    public VoxelShape a(double x2, double y2, double z2) {
        if (this.isEmpty) {
            return VoxelShapes.a();
        }
        VoxelShapeArray ret = new VoxelShapeArray(this.a, VoxelShape.offsetList(this.a(EnumDirection.EnumAxis.a), x2), VoxelShape.offsetList(this.a(EnumDirection.EnumAxis.b), y2), VoxelShape.offsetList(this.a(EnumDirection.EnumAxis.c), z2));
        CachedToAABBs cachedToAABBs = this.cachedToAABBs;
        if (cachedToAABBs != null) {
            ret.cachedToAABBs = CachedToAABBs.offset(cachedToAABBs, x2, y2, z2);
        }
        return ret;
    }

    public VoxelShape d() {
        if (this.isEmpty) {
            return VoxelShapes.a();
        }
        if (this.singleAABBRepresentation != null) {
            return this.isFullBlock() ? VoxelShapes.b() : this;
        }
        List<AxisAlignedBB> aabbs = this.e();
        if (aabbs.size() == 1) {
            AxisAlignedBB singleAABB = aabbs.get(0);
            VoxelShape ret = VoxelShapes.a(singleAABB);
            if (ret.cachedToAABBs == null) {
                ret.cachedToAABBs = this.cachedToAABBs;
            }
            return ret;
        }
        VoxelShape[] tmp = new VoxelShape[aabbs.size()];
        int len = aabbs.size();
        for (int i2 = 0; i2 < len; ++i2) {
            tmp[i2] = VoxelShapes.a(aabbs.get(i2));
        }
        int size = aabbs.size();
        while (size > 1) {
            int newSize = 0;
            for (int i3 = 0; i3 < size; i3 += 2) {
                int next = i3 + 1;
                if (next >= size) {
                    tmp[newSize++] = tmp[i3];
                    break;
                }
                VoxelShape first = tmp[i3];
                VoxelShape second = tmp[next];
                tmp[newSize++] = VoxelShapes.b(first, second, OperatorBoolean.o);
            }
            size = newSize;
        }
        VoxelShape ret = tmp[0];
        if (ret.cachedToAABBs == null) {
            ret.cachedToAABBs = this.cachedToAABBs;
        }
        return ret;
    }

    public void a(VoxelShapes.a consumer) {
        this.a.a((int minX, int minY, int minZ, int maxX, int maxY, int maxZ) -> consumer.consume(this.a(EnumDirection.EnumAxis.a, minX), this.a(EnumDirection.EnumAxis.b, minY), this.a(EnumDirection.EnumAxis.c, minZ), this.a(EnumDirection.EnumAxis.a, maxX), this.a(EnumDirection.EnumAxis.b, maxY), this.a(EnumDirection.EnumAxis.c, maxZ)), true);
    }

    public void b(VoxelShapes.a consumer) {
        DoubleList doubleList = this.a(EnumDirection.EnumAxis.a);
        DoubleList doubleList2 = this.a(EnumDirection.EnumAxis.b);
        DoubleList doubleList3 = this.a(EnumDirection.EnumAxis.c);
        this.a.b((minX, minY, minZ, maxX, maxY, maxZ) -> consumer.consume(doubleList.getDouble(minX), doubleList2.getDouble(minY), doubleList3.getDouble(minZ), doubleList.getDouble(maxX), doubleList2.getDouble(maxY), doubleList3.getDouble(maxZ)), true);
    }

    private List<AxisAlignedBB> toAabbsUncached() {
        ArrayList<AxisAlignedBB> ret = new ArrayList<AxisAlignedBB>();
        if (this.singleAABBRepresentation != null) {
            ret.add(this.singleAABBRepresentation);
        } else {
            this.b((double minX, double minY, double minZ, double maxX, double maxY, double maxZ) -> ret.add(new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ)));
        }
        this.cachedToAABBs = new CachedToAABBs(ret, false, 0.0, 0.0, 0.0);
        return ret;
    }

    public List<AxisAlignedBB> e() {
        CachedToAABBs cachedToAABBs = this.cachedToAABBs;
        if (cachedToAABBs != null) {
            if (!cachedToAABBs.isOffset()) {
                return cachedToAABBs.aabbs();
            }
            this.cachedToAABBs = cachedToAABBs = cachedToAABBs.removeOffset();
            return cachedToAABBs.aabbs();
        }
        return this.toAabbsUncached();
    }

    public double a(EnumDirection.EnumAxis axis, double from, double to) {
        int j2;
        EnumDirection.EnumAxis axis2 = EnumAxisCycle.b.a(axis);
        EnumDirection.EnumAxis axis3 = EnumAxisCycle.c.a(axis);
        int i2 = this.a(axis2, from);
        int k2 = this.a.a(axis, i2, j2 = this.a(axis3, to));
        return k2 >= this.a.c(axis) ? Double.POSITIVE_INFINITY : this.a(axis, k2);
    }

    public double b(EnumDirection.EnumAxis axis, double from, double to) {
        int j2;
        EnumDirection.EnumAxis axis2 = EnumAxisCycle.b.a(axis);
        EnumDirection.EnumAxis axis3 = EnumAxisCycle.c.a(axis);
        int i2 = this.a(axis2, from);
        int k2 = this.a.b(axis, i2, j2 = this.a(axis3, to));
        return k2 <= 0 ? Double.NEGATIVE_INFINITY : this.a(axis, k2);
    }

    protected int a(EnumDirection.EnumAxis axis, double coord) {
        return MathHelper.a(0, this.a.c(axis) + 1, i2 -> coord < this.a(axis, i2)) - 1;
    }

    private static MovingObjectPositionBlock clip(AxisAlignedBB aabb, Vec3D from, Vec3D to, BlockPosition offset) {
        double[] minDistanceArr = new double[]{1.0};
        double diffX = to.c - from.c;
        double diffY = to.d - from.d;
        double diffZ = to.e - from.e;
        EnumDirection direction = AxisAlignedBB.a(aabb.a(offset), from, minDistanceArr, null, diffX, diffY, diffZ);
        if (direction == null) {
            return null;
        }
        double minDistance = minDistanceArr[0];
        return new MovingObjectPositionBlock(from.b(minDistance * diffX, minDistance * diffY, minDistance * diffZ), direction, offset, false);
    }

    @Nullable
    public MovingObjectPositionBlock a(Vec3D start, Vec3D end, BlockPosition pos) {
        if (this.isEmpty) {
            return null;
        }
        Vec3D directionOpposite = end.d(start);
        if (directionOpposite.g() < 1.0E-7) {
            return null;
        }
        Vec3D fromBehind = start.e(directionOpposite.a(0.001));
        double fromBehindOffsetX = fromBehind.c - (double)pos.u();
        double fromBehindOffsetY = fromBehind.d - (double)pos.v();
        double fromBehindOffsetZ = fromBehind.e - (double)pos.w();
        AxisAlignedBB singleAABB = this.singleAABBRepresentation;
        if (singleAABB != null) {
            if (singleAABB.e(fromBehindOffsetX, fromBehindOffsetY, fromBehindOffsetZ)) {
                return new MovingObjectPositionBlock(fromBehind, EnumDirection.a(directionOpposite.c, directionOpposite.d, directionOpposite.e).g(), pos, true);
            }
            return VoxelShape.clip(singleAABB, start, end, pos);
        }
        if (CollisionUtil.strictlyContains(this, fromBehindOffsetX, fromBehindOffsetY, fromBehindOffsetZ)) {
            return new MovingObjectPositionBlock(fromBehind, EnumDirection.a(directionOpposite.c, directionOpposite.d, directionOpposite.e).g(), pos, true);
        }
        return AxisAlignedBB.a(this.e(), start, end, pos);
    }

    public Optional<Vec3D> a(Vec3D target) {
        if (this.isEmpty) {
            return Optional.empty();
        }
        Vec3D ret = null;
        double retDistance = Double.MAX_VALUE;
        List<AxisAlignedBB> aabbs = this.e();
        int len = aabbs.size();
        for (int i2 = 0; i2 < len; ++i2) {
            double z2;
            double y2;
            AxisAlignedBB aabb = aabbs.get(i2);
            double x2 = MathHelper.a(target.c, aabb.a, aabb.d);
            double dist = target.c(x2, y2 = MathHelper.a(target.d, aabb.b, aabb.e), z2 = MathHelper.a(target.e, aabb.c, aabb.f));
            if (!(dist < retDistance)) continue;
            ret = new Vec3D(x2, y2, z2);
            retDistance = dist;
        }
        return Optional.ofNullable(ret);
    }

    public VoxelShape a(EnumDirection facing) {
        if (!this.c() && this != VoxelShapes.b()) {
            VoxelShape voxelShape2;
            if (this.b != null) {
                VoxelShape voxelShape = this.b[facing.ordinal()];
                if (voxelShape != null) {
                    return voxelShape;
                }
            } else {
                this.b = new VoxelShape[6];
            }
            this.b[facing.ordinal()] = voxelShape2 = this.b(facing);
            return voxelShape2;
        }
        return this;
    }

    private VoxelShape b(EnumDirection direction) {
        EnumDirection.EnumAxis axis = direction.o();
        DoubleList doubleList = this.a(axis);
        if (doubleList.size() == 2 && DoubleMath.fuzzyEquals((double)doubleList.getDouble(0), (double)0.0, (double)1.0E-7) && DoubleMath.fuzzyEquals((double)doubleList.getDouble(1), (double)1.0, (double)1.0E-7)) {
            return this;
        }
        EnumDirection.EnumAxisDirection axisDirection = direction.f();
        int i2 = this.a(axis, axisDirection == EnumDirection.EnumAxisDirection.a ? 0.9999999 : 1.0E-7);
        return new VoxelShapeSlice(this, axis, i2);
    }

    public double a(EnumDirection.EnumAxis axis, AxisAlignedBB box, double maxDist) {
        if (this.isEmpty) {
            return maxDist;
        }
        if (Math.abs(maxDist) < 1.0E-7) {
            return 0.0;
        }
        switch (axis) {
            case a: {
                return CollisionUtil.collideX(this, box, maxDist);
            }
            case b: {
                return CollisionUtil.collideY(this, box, maxDist);
            }
            case c: {
                return CollisionUtil.collideZ(this, box, maxDist);
            }
        }
        throw new RuntimeException("Unknown axis: " + axis);
    }

    protected double a(EnumAxisCycle axisCycle, AxisAlignedBB box, double maxDist) {
        block11: {
            int n2;
            int l2;
            double e2;
            EnumDirection.EnumAxis axis;
            EnumAxisCycle axisCycle2;
            block10: {
                if (this.c()) {
                    return maxDist;
                }
                if (Math.abs(maxDist) < 1.0E-7) {
                    return 0.0;
                }
                axisCycle2 = axisCycle.a();
                axis = axisCycle2.a(EnumDirection.EnumAxis.a);
                EnumDirection.EnumAxis axis2 = axisCycle2.a(EnumDirection.EnumAxis.b);
                EnumDirection.EnumAxis axis3 = axisCycle2.a(EnumDirection.EnumAxis.c);
                double d2 = box.b(axis);
                e2 = box.a(axis);
                int i2 = this.a(axis, e2 + 1.0E-7);
                int j2 = this.a(axis, d2 - 1.0E-7);
                int k2 = Math.max(0, this.a(axis2, box.a(axis2) + 1.0E-7));
                l2 = Math.min(this.a.c(axis2), this.a(axis2, box.b(axis2) - 1.0E-7) + 1);
                int m2 = Math.max(0, this.a(axis3, box.a(axis3) + 1.0E-7));
                n2 = Math.min(this.a.c(axis3), this.a(axis3, box.b(axis3) - 1.0E-7) + 1);
                int o2 = this.a.c(axis);
                if (!(maxDist > 0.0)) break block10;
                for (int p2 = j2 + 1; p2 < o2; ++p2) {
                    for (int q2 = k2; q2 < l2; ++q2) {
                        for (int r2 = m2; r2 < n2; ++r2) {
                            if (!this.a.a(axisCycle2, p2, q2, r2)) continue;
                            double f2 = this.a(axis, p2) - d2;
                            if (f2 >= -1.0E-7) {
                                maxDist = Math.min(maxDist, f2);
                            }
                            return maxDist;
                        }
                    }
                }
                break block11;
            }
            if (!(maxDist < 0.0)) break block11;
            for (int s2 = i2 - 1; s2 >= 0; --s2) {
                for (int t2 = k2; t2 < l2; ++t2) {
                    for (int u2 = m2; u2 < n2; ++u2) {
                        if (!this.a.a(axisCycle2, s2, t2, u2)) continue;
                        double g2 = this.a(axis, s2 + 1) - e2;
                        if (g2 <= 1.0E-7) {
                            maxDist = Math.max(maxDist, g2);
                        }
                        return maxDist;
                    }
                }
            }
        }
        return maxDist;
    }

    public String toString() {
        return this.c() ? "EMPTY" : "VoxelShape[" + this.a() + "]";
    }
}

