/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.scores;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardScore;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.slf4j.Logger;

public class Scoreboard {
    private static final Logger a = LogUtils.getLogger();
    private final Map<String, ScoreboardObjective> b = Maps.newHashMap();
    private final Map<IScoreboardCriteria, List<ScoreboardObjective>> c = Maps.newHashMap();
    private final Map<String, Map<ScoreboardObjective, ScoreboardScore>> d = Maps.newHashMap();
    private final Map<DisplaySlot, ScoreboardObjective> e = new EnumMap<DisplaySlot, ScoreboardObjective>(DisplaySlot.class);
    private final Map<String, ScoreboardTeam> f = Maps.newHashMap();
    private final Map<String, ScoreboardTeam> g = Maps.newHashMap();

    @Nullable
    public ScoreboardObjective b(@Nullable String name) {
        return this.b.get(name);
    }

    public ScoreboardObjective a(String name, IScoreboardCriteria criterion, IChatBaseComponent displayName, IScoreboardCriteria.EnumScoreboardHealthDisplay renderType) {
        if (this.b.containsKey(name)) {
            throw new IllegalArgumentException("An objective with the name '" + name + "' already exists!");
        }
        ScoreboardObjective objective = new ScoreboardObjective(this, name, criterion, displayName, renderType);
        this.c.computeIfAbsent(criterion, criterionx -> Lists.newArrayList()).add(objective);
        this.b.put(name, objective);
        this.a(objective);
        return objective;
    }

    public final void a(IScoreboardCriteria criterion, String player, Consumer<ScoreboardScore> action) {
        this.c.getOrDefault(criterion, Collections.emptyList()).forEach(objective -> action.accept(this.c(player, (ScoreboardObjective)objective)));
    }

    public boolean b(String playerName, ScoreboardObjective objective) {
        Map<ScoreboardObjective, ScoreboardScore> map = this.d.get(playerName);
        if (map == null) {
            return false;
        }
        ScoreboardScore score = map.get(objective);
        return score != null;
    }

    public ScoreboardScore c(String playerName, ScoreboardObjective objective) {
        Map map = this.d.computeIfAbsent(playerName, name -> Maps.newHashMap());
        return map.computeIfAbsent(objective, objectivex -> {
            ScoreboardScore score = new ScoreboardScore(this, (ScoreboardObjective)objectivex, playerName);
            score.b(0);
            return score;
        });
    }

    public Collection<ScoreboardScore> i(ScoreboardObjective objective) {
        ArrayList list = Lists.newArrayList();
        for (Map<ScoreboardObjective, ScoreboardScore> map : this.d.values()) {
            ScoreboardScore score = map.get(objective);
            if (score == null) continue;
            list.add(score);
        }
        list.sort(ScoreboardScore.a);
        return list;
    }

    public Collection<ScoreboardObjective> c() {
        return this.b.values();
    }

    public Collection<String> d() {
        return this.b.keySet();
    }

    public Collection<String> e() {
        return Lists.newArrayList(this.d.keySet());
    }

    public void d(String playerName, @Nullable ScoreboardObjective objective) {
        if (objective == null) {
            Map<ScoreboardObjective, ScoreboardScore> map = this.d.remove(playerName);
            if (map != null) {
                this.a(playerName);
            }
        } else {
            Map<ScoreboardObjective, ScoreboardScore> map2 = this.d.get(playerName);
            if (map2 != null) {
                ScoreboardScore score = map2.remove(objective);
                if (map2.size() < 1) {
                    Map<ScoreboardObjective, ScoreboardScore> map3 = this.d.remove(playerName);
                    if (map3 != null) {
                        this.a(playerName);
                    }
                } else if (score != null) {
                    this.a(playerName, objective);
                }
            }
        }
    }

    public Map<ScoreboardObjective, ScoreboardScore> c(String playerName) {
        HashMap map = this.d.get(playerName);
        if (map == null) {
            map = Maps.newHashMap();
        }
        return map;
    }

    public void j(ScoreboardObjective objective) {
        this.b.remove(objective.b());
        for (DisplaySlot displaySlot : DisplaySlot.values()) {
            if (this.a(displaySlot) != objective) continue;
            this.a(displaySlot, null);
        }
        List<ScoreboardObjective> list = this.c.get(objective.c());
        if (list != null) {
            list.remove(objective);
        }
        for (Map<ScoreboardObjective, ScoreboardScore> map : this.d.values()) {
            map.remove(objective);
        }
        this.c(objective);
    }

    public void a(DisplaySlot slot, @Nullable ScoreboardObjective objective) {
        this.e.put(slot, objective);
    }

    @Nullable
    public ScoreboardObjective a(DisplaySlot slot) {
        return this.e.get(slot);
    }

    @Nullable
    public ScoreboardTeam d(String name) {
        return this.f.get(name);
    }

    public ScoreboardTeam e(String name) {
        ScoreboardTeam playerTeam = this.d(name);
        if (playerTeam != null) {
            a.warn("Requested creation of existing team '{}'", (Object)name);
            return playerTeam;
        }
        playerTeam = new ScoreboardTeam(this, name);
        this.f.put(name, playerTeam);
        this.a(playerTeam);
        return playerTeam;
    }

    public void d(ScoreboardTeam team) {
        this.f.remove(team.b());
        for (String string : team.g()) {
            this.g.remove(string);
        }
        this.c(team);
    }

    public boolean a(String playerName, ScoreboardTeam team) {
        if (this.g(playerName) != null) {
            this.f(playerName);
        }
        this.g.put(playerName, team);
        return team.g().add(playerName);
    }

    public boolean f(String playerName) {
        ScoreboardTeam playerTeam = this.g(playerName);
        if (playerTeam != null) {
            this.b(playerName, playerTeam);
            return true;
        }
        return false;
    }

    public void b(String playerName, ScoreboardTeam team) {
        if (this.g(playerName) != team) {
            throw new IllegalStateException("Player is either on another team or not on any team. Cannot remove from team '" + team.b() + "'.");
        }
        this.g.remove(playerName);
        team.g().remove(playerName);
    }

    public Collection<String> f() {
        return this.f.keySet();
    }

    public Collection<ScoreboardTeam> g() {
        return this.f.values();
    }

    @Nullable
    public ScoreboardTeam g(String playerName) {
        return this.g.get(playerName);
    }

    public void a(ScoreboardObjective objective) {
    }

    public void b(ScoreboardObjective objective) {
    }

    public void c(ScoreboardObjective objective) {
    }

    public void a(ScoreboardScore score) {
    }

    public void a(String playerName) {
    }

    public void a(String playerName, ScoreboardObjective objective) {
    }

    public void a(ScoreboardTeam team) {
    }

    public void b(ScoreboardTeam team) {
    }

    public void c(ScoreboardTeam team) {
    }

    public void a(Entity entity) {
        if (entity instanceof EntityHuman || entity.bv()) {
            return;
        }
        String string = entity.cw();
        this.d(string, null);
        this.f(string);
    }

    protected NBTTagList h() {
        NBTTagList listTag = new NBTTagList();
        this.d.values().stream().map(Map::values).forEach(scores -> scores.forEach(score -> {
            NBTTagCompound compoundTag = new NBTTagCompound();
            compoundTag.a("Name", score.e());
            compoundTag.a("Objective", score.d().b());
            compoundTag.a("Score", score.b());
            compoundTag.a("Locked", score.g());
            listTag.add(compoundTag);
        }));
        return listTag;
    }

    protected void a(NBTTagList list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            NBTTagCompound compoundTag = list.a(i2);
            String string = compoundTag.l("Name");
            String string2 = compoundTag.l("Objective");
            ScoreboardObjective objective = this.b(string2);
            if (objective == null) {
                a.error("Unknown objective {} for name {}, ignoring", (Object)string2, (Object)string);
                continue;
            }
            ScoreboardScore score = this.c(string, objective);
            score.b(compoundTag.h("Score"));
            if (!compoundTag.e("Locked")) continue;
            score.a(compoundTag.q("Locked"));
        }
    }
}

