/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R2;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import io.papermc.paper.util.CoordinateUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.NibbleArray;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.lighting.LevelLightEngine;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_20_R2.CraftChunkSnapshot;
import org.bukkit.craftbukkit.v1_20_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R2.block.CraftBiome;
import org.bukkit.craftbukkit.v1_20_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R2.block.data.CraftBlockData;
import org.bukkit.entity.Entity;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;

public class CraftChunk
implements Chunk {
    private final WorldServer worldServer;
    private final int x;
    private final int z;
    private static final DataPaletteBlock<IBlockData> emptyBlockIDs = new DataPaletteBlock<IBlockData>(Block.o, Blocks.a.n(), DataPaletteBlock.d.d, null);
    private static final byte[] FULL_LIGHT = new byte[2048];
    private static final byte[] EMPTY_LIGHT = new byte[2048];

    public CraftChunk(net.minecraft.world.level.chunk.Chunk chunk) {
        this.worldServer = chunk.r;
        this.x = chunk.f().e;
        this.z = chunk.f().f;
    }

    public CraftChunk(WorldServer worldServer, int x2, int z2) {
        this.worldServer = worldServer;
        this.x = x2;
        this.z = z2;
    }

    public World getWorld() {
        return this.worldServer.getWorld();
    }

    public CraftWorld getCraftWorld() {
        return (CraftWorld)this.getWorld();
    }

    public IChunkAccess getHandle(ChunkStatus chunkStatus) {
        IChunkAccess chunkAccess = this.worldServer.a(this.x, this.z, chunkStatus);
        if (chunkAccess instanceof ProtoChunkExtension) {
            ProtoChunkExtension extension = (ProtoChunkExtension)chunkAccess;
            return extension.C();
        }
        return chunkAccess;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public String toString() {
        return "CraftChunk{x=" + this.getX() + "z=" + this.getZ() + "}";
    }

    public org.bukkit.block.Block getBlock(int x2, int y2, int z2) {
        CraftChunk.validateChunkCoordinates(this.worldServer.H_(), this.worldServer.aj(), x2, y2, z2);
        return new CraftBlock(this.worldServer, new BlockPosition(this.x << 4 | x2, y2, this.z << 4 | z2));
    }

    public boolean isEntitiesLoaded() {
        return this.getCraftWorld().getHandle().c(CoordinateUtils.getChunkKey(this.x, this.z));
    }

    public Entity[] getEntities() {
        if (!this.isLoaded()) {
            this.getWorld().getChunkAt(this.x, this.z);
        }
        return this.getCraftWorld().getHandle().getChunkEntities(this.x, this.z);
    }

    public BlockState[] getTileEntities() {
        return this.getTileEntities(true);
    }

    public BlockState[] getTileEntities(boolean useSnapshot) {
        if (!this.isLoaded()) {
            this.getWorld().getChunkAt(this.x, this.z);
        }
        int index = 0;
        IChunkAccess chunk = this.getHandle(ChunkStatus.n);
        BlockState[] entities = new BlockState[chunk.k.size()];
        for (BlockPosition position : chunk.k.keySet()) {
            entities[index++] = this.worldServer.getWorld().getBlockAt(position.u(), position.v(), position.w()).getState(useSnapshot);
        }
        return entities;
    }

    public Collection<BlockState> getTileEntities(Predicate<? super org.bukkit.block.Block> blockPredicate, boolean useSnapshot) {
        Preconditions.checkNotNull(blockPredicate, (Object)"blockPredicate");
        if (!this.isLoaded()) {
            this.getWorld().getChunkAt(this.x, this.z);
        }
        IChunkAccess chunk = this.getHandle(ChunkStatus.n);
        ArrayList<BlockState> entities = new ArrayList<BlockState>();
        for (BlockPosition position : chunk.k.keySet()) {
            org.bukkit.block.Block block = this.worldServer.getWorld().getBlockAt(position.u(), position.v(), position.w());
            if (!blockPredicate.test((org.bukkit.block.Block)block)) continue;
            entities.add(block.getState(useSnapshot));
        }
        return entities;
    }

    public boolean isGenerated() {
        IChunkAccess chunk = this.getHandle(ChunkStatus.c);
        return chunk.j().b(ChunkStatus.n);
    }

    public boolean isLoaded() {
        return this.getWorld().isChunkLoaded((Chunk)this);
    }

    public boolean load() {
        return this.getWorld().loadChunk(this.getX(), this.getZ(), true);
    }

    public boolean load(boolean generate) {
        return this.getWorld().loadChunk(this.getX(), this.getZ(), generate);
    }

    public boolean unload() {
        return this.getWorld().unloadChunk(this.getX(), this.getZ());
    }

    public boolean isSlimeChunk() {
        return this.worldServer.paperConfig().entities.spawning.allChunksAreSlimeChunks || SeededRandom.a(this.getX(), this.getZ(), this.getWorld().getSeed(), this.worldServer.spigotConfig.slimeSeed).a(10) == 0;
    }

    public boolean unload(boolean save) {
        return this.getWorld().unloadChunk(this.getX(), this.getZ(), save);
    }

    public boolean isForceLoaded() {
        return this.getWorld().isChunkForceLoaded(this.getX(), this.getZ());
    }

    public void setForceLoaded(boolean forced) {
        this.getWorld().setChunkForceLoaded(this.getX(), this.getZ(), forced);
    }

    public boolean addPluginChunkTicket(Plugin plugin) {
        return this.getWorld().addPluginChunkTicket(this.getX(), this.getZ(), plugin);
    }

    public boolean removePluginChunkTicket(Plugin plugin) {
        return this.getWorld().removePluginChunkTicket(this.getX(), this.getZ(), plugin);
    }

    public Collection<Plugin> getPluginChunkTickets() {
        return this.getWorld().getPluginChunkTickets(this.getX(), this.getZ());
    }

    public long getInhabitedTime() {
        return this.getHandle(ChunkStatus.c).u();
    }

    public void setInhabitedTime(long ticks) {
        Preconditions.checkArgument((ticks >= 0L ? 1 : 0) != 0, (Object)"ticks cannot be negative");
        this.getHandle(ChunkStatus.d).b(ticks);
    }

    public boolean contains(BlockData block) {
        Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"Block cannot be null");
        com.google.common.base.Predicate nms = Predicates.equalTo((Object)((CraftBlockData)block).getState());
        for (ChunkSection section : this.getHandle(ChunkStatus.n).d()) {
            if (section == null || !section.h().a((Predicate<IBlockData>)nms)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Biome biome) {
        Preconditions.checkArgument((biome != null ? 1 : 0) != 0, (Object)"Biome cannot be null");
        IChunkAccess chunk = this.getHandle(ChunkStatus.f);
        com.google.common.base.Predicate nms = Predicates.equalTo(CraftBiome.bukkitToMinecraftHolder(biome));
        for (ChunkSection section : chunk.d()) {
            if (section == null || !section.i().a((Predicate<Holder<BiomeBase>>)nms)) continue;
            return true;
        }
        return false;
    }

    public ChunkSnapshot getChunkSnapshot() {
        return this.getChunkSnapshot(true, false, false);
    }

    public ChunkSnapshot getChunkSnapshot(boolean includeMaxBlockY, boolean includeBiome, boolean includeBiomeTempRain) {
        IChunkAccess chunk = this.getHandle(ChunkStatus.n);
        ChunkSection[] cs = chunk.d();
        DataPaletteBlock[] sectionBlockIDs = new DataPaletteBlock[cs.length];
        byte[][] sectionSkyLights = new byte[cs.length][];
        byte[][] sectionEmitLights = new byte[cs.length][];
        boolean[] sectionEmpty = new boolean[cs.length];
        DataPaletteBlock[] biome = includeBiome || includeBiomeTempRain ? new DataPaletteBlock[cs.length] : null;
        IRegistry<BiomeBase> iregistry = this.worldServer.G_().d(Registries.ap);
        for (int i2 = 0; i2 < cs.length; ++i2) {
            sectionEmpty[i2] = cs[i2].c();
            sectionBlockIDs[i2] = !sectionEmpty[i2] ? cs[i2].h().d() : emptyBlockIDs;
            LevelLightEngine lightengine = this.worldServer.x_();
            NibbleArray skyLightArray = lightengine.a(EnumSkyBlock.a).a(SectionPosition.a(this.x, chunk.g(i2), this.z));
            if (skyLightArray == null) {
                sectionSkyLights[i2] = this.worldServer.C_().g() ? FULL_LIGHT : EMPTY_LIGHT;
            } else {
                sectionSkyLights[i2] = new byte[2048];
                System.arraycopy(skyLightArray.a(), 0, sectionSkyLights[i2], 0, 2048);
            }
            NibbleArray emitLightArray = lightengine.a(EnumSkyBlock.b).a(SectionPosition.a(this.x, chunk.g(i2), this.z));
            if (emitLightArray == null) {
                sectionEmitLights[i2] = EMPTY_LIGHT;
            } else {
                sectionEmitLights[i2] = new byte[2048];
                System.arraycopy(emitLightArray.a(), 0, sectionEmitLights[i2], 0, 2048);
            }
            if (biome == null) continue;
            biome[i2] = ((DataPaletteBlock)cs[i2].i()).d();
        }
        HeightMap hmap = null;
        if (includeMaxBlockY) {
            hmap = new HeightMap(chunk, HeightMap.Type.e);
            hmap.a(chunk, HeightMap.Type.e, chunk.h.get(HeightMap.Type.e).a());
        }
        World world = this.getWorld();
        return new CraftChunkSnapshot(this.getX(), this.getZ(), chunk.H_(), chunk.aj(), world.getName(), world.getFullTime(), sectionBlockIDs, sectionSkyLights, sectionEmitLights, sectionEmpty, hmap, iregistry, biome);
    }

    public PersistentDataContainer getPersistentDataContainer() {
        return this.getHandle((ChunkStatus)ChunkStatus.d).persistentDataContainer;
    }

    public Chunk.LoadLevel getLoadLevel() {
        net.minecraft.world.level.chunk.Chunk chunk = this.worldServer.getChunkIfLoaded(this.getX(), this.getZ());
        if (chunk == null) {
            return Chunk.LoadLevel.UNLOADED;
        }
        return Chunk.LoadLevel.values()[chunk.D().ordinal()];
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        CraftChunk that = (CraftChunk)o2;
        if (this.x != that.x) {
            return false;
        }
        if (this.z != that.z) {
            return false;
        }
        return this.worldServer.equals(that.worldServer);
    }

    public int hashCode() {
        int result = this.worldServer.hashCode();
        result = 31 * result + this.x;
        result = 31 * result + this.z;
        return result;
    }

    public static ChunkSnapshot getEmptyChunkSnapshot(int x2, int z2, CraftWorld world, boolean includeBiome, boolean includeBiomeTempRain) {
        IChunkAccess actual = world.getHandle().a(x2, z2, includeBiome || includeBiomeTempRain ? ChunkStatus.f : ChunkStatus.c);
        int hSection = actual.ak();
        DataPaletteBlock[] blockIDs = new DataPaletteBlock[hSection];
        byte[][] skyLight = new byte[hSection][];
        byte[][] emitLight = new byte[hSection][];
        boolean[] empty = new boolean[hSection];
        IRegistry<BiomeBase> iregistry = world.getHandle().G_().d(Registries.ap);
        DataPaletteBlock[] biome = includeBiome || includeBiomeTempRain ? new DataPaletteBlock[hSection] : null;
        Codec<PalettedContainerRO<Holder.c<BiomeBase>>> biomeCodec = DataPaletteBlock.b(iregistry.t(), iregistry.r(), DataPaletteBlock.d.e, iregistry.f(Biomes.b));
        for (int i2 = 0; i2 < hSection; ++i2) {
            blockIDs[i2] = emptyBlockIDs;
            skyLight[i2] = world.getHandle().C_().g() ? FULL_LIGHT : EMPTY_LIGHT;
            emitLight[i2] = EMPTY_LIGHT;
            empty[i2] = true;
            if (biome == null) continue;
            biome[i2] = (DataPaletteBlock)biomeCodec.parse((DynamicOps)DynamicOpsNBT.a, (Object)((NBTBase)biomeCodec.encodeStart((DynamicOps)DynamicOpsNBT.a, actual.b(i2).i()).get().left().get())).get().left().get();
        }
        return new CraftChunkSnapshot(x2, z2, world.getMinHeight(), world.getMaxHeight(), world.getName(), world.getFullTime(), blockIDs, skyLight, emitLight, empty, new HeightMap(actual, HeightMap.Type.e), iregistry, biome);
    }

    static void validateChunkCoordinates(int minY, int maxY, int x2, int y2, int z2) {
        Preconditions.checkArgument((0 <= x2 && x2 <= 15 ? 1 : 0) != 0, (String)"x out of range (expected 0-15, got %s)", (int)x2);
        Preconditions.checkArgument((minY <= y2 && y2 <= maxY ? 1 : 0) != 0, (String)"y out of range (expected %s-%s, got %s)", (Object)minY, (Object)maxY, (Object)y2);
        Preconditions.checkArgument((0 <= z2 && z2 <= 15 ? 1 : 0) != 0, (String)"z out of range (expected 0-15, got %s)", (int)z2);
    }

    static {
        Arrays.fill(FULL_LIGHT, (byte)-1);
    }
}

