/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R2;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.raid.EntityRaider;
import org.bukkit.Location;
import org.bukkit.Raid;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftLocation;
import org.bukkit.entity.Raider;

public final class CraftRaid
implements Raid {
    private final net.minecraft.world.entity.raid.Raid handle;

    public CraftRaid(net.minecraft.world.entity.raid.Raid handle) {
        this.handle = handle;
    }

    public boolean isStarted() {
        return this.handle.j();
    }

    public long getActiveTicks() {
        return this.handle.B;
    }

    public int getBadOmenLevel() {
        return this.handle.H;
    }

    public void setBadOmenLevel(int badOmenLevel) {
        int max = this.handle.l();
        Preconditions.checkArgument((0 <= badOmenLevel && badOmenLevel <= max ? 1 : 0) != 0, (String)"Bad Omen level must be between 0 and %s", (int)max);
        this.handle.H = badOmenLevel;
    }

    public Location getLocation() {
        BlockPosition pos = this.handle.t();
        net.minecraft.world.level.World world = this.handle.i();
        return CraftLocation.toBukkit(pos, (World)world.getWorld());
    }

    public Raid.RaidStatus getStatus() {
        if (this.handle.d()) {
            return Raid.RaidStatus.STOPPED;
        }
        if (this.handle.e()) {
            return Raid.RaidStatus.VICTORY;
        }
        if (this.handle.f()) {
            return Raid.RaidStatus.LOSS;
        }
        return Raid.RaidStatus.ONGOING;
    }

    public int getSpawnedGroups() {
        return this.handle.k();
    }

    public int getTotalGroups() {
        return this.handle.O + (this.handle.H > 1 ? 1 : 0);
    }

    public int getTotalWaves() {
        return this.handle.O;
    }

    public float getTotalHealth() {
        return this.handle.q();
    }

    public Set<UUID> getHeroes() {
        return Collections.unmodifiableSet(this.handle.A);
    }

    public List<Raider> getRaiders() {
        return (List)this.handle.getRaiders().stream().map(new Function<EntityRaider, Raider>(){

            @Override
            public Raider apply(EntityRaider entityRaider) {
                return (Raider)entityRaider.getBukkitEntity();
            }
        }).collect(ImmutableList.toImmutableList());
    }

    public net.minecraft.world.entity.raid.Raid getHandle() {
        return this.handle;
    }
}

