/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R2.attribute;

import com.google.common.base.Preconditions;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.attribute.Attribute;
import org.bukkit.craftbukkit.v1_20_R2.CraftRegistry;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftNamespacedKey;

public class CraftAttribute {
    public static Attribute minecraftToBukkit(AttributeBase minecraft) {
        Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
        IRegistry registry = CraftRegistry.getMinecraftRegistry(Registries.b);
        Attribute bukkit = (Attribute)Registry.ATTRIBUTE.get(CraftNamespacedKey.fromMinecraft(registry.c(minecraft).orElseThrow().a()));
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return bukkit;
    }

    public static Attribute stringToBukkit(String bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return (Attribute)Registry.ATTRIBUTE.get(NamespacedKey.fromString((String)bukkit));
    }

    public static AttributeBase bukkitToMinecraft(Attribute bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return (AttributeBase)CraftRegistry.getMinecraftRegistry(Registries.b).b(CraftNamespacedKey.toMinecraft(bukkit.getKey())).orElseThrow();
    }
}

