/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R2.ban;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Set;
import net.minecraft.server.players.IpBanEntry;
import net.minecraft.server.players.IpBanList;
import org.bukkit.BanEntry;
import org.bukkit.craftbukkit.v1_20_R2.ban.CraftIpBanEntry;

public class CraftIpBanList
implements org.bukkit.ban.IpBanList {
    private final IpBanList list;

    public CraftIpBanList(IpBanList list) {
        this.list = list;
    }

    public BanEntry<InetAddress> getBanEntry(String target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Target cannot be null");
        IpBanEntry entry = (IpBanEntry)this.list.b(target);
        if (entry == null) {
            return null;
        }
        return new CraftIpBanEntry(target, entry, this.list);
    }

    public BanEntry<InetAddress> getBanEntry(InetAddress target) {
        return this.getBanEntry(this.getIpFromAddress(target));
    }

    public BanEntry<InetAddress> addBan(String target, String reason, Date expires, String source) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Ban target cannot be null");
        IpBanEntry entry = new IpBanEntry(target, new Date(), source == null || source.isBlank() ? null : source, expires, reason == null || reason.isBlank() ? null : reason);
        this.list.a(entry);
        return new CraftIpBanEntry(target, entry, this.list);
    }

    public BanEntry<InetAddress> addBan(InetAddress target, String reason, Date expires, String source) {
        return this.addBan(this.getIpFromAddress(target), reason, expires, source);
    }

    public BanEntry<InetAddress> addBan(InetAddress target, String reason, Instant expires, String source) {
        Date date = expires != null ? Date.from(expires) : null;
        return this.addBan(target, reason, date, source);
    }

    public BanEntry<InetAddress> addBan(InetAddress target, String reason, Duration duration, String source) {
        Instant instant = duration != null ? Instant.now().plus(duration) : null;
        return this.addBan(target, reason, instant, source);
    }

    public Set<BanEntry> getBanEntries() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String target : this.list.a()) {
            IpBanEntry ipBanEntry = (IpBanEntry)this.list.b(target);
            if (ipBanEntry == null) continue;
            builder.add((Object)new CraftIpBanEntry(target, ipBanEntry, this.list));
        }
        return builder.build();
    }

    public Set<BanEntry<InetAddress>> getEntries() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String target : this.list.a()) {
            IpBanEntry ipBanEntry = (IpBanEntry)this.list.b(target);
            if (ipBanEntry == null) continue;
            builder.add((Object)new CraftIpBanEntry(target, ipBanEntry, this.list));
        }
        return builder.build();
    }

    public boolean isBanned(String target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Target cannot be null");
        return this.list.a(target);
    }

    public boolean isBanned(InetAddress target) {
        return this.isBanned(this.getIpFromAddress(target));
    }

    public void pardon(String target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Target cannot be null");
        this.list.c(target);
    }

    public void pardon(InetAddress target) {
        this.pardon(this.getIpFromAddress(target));
    }

    private String getIpFromAddress(InetAddress address) {
        if (address == null) {
            return null;
        }
        return InetAddresses.toAddrString((InetAddress)address);
    }
}

