/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R2.block;

import com.google.common.base.Preconditions;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.level.block.BlockBannerAbstract;
import net.minecraft.world.level.block.entity.TileEntityBanner;
import org.bukkit.DyeColor;
import org.bukkit.World;
import org.bukkit.block.Banner;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.craftbukkit.v1_20_R2.block.CraftBlockEntityState;

public class CraftBanner
extends CraftBlockEntityState<TileEntityBanner>
implements Banner {
    private DyeColor base;
    private List<Pattern> patterns;

    public CraftBanner(World world, TileEntityBanner tileEntity) {
        super(world, tileEntity);
    }

    protected CraftBanner(CraftBanner state) {
        super(state);
    }

    @Override
    public void load(TileEntityBanner banner) {
        super.load(banner);
        this.base = DyeColor.getByWoolData((byte)((byte)((BlockBannerAbstract)this.data.b()).a().a()));
        this.patterns = new ArrayList<Pattern>();
        if (banner.g != null) {
            for (int i2 = 0; i2 < banner.g.size(); ++i2) {
                NBTTagCompound p2 = (NBTTagCompound)banner.g.k(i2);
                this.patterns.add(new Pattern(DyeColor.getByWoolData((byte)((byte)p2.h("Color"))), PatternType.getByIdentifier((String)p2.l("Pattern"))));
            }
        }
    }

    public DyeColor getBaseColor() {
        return this.base;
    }

    public void setBaseColor(DyeColor color) {
        Preconditions.checkArgument((color != null ? 1 : 0) != 0, (Object)"color");
        this.base = color;
    }

    public List<Pattern> getPatterns() {
        return new ArrayList<Pattern>(this.patterns);
    }

    public void setPatterns(List<Pattern> patterns) {
        this.patterns = new ArrayList<Pattern>(patterns);
    }

    public void addPattern(Pattern pattern) {
        this.patterns.add(pattern);
    }

    public Pattern getPattern(int i2) {
        return this.patterns.get(i2);
    }

    public Pattern removePattern(int i2) {
        return this.patterns.remove(i2);
    }

    public void setPattern(int i2, Pattern pattern) {
        this.patterns.set(i2, pattern);
    }

    public int numberOfPatterns() {
        return this.patterns.size();
    }

    @Override
    public void applyTo(TileEntityBanner banner) {
        super.applyTo(banner);
        banner.f = EnumColor.a(this.base.getWoolData());
        NBTTagList newPatterns = new NBTTagList();
        for (Pattern p2 : this.patterns) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.a("Color", (int)p2.getColor().getWoolData());
            compound.a("Pattern", p2.getPattern().getIdentifier());
            newPatterns.add(compound);
        }
        banner.g = newPatterns;
    }

    @Override
    public CraftBanner copy() {
        return new CraftBanner(this);
    }

    public Component customName() {
        return PaperAdventure.asAdventure(((TileEntityBanner)this.getSnapshot()).ad());
    }

    public void customName(Component customName) {
        ((TileEntityBanner)this.getSnapshot()).a(PaperAdventure.asVanilla(customName));
    }

    public String getCustomName() {
        return (String)LegacyComponentSerializer.legacySection().serializeOrNull(this.customName());
    }

    public void setCustomName(String name) {
        this.customName(LegacyComponentSerializer.legacySection().deserializeOrNull((Object)name));
    }
}

