/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R2.block;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Beehive;
import org.bukkit.craftbukkit.v1_20_R2.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftBee;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftLocation;
import org.bukkit.entity.Bee;

public class CraftBeehive
extends CraftBlockEntityState<TileEntityBeehive>
implements Beehive {
    public CraftBeehive(World world, TileEntityBeehive tileEntity) {
        super(world, tileEntity);
    }

    protected CraftBeehive(CraftBeehive state) {
        super(state);
    }

    public Location getFlower() {
        BlockPosition flower = ((TileEntityBeehive)this.getSnapshot()).m;
        return flower == null ? null : CraftLocation.toBukkit(flower, this.getWorld());
    }

    public void setFlower(Location location) {
        Preconditions.checkArgument((location == null || this.getWorld().equals(location.getWorld()) ? 1 : 0) != 0, (Object)"Flower must be in same world");
        ((TileEntityBeehive)this.getSnapshot()).m = location == null ? null : CraftLocation.toBlockPosition(location);
    }

    public boolean isFull() {
        return ((TileEntityBeehive)this.getSnapshot()).f();
    }

    public boolean isSedated() {
        return this.isPlaced() && ((TileEntityBeehive)this.getTileEntity()).i();
    }

    public int getEntityCount() {
        return ((TileEntityBeehive)this.getSnapshot()).g();
    }

    public int getMaxEntities() {
        return ((TileEntityBeehive)this.getSnapshot()).maxBees;
    }

    public void setMaxEntities(int max) {
        Preconditions.checkArgument((max > 0 ? 1 : 0) != 0, (Object)"Max bees must be more than 0");
        ((TileEntityBeehive)this.getSnapshot()).maxBees = max;
    }

    public List<Bee> releaseEntities() {
        this.ensureNoWorldGeneration();
        ArrayList<Bee> bees = new ArrayList<Bee>();
        if (this.isPlaced()) {
            TileEntityBeehive beehive = (TileEntityBeehive)this.getTileEntityFromWorld();
            for (Entity bee : beehive.releaseBees(this.getHandle(), TileEntityBeehive.ReleaseStatus.b, true)) {
                bees.add((Bee)bee.getBukkitEntity());
            }
        }
        return bees;
    }

    public void addEntity(Bee entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity must not be null");
        ((TileEntityBeehive)this.getSnapshot()).a(((CraftBee)entity).getHandle(), false);
    }

    @Override
    public CraftBeehive copy() {
        return new CraftBeehive(this);
    }

    public void clearEntities() {
        ((TileEntityBeehive)this.getSnapshot()).clearBees();
    }
}

