/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R2.block;

import com.google.common.base.Preconditions;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.DecoratedPot;
import org.bukkit.craftbukkit.v1_20_R2.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftMagicNumbers;

public class CraftDecoratedPot
extends CraftBlockEntityState<DecoratedPotBlockEntity>
implements DecoratedPot {
    public CraftDecoratedPot(World world, DecoratedPotBlockEntity tileEntity) {
        super(world, tileEntity);
    }

    protected CraftDecoratedPot(CraftDecoratedPot state) {
        super(state);
    }

    public void setSherd(DecoratedPot.Side face, Material sherd) {
        Preconditions.checkArgument((face != null ? 1 : 0) != 0, (Object)"face must not be null");
        Preconditions.checkArgument((sherd == null || sherd == Material.BRICK || Tag.ITEMS_DECORATED_POT_SHERDS.isTagged((Keyed)sherd) ? 1 : 0) != 0, (String)"sherd is not a valid sherd material: %s", (Object)sherd);
        Item sherdItem = sherd != null ? CraftMagicNumbers.getItem(sherd) : Items.pX;
        DecoratedPotBlockEntity.Decoration decorations = ((DecoratedPotBlockEntity)this.getSnapshot()).f();
        switch (face) {
            case BACK: {
                ((DecoratedPotBlockEntity)this.getSnapshot()).b = new DecoratedPotBlockEntity.Decoration(sherdItem, decorations.c(), decorations.d(), decorations.e());
                break;
            }
            case LEFT: {
                ((DecoratedPotBlockEntity)this.getSnapshot()).b = new DecoratedPotBlockEntity.Decoration(decorations.b(), sherdItem, decorations.d(), decorations.e());
                break;
            }
            case RIGHT: {
                ((DecoratedPotBlockEntity)this.getSnapshot()).b = new DecoratedPotBlockEntity.Decoration(decorations.b(), decorations.c(), sherdItem, decorations.e());
                break;
            }
            case FRONT: {
                ((DecoratedPotBlockEntity)this.getSnapshot()).b = new DecoratedPotBlockEntity.Decoration(decorations.b(), decorations.c(), decorations.d(), sherdItem);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value: " + face);
            }
        }
    }

    public Material getSherd(DecoratedPot.Side face) {
        Preconditions.checkArgument((face != null ? 1 : 0) != 0, (Object)"face must not be null");
        DecoratedPotBlockEntity.Decoration decorations = ((DecoratedPotBlockEntity)this.getSnapshot()).f();
        Item sherdItem = switch (face) {
            case DecoratedPot.Side.BACK -> decorations.b();
            case DecoratedPot.Side.LEFT -> decorations.c();
            case DecoratedPot.Side.RIGHT -> decorations.d();
            case DecoratedPot.Side.FRONT -> decorations.e();
            default -> throw new IllegalArgumentException("Unexpected value: " + face);
        };
        return CraftMagicNumbers.getMaterial(sherdItem);
    }

    public Map<DecoratedPot.Side, Material> getSherds() {
        DecoratedPotBlockEntity.Decoration decorations = ((DecoratedPotBlockEntity)this.getSnapshot()).f();
        EnumMap<DecoratedPot.Side, Material> sherds = new EnumMap<DecoratedPot.Side, Material>(DecoratedPot.Side.class);
        sherds.put(DecoratedPot.Side.BACK, CraftMagicNumbers.getMaterial(decorations.b()));
        sherds.put(DecoratedPot.Side.LEFT, CraftMagicNumbers.getMaterial(decorations.c()));
        sherds.put(DecoratedPot.Side.RIGHT, CraftMagicNumbers.getMaterial(decorations.d()));
        sherds.put(DecoratedPot.Side.FRONT, CraftMagicNumbers.getMaterial(decorations.e()));
        return sherds;
    }

    public List<Material> getShards() {
        return ((DecoratedPotBlockEntity)this.getSnapshot()).f().a().map(CraftMagicNumbers::getMaterial).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public CraftDecoratedPot copy() {
        return new CraftDecoratedPot(this);
    }
}

