/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R2.block;

import com.google.common.base.Preconditions;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.event.player.PlayerOpenSignEvent;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.level.block.entity.TileEntitySign;
import org.bukkit.DyeColor;
import org.bukkit.World;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.bukkit.craftbukkit.v1_20_R2.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_20_R2.block.sign.CraftSignSide;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftChatMessage;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerSignOpenEvent;
import org.jetbrains.annotations.NotNull;

public class CraftSign<T extends TileEntitySign>
extends CraftBlockEntityState<T>
implements Sign {
    private final CraftSignSide front = new CraftSignSide(((TileEntitySign)this.getSnapshot()).g());
    private final CraftSignSide back = new CraftSignSide(((TileEntitySign)this.getSnapshot()).i());

    public CraftSign(World world, T tileEntity) {
        super(world, tileEntity);
    }

    protected CraftSign(CraftSign<T> state) {
        super(state);
    }

    public @NotNull List<Component> lines() {
        return this.front.lines();
    }

    public @NotNull Component line(int index) {
        return this.front.line(index);
    }

    public void line(int index, @NotNull Component line) {
        this.front.line(index, line);
    }

    public String[] getLines() {
        return this.front.getLines();
    }

    public String getLine(int index) throws IndexOutOfBoundsException {
        return this.front.getLine(index);
    }

    public void setLine(int index, String line) throws IndexOutOfBoundsException {
        this.front.setLine(index, line);
    }

    public boolean isEditable() {
        return !this.isWaxed();
    }

    public void setEditable(boolean editable) {
        this.setWaxed(!editable);
    }

    public boolean isWaxed() {
        return ((TileEntitySign)this.getSnapshot()).w();
    }

    public void setWaxed(boolean waxed) {
        ((TileEntitySign)this.getSnapshot()).b(waxed);
    }

    public boolean isGlowingText() {
        return this.front.isGlowingText();
    }

    public void setGlowingText(boolean glowing) {
        this.front.setGlowingText(glowing);
    }

    @NotNull
    public SignSide getSide(Side side) {
        Preconditions.checkArgument((side != null ? 1 : 0) != 0, (Object)"side == null");
        switch (side) {
            case FRONT: {
                return this.front;
            }
            case BACK: {
                return this.back;
            }
        }
        throw new IllegalArgumentException();
    }

    public DyeColor getColor() {
        return this.front.getColor();
    }

    public void setColor(DyeColor color) {
        this.front.setColor(color);
    }

    @Override
    public void applyTo(T sign) {
        ((TileEntitySign)this.getSnapshot()).a(this.front.applyLegacyStringToSignSide(), true);
        ((TileEntitySign)this.getSnapshot()).a(this.back.applyLegacyStringToSignSide(), false);
        super.applyTo(sign);
    }

    @Override
    public CraftSign<T> copy() {
        return new CraftSign<T>(this);
    }

    public static void openSign(Sign sign, Player player, Side side) {
        Preconditions.checkArgument((sign != null ? 1 : 0) != 0, (Object)"sign == null");
        Preconditions.checkArgument((side != null ? 1 : 0) != 0, (Object)"side == null");
        Preconditions.checkArgument((boolean)sign.isPlaced(), (Object)"Sign must be placed");
        Preconditions.checkArgument((sign.getWorld() == player.getWorld() ? 1 : 0) != 0, (Object)"Sign must be in same world as Player");
        PlayerOpenSignEvent event = new PlayerOpenSignEvent(player, sign, side, PlayerOpenSignEvent.Cause.PLUGIN);
        if (!event.callEvent()) {
            return;
        }
        if (PlayerSignOpenEvent.getHandlerList().getRegisteredListeners().length > 0 && !CraftEventFactory.callPlayerSignOpenEvent(player, sign, side, PlayerSignOpenEvent.Cause.PLUGIN)) {
            return;
        }
        TileEntitySign handle = (TileEntitySign)((CraftSign)sign).getTileEntity();
        handle.a(player.getUniqueId());
        ((CraftPlayer)player).getHandle().a(handle, Side.FRONT == side);
    }

    public static IChatBaseComponent[] sanitizeLines(List<? extends Component> lines) {
        IChatBaseComponent[] components = new IChatBaseComponent[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            components[i2] = i2 < lines.size() && lines.get(i2) != null ? PaperAdventure.asVanilla(lines.get(i2)) : IChatBaseComponent.b("");
        }
        return components;
    }

    public Side getInteractableSideFor(double x2, double z2) {
        this.requirePlaced();
        return ((TileEntitySign)this.getSnapshot()).isFacingFrontText(x2, z2) ? Side.FRONT : Side.BACK;
    }

    public static IChatBaseComponent[] sanitizeLines(String[] lines) {
        IChatBaseComponent[] components = new IChatBaseComponent[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            components[i2] = i2 < lines.length && lines[i2] != null ? CraftChatMessage.fromString(lines[i2])[0] : IChatBaseComponent.h();
        }
        return components;
    }

    public static String[] revertComponents(IChatBaseComponent[] components) {
        String[] lines = new String[components.length];
        for (int i2 = 0; i2 < lines.length; ++i2) {
            lines[i2] = CraftSign.revertComponent(components[i2]);
        }
        return lines;
    }

    private static String revertComponent(IChatBaseComponent component) {
        return CraftChatMessage.fromComponent(component);
    }
}

