/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R2.block;

import com.google.common.base.Preconditions;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.block.BlockStructure;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyStructureMode;
import org.bukkit.World;
import org.bukkit.block.Structure;
import org.bukkit.block.structure.Mirror;
import org.bukkit.block.structure.StructureRotation;
import org.bukkit.block.structure.UsageMode;
import org.bukkit.craftbukkit.v1_20_R2.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftBlockVector;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.BlockVector;

public class CraftStructureBlock
extends CraftBlockEntityState<TileEntityStructure>
implements Structure {
    private static final int MAX_SIZE = 48;

    public CraftStructureBlock(World world, TileEntityStructure tileEntity) {
        super(world, tileEntity);
    }

    protected CraftStructureBlock(CraftStructureBlock state) {
        super(state);
    }

    public String getStructureName() {
        return ((TileEntityStructure)this.getSnapshot()).d();
    }

    public void setStructureName(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Structure name cannot be null");
        ((TileEntityStructure)this.getSnapshot()).a(name);
    }

    public String getAuthor() {
        return ((TileEntityStructure)this.getSnapshot()).f;
    }

    public void setAuthor(String author) {
        Preconditions.checkArgument((author != null ? 1 : 0) != 0, (Object)"Author name cannot be null");
        Preconditions.checkArgument((!author.isEmpty() ? 1 : 0) != 0, (Object)"Author name cannot be empty");
        ((TileEntityStructure)this.getSnapshot()).f = author;
    }

    public void setAuthor(LivingEntity entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Structure Block author entity cannot be null");
        ((TileEntityStructure)this.getSnapshot()).a(((CraftLivingEntity)entity).getHandle());
    }

    public BlockVector getRelativePosition() {
        return CraftBlockVector.toBukkit(((TileEntityStructure)this.getSnapshot()).h);
    }

    public void setRelativePosition(BlockVector vector) {
        Preconditions.checkArgument((boolean)CraftStructureBlock.isBetween(vector.getBlockX(), -48, 48), (String)"Structure Size (X) must be between -%s and %s but got %s", (Object)48, (Object)48, (Object)vector.getBlockX());
        Preconditions.checkArgument((boolean)CraftStructureBlock.isBetween(vector.getBlockY(), -48, 48), (String)"Structure Size (Y) must be between -%s and %s but got %s", (Object)48, (Object)48, (Object)vector.getBlockY());
        Preconditions.checkArgument((boolean)CraftStructureBlock.isBetween(vector.getBlockZ(), -48, 48), (String)"Structure Size (Z) must be between -%s and %s but got %s", (Object)48, (Object)48, (Object)vector.getBlockZ());
        ((TileEntityStructure)this.getSnapshot()).h = CraftBlockVector.toBlockPosition(vector);
    }

    public BlockVector getStructureSize() {
        return CraftBlockVector.toBukkit(((TileEntityStructure)this.getSnapshot()).i);
    }

    public void setStructureSize(BlockVector vector) {
        Preconditions.checkArgument((boolean)CraftStructureBlock.isBetween(vector.getBlockX(), 0, 48), (String)"Structure Size (X) must be between %s and %s but got %s", (Object)0, (Object)48, (Object)vector.getBlockX());
        Preconditions.checkArgument((boolean)CraftStructureBlock.isBetween(vector.getBlockY(), 0, 48), (String)"Structure Size (Y) must be between %s and %s but got %s", (Object)0, (Object)48, (Object)vector.getBlockY());
        Preconditions.checkArgument((boolean)CraftStructureBlock.isBetween(vector.getBlockZ(), 0, 48), (String)"Structure Size (Z) must be between %s and %s but got %s", (Object)0, (Object)48, (Object)vector.getBlockZ());
        ((TileEntityStructure)this.getSnapshot()).i = CraftBlockVector.toBlockPosition(vector);
    }

    public void setMirror(Mirror mirror) {
        Preconditions.checkArgument((mirror != null ? 1 : 0) != 0, (Object)"Mirror cannot be null");
        ((TileEntityStructure)this.getSnapshot()).j = EnumBlockMirror.valueOf(mirror.name());
    }

    public Mirror getMirror() {
        return Mirror.valueOf((String)((TileEntityStructure)this.getSnapshot()).j.name());
    }

    public void setRotation(StructureRotation rotation) {
        Preconditions.checkArgument((rotation != null ? 1 : 0) != 0, (Object)"StructureRotation cannot be null");
        ((TileEntityStructure)this.getSnapshot()).k = EnumBlockRotation.valueOf(rotation.name());
    }

    public StructureRotation getRotation() {
        return StructureRotation.valueOf((String)((TileEntityStructure)this.getSnapshot()).k.name());
    }

    public void setUsageMode(UsageMode mode) {
        Preconditions.checkArgument((mode != null ? 1 : 0) != 0, (Object)"UsageMode cannot be null");
        ((TileEntityStructure)this.getSnapshot()).l = BlockPropertyStructureMode.valueOf(mode.name());
    }

    public UsageMode getUsageMode() {
        return UsageMode.valueOf((String)((TileEntityStructure)this.getSnapshot()).y().name());
    }

    public void setIgnoreEntities(boolean flag) {
        ((TileEntityStructure)this.getSnapshot()).m = flag;
    }

    public boolean isIgnoreEntities() {
        return ((TileEntityStructure)this.getSnapshot()).m;
    }

    public void setShowAir(boolean showAir) {
        ((TileEntityStructure)this.getSnapshot()).r = showAir;
    }

    public boolean isShowAir() {
        return ((TileEntityStructure)this.getSnapshot()).r;
    }

    public void setBoundingBoxVisible(boolean showBoundingBox) {
        ((TileEntityStructure)this.getSnapshot()).s = showBoundingBox;
    }

    public boolean isBoundingBoxVisible() {
        return ((TileEntityStructure)this.getSnapshot()).s;
    }

    public void setIntegrity(float integrity) {
        Preconditions.checkArgument((boolean)CraftStructureBlock.isBetween(integrity, 0.0f, 1.0f), (String)"Integrity must be between 0.0f and 1.0f but got %s", (Object)Float.valueOf(integrity));
        ((TileEntityStructure)this.getSnapshot()).t = integrity;
    }

    public float getIntegrity() {
        return ((TileEntityStructure)this.getSnapshot()).t;
    }

    public void setSeed(long seed) {
        ((TileEntityStructure)this.getSnapshot()).u = seed;
    }

    public long getSeed() {
        return ((TileEntityStructure)this.getSnapshot()).u;
    }

    public void setMetadata(String metadata) {
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (Object)"Structure metadata cannot be null");
        if (this.getUsageMode() == UsageMode.DATA) {
            ((TileEntityStructure)this.getSnapshot()).g = metadata;
        }
    }

    public String getMetadata() {
        return ((TileEntityStructure)this.getSnapshot()).g;
    }

    @Override
    protected void applyTo(TileEntityStructure tileEntity) {
        IBlockData data;
        super.applyTo(tileEntity);
        GeneratorAccess access = this.getWorldHandle();
        if (access instanceof net.minecraft.world.level.World) {
            tileEntity.a(tileEntity.y());
        } else if (access != null && (data = access.a_(this.getPosition())).a(Blocks.pa)) {
            access.a(this.getPosition(), (IBlockData)data.a(BlockStructure.a, tileEntity.y()), 2);
        }
    }

    @Override
    public CraftStructureBlock copy() {
        return new CraftStructureBlock(this);
    }

    private static boolean isBetween(int num, int min, int max) {
        return num >= min && num <= max;
    }

    private static boolean isBetween(float num, float min, float max) {
        return num >= min && num <= max;
    }
}

