/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R2.enchantments;

import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.enchantments.EnchantmentRarity;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.enchantment.Enchantment;
import org.bukkit.craftbukkit.v1_20_R2.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftNamespacedKey;
import org.bukkit.enchantments.EnchantmentTarget;
import org.bukkit.enchantments.EnchantmentWrapper;
import org.bukkit.entity.EntityCategory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class CraftEnchantment
extends org.bukkit.enchantments.Enchantment {
    private final Enchantment target;

    public CraftEnchantment(Enchantment target) {
        super(CraftNamespacedKey.fromMinecraft(BuiltInRegistries.g.b(target)));
        this.target = target;
    }

    public int getMaxLevel() {
        return this.target.a();
    }

    public int getStartLevel() {
        return this.target.e();
    }

    public EnchantmentTarget getItemTarget() {
        switch (this.target.e) {
            case a: {
                return EnchantmentTarget.ARMOR;
            }
            case b: {
                return EnchantmentTarget.ARMOR_FEET;
            }
            case e: {
                return EnchantmentTarget.ARMOR_HEAD;
            }
            case c: {
                return EnchantmentTarget.ARMOR_LEGS;
            }
            case d: {
                return EnchantmentTarget.ARMOR_TORSO;
            }
            case g: {
                return EnchantmentTarget.TOOL;
            }
            case f: {
                return EnchantmentTarget.WEAPON;
            }
            case k: {
                return EnchantmentTarget.BOW;
            }
            case h: {
                return EnchantmentTarget.FISHING_ROD;
            }
            case j: {
                return EnchantmentTarget.BREAKABLE;
            }
            case l: {
                return EnchantmentTarget.WEARABLE;
            }
            case i: {
                return EnchantmentTarget.TRIDENT;
            }
            case m: {
                return EnchantmentTarget.CROSSBOW;
            }
            case n: {
                return EnchantmentTarget.VANISHABLE;
            }
        }
        return null;
    }

    public boolean isTreasure() {
        return this.target.b();
    }

    public boolean isCursed() {
        return this.target.c();
    }

    public boolean canEnchantItem(ItemStack item) {
        return this.target.a(CraftItemStack.asNMSCopy(item));
    }

    public String getName() {
        switch (BuiltInRegistries.g.a(this.target)) {
            case 0: {
                return "PROTECTION_ENVIRONMENTAL";
            }
            case 1: {
                return "PROTECTION_FIRE";
            }
            case 2: {
                return "PROTECTION_FALL";
            }
            case 3: {
                return "PROTECTION_EXPLOSIONS";
            }
            case 4: {
                return "PROTECTION_PROJECTILE";
            }
            case 5: {
                return "OXYGEN";
            }
            case 6: {
                return "WATER_WORKER";
            }
            case 7: {
                return "THORNS";
            }
            case 8: {
                return "DEPTH_STRIDER";
            }
            case 9: {
                return "FROST_WALKER";
            }
            case 10: {
                return "BINDING_CURSE";
            }
            case 11: {
                return "SOUL_SPEED";
            }
            case 12: {
                return "SWIFT_SNEAK";
            }
            case 13: {
                return "DAMAGE_ALL";
            }
            case 14: {
                return "DAMAGE_UNDEAD";
            }
            case 15: {
                return "DAMAGE_ARTHROPODS";
            }
            case 16: {
                return "KNOCKBACK";
            }
            case 17: {
                return "FIRE_ASPECT";
            }
            case 18: {
                return "LOOT_BONUS_MOBS";
            }
            case 19: {
                return "SWEEPING_EDGE";
            }
            case 20: {
                return "DIG_SPEED";
            }
            case 21: {
                return "SILK_TOUCH";
            }
            case 22: {
                return "DURABILITY";
            }
            case 23: {
                return "LOOT_BONUS_BLOCKS";
            }
            case 24: {
                return "ARROW_DAMAGE";
            }
            case 25: {
                return "ARROW_KNOCKBACK";
            }
            case 26: {
                return "ARROW_FIRE";
            }
            case 27: {
                return "ARROW_INFINITE";
            }
            case 28: {
                return "LUCK";
            }
            case 29: {
                return "LURE";
            }
            case 30: {
                return "LOYALTY";
            }
            case 31: {
                return "IMPALING";
            }
            case 32: {
                return "RIPTIDE";
            }
            case 33: {
                return "CHANNELING";
            }
            case 34: {
                return "MULTISHOT";
            }
            case 35: {
                return "QUICK_CHARGE";
            }
            case 36: {
                return "PIERCING";
            }
            case 37: {
                return "MENDING";
            }
            case 38: {
                return "VANISHING_CURSE";
            }
        }
        return "UNKNOWN_ENCHANT_" + BuiltInRegistries.g.a(this.target);
    }

    public static Enchantment getRaw(org.bukkit.enchantments.Enchantment enchantment) {
        if (enchantment instanceof EnchantmentWrapper) {
            enchantment = ((EnchantmentWrapper)enchantment).getEnchantment();
        }
        if (enchantment instanceof CraftEnchantment) {
            return ((CraftEnchantment)enchantment).target;
        }
        return null;
    }

    public boolean conflictsWith(org.bukkit.enchantments.Enchantment other) {
        if (other instanceof EnchantmentWrapper) {
            other = ((EnchantmentWrapper)other).getEnchantment();
        }
        if (!(other instanceof CraftEnchantment)) {
            return false;
        }
        CraftEnchantment ench = (CraftEnchantment)other;
        return !this.target.b(ench.target);
    }

    public Component displayName(int level) {
        return PaperAdventure.asAdventure(this.getHandle().d(level));
    }

    public String translationKey() {
        return this.target.g();
    }

    public boolean isTradeable() {
        return this.target.h();
    }

    public boolean isDiscoverable() {
        return this.target.i();
    }

    public int getMinModifiedCost(int level) {
        return this.target.a(level);
    }

    public int getMaxModifiedCost(int level) {
        return this.target.b(level);
    }

    public EnchantmentRarity getRarity() {
        return CraftEnchantment.fromNMSRarity(this.target.d());
    }

    public float getDamageIncrease(int level, EntityCategory entityCategory) {
        return this.target.a(level, CraftLivingEntity.fromBukkitEntityCategory(entityCategory));
    }

    public Set<EquipmentSlot> getActiveSlots() {
        return Stream.of(this.target.a).map(CraftEquipmentSlot::getSlot).collect(Collectors.toSet());
    }

    public static EnchantmentRarity fromNMSRarity(Enchantment.Rarity nmsRarity) {
        if (nmsRarity == Enchantment.Rarity.a) {
            return EnchantmentRarity.COMMON;
        }
        if (nmsRarity == Enchantment.Rarity.b) {
            return EnchantmentRarity.UNCOMMON;
        }
        if (nmsRarity == Enchantment.Rarity.c) {
            return EnchantmentRarity.RARE;
        }
        if (nmsRarity == Enchantment.Rarity.d) {
            return EnchantmentRarity.VERY_RARE;
        }
        throw new IllegalArgumentException(String.format("Unable to convert %s to a enum value of %s.", new Object[]{nmsRarity, EnchantmentRarity.class}));
    }

    public Enchantment getHandle() {
        return this.target;
    }
}

