/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R2.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.UUID;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityLiving;
import org.bukkit.Color;
import org.bukkit.Particle;
import org.bukkit.craftbukkit.v1_20_R2.CraftParticle;
import org.bukkit.craftbukkit.v1_20_R2.CraftServer;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_20_R2.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_20_R2.potion.CraftPotionType;
import org.bukkit.craftbukkit.v1_20_R2.potion.CraftPotionUtil;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.LivingEntity;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.NotNull;

public class CraftAreaEffectCloud
extends CraftEntity
implements AreaEffectCloud {
    public CraftAreaEffectCloud(CraftServer server, EntityAreaEffectCloud entity) {
        super(server, entity);
    }

    @Override
    public EntityAreaEffectCloud getHandle() {
        return (EntityAreaEffectCloud)super.getHandle();
    }

    @Override
    public String toString() {
        return "CraftAreaEffectCloud";
    }

    public int getDuration() {
        return this.getHandle().m();
    }

    public void setDuration(int duration) {
        this.getHandle().b(duration);
    }

    public int getWaitTime() {
        return this.getHandle().r;
    }

    public void setWaitTime(int waitTime) {
        this.getHandle().d(waitTime);
    }

    public int getReapplicationDelay() {
        return this.getHandle().s;
    }

    public void setReapplicationDelay(int delay) {
        this.getHandle().s = delay;
    }

    public int getDurationOnUse() {
        return this.getHandle().u;
    }

    public void setDurationOnUse(int duration) {
        this.getHandle().u = duration;
    }

    public float getRadius() {
        return this.getHandle().h();
    }

    public void setRadius(float radius) {
        this.getHandle().a(radius);
    }

    public float getRadiusOnUse() {
        return this.getHandle().v;
    }

    public void setRadiusOnUse(float radius) {
        this.getHandle().b(radius);
    }

    public float getRadiusPerTick() {
        return this.getHandle().aE;
    }

    public void setRadiusPerTick(float radius) {
        this.getHandle().c(radius);
    }

    public Particle getParticle() {
        return CraftParticle.minecraftToBukkit(this.getHandle().j().b());
    }

    public void setParticle(Particle particle) {
        this.setParticle(particle, null);
    }

    public <T> void setParticle(Particle particle, T data) {
        particle = CraftParticle.convertLegacy(particle);
        if ((data = CraftParticle.convertLegacy(data)) != null) {
            Preconditions.checkArgument((boolean)particle.getDataType().isInstance(data), (String)"data (%s) should be %s", data.getClass(), (Object)particle.getDataType());
        }
        this.getHandle().a(CraftParticle.createParticleParam(particle, data));
    }

    public Color getColor() {
        return Color.fromRGB((int)this.getHandle().i());
    }

    public void setColor(Color color) {
        this.getHandle().a(color.asRGB());
    }

    public boolean addCustomEffect(PotionEffect effect, boolean override) {
        MobEffectList minecraft = CraftPotionEffectType.bukkitToMinecraft(effect.getType());
        MobEffect existing = null;
        for (MobEffect mobEffect : this.getHandle().o) {
            if (mobEffect.c() != minecraft) continue;
            existing = mobEffect;
        }
        if (existing != null) {
            if (!override) {
                return false;
            }
            this.getHandle().o.remove(existing);
        }
        this.getHandle().a(CraftPotionUtil.fromBukkit(effect));
        this.getHandle().w();
        return true;
    }

    public void clearCustomEffects() {
        this.getHandle().o.clear();
        this.getHandle().w();
    }

    public List<PotionEffect> getCustomEffects() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (MobEffect effect : this.getHandle().o) {
            builder.add((Object)CraftPotionUtil.toBukkit(effect));
        }
        return builder.build();
    }

    public boolean hasCustomEffect(PotionEffectType type) {
        for (MobEffect effect : this.getHandle().o) {
            if (!CraftPotionUtil.equals(effect.c(), type)) continue;
            return true;
        }
        return false;
    }

    public boolean hasCustomEffects() {
        return !this.getHandle().o.isEmpty();
    }

    public boolean removeCustomEffect(PotionEffectType effect) {
        MobEffectList minecraft = CraftPotionEffectType.bukkitToMinecraft(effect);
        MobEffect existing = null;
        for (MobEffect mobEffect : this.getHandle().o) {
            if (mobEffect.c() != minecraft) continue;
            existing = mobEffect;
        }
        if (existing == null) {
            return false;
        }
        this.getHandle().o.remove(existing);
        this.getHandle().w();
        return true;
    }

    public void setBasePotionData(PotionData data) {
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"PotionData cannot be null");
        this.getHandle().a(CraftPotionType.bukkitToMinecraft(CraftPotionUtil.fromBukkit(data)));
    }

    public PotionData getBasePotionData() {
        return CraftPotionUtil.toBukkit(CraftPotionType.minecraftToBukkit(this.getHandle().t()));
    }

    public void setBasePotionType(@NotNull PotionType potionType) {
        Preconditions.checkArgument((potionType != null ? 1 : 0) != 0, (Object)"PotionType cannot be null use PotionType.UNCRAFTABLE to represent no effect instead.");
        this.getHandle().a(CraftPotionType.bukkitToMinecraft(potionType));
    }

    @NotNull
    public PotionType getBasePotionType() {
        return CraftPotionType.minecraftToBukkit(this.getHandle().t());
    }

    public ProjectileSource getSource() {
        EntityLiving source = this.getHandle().s();
        return source == null ? null : (LivingEntity)source.getBukkitEntity();
    }

    public void setSource(ProjectileSource shooter) {
        if (shooter instanceof CraftLivingEntity) {
            CraftLivingEntity craftLivingEntity = (CraftLivingEntity)shooter;
            this.getHandle().a(craftLivingEntity.getHandle());
        } else {
            this.getHandle().a((EntityLiving)null);
        }
    }

    public UUID getOwnerUniqueId() {
        return this.getHandle().aG;
    }

    public void setOwnerUniqueId(UUID ownerUuid) {
        this.getHandle().a((EntityLiving)null);
        this.getHandle().aG = ownerUuid;
    }
}

