/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R2.entity;

import com.google.common.base.Preconditions;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.item.EnumColor;
import org.bukkit.DyeColor;
import org.bukkit.craftbukkit.v1_20_R2.CraftRegistry;
import org.bukkit.craftbukkit.v1_20_R2.CraftServer;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftTameableAnimal;
import org.bukkit.entity.Cat;

public class CraftCat
extends CraftTameableAnimal
implements Cat {
    public CraftCat(CraftServer server, EntityCat entity) {
        super(server, entity);
    }

    @Override
    public EntityCat getHandle() {
        return (EntityCat)super.getHandle();
    }

    @Override
    public String toString() {
        return "CraftCat";
    }

    public Cat.Type getCatType() {
        return CraftType.minecraftToBukkit(this.getHandle().gk());
    }

    public void setCatType(Cat.Type type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Cannot have null Type");
        this.getHandle().a(CraftType.bukkitToMinecraft(type));
    }

    public DyeColor getCollarColor() {
        return DyeColor.getByWoolData((byte)((byte)this.getHandle().gn().a()));
    }

    public void setCollarColor(DyeColor color) {
        this.getHandle().a(EnumColor.a(color.getWoolData()));
    }

    public void setLyingDown(boolean lyingDown) {
        this.getHandle().A(lyingDown);
    }

    public boolean isLyingDown() {
        return this.getHandle().gl();
    }

    public void setHeadUp(boolean headUp) {
        this.getHandle().B(headUp);
    }

    public boolean isHeadUp() {
        return this.getHandle().gm();
    }

    public static class CraftType {
        public static Cat.Type minecraftToBukkit(CatVariant minecraft) {
            Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
            IRegistry registry = CraftRegistry.getMinecraftRegistry(Registries.j);
            return Cat.Type.values()[registry.a(minecraft)];
        }

        public static CatVariant bukkitToMinecraft(Cat.Type bukkit) {
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            return (CatVariant)CraftRegistry.getMinecraftRegistry(Registries.j).a(bukkit.ordinal());
        }
    }
}

