/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R2.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.projectile.EntityFireball;
import org.bukkit.craftbukkit.v1_20_R2.CraftServer;
import org.bukkit.craftbukkit.v1_20_R2.entity.AbstractProjectile;
import org.bukkit.entity.Fireball;
import org.bukkit.util.Vector;

public class CraftFireball
extends AbstractProjectile
implements Fireball {
    public CraftFireball(CraftServer server, EntityFireball entity) {
        super(server, entity);
    }

    public float getYield() {
        return this.getHandle().bukkitYield;
    }

    public boolean isIncendiary() {
        return this.getHandle().isIncendiary;
    }

    public void setIsIncendiary(boolean isIncendiary) {
        this.getHandle().isIncendiary = isIncendiary;
    }

    public void setYield(float yield) {
        this.getHandle().bukkitYield = yield;
    }

    public Vector getDirection() {
        return new Vector(this.getHandle().b, this.getHandle().c, this.getHandle().d);
    }

    public void setDirection(Vector direction) {
        Preconditions.checkArgument((direction != null ? 1 : 0) != 0, (Object)"Vector direction cannot be null");
        this.getHandle().setDirection(direction.getX(), direction.getY(), direction.getZ());
        this.update();
    }

    @Override
    public void setVelocity(Vector velocity) {
        Preconditions.checkArgument((velocity != null ? 1 : 0) != 0, (Object)"Vector velocity cannot be null");
        velocity.checkFinite();
        this.getHandle().b = velocity.getX();
        this.getHandle().c = velocity.getY();
        this.getHandle().d = velocity.getZ();
        this.update();
    }

    @Override
    public EntityFireball getHandle() {
        return (EntityFireball)this.entity;
    }

    @Override
    public String toString() {
        return "CraftFireball";
    }
}

