/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R2.entity;

import com.google.common.base.Preconditions;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.animal.frog.Frog;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_20_R2.CraftRegistry;
import org.bukkit.craftbukkit.v1_20_R2.CraftServer;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftAnimals;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftNamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Frog;

public class CraftFrog
extends CraftAnimals
implements org.bukkit.entity.Frog {
    public CraftFrog(CraftServer server, Frog entity) {
        super(server, entity);
    }

    @Override
    public Frog getHandle() {
        return (Frog)this.entity;
    }

    @Override
    public String toString() {
        return "CraftFrog";
    }

    public Entity getTongueTarget() {
        return this.getHandle().t().map(net.minecraft.world.entity.Entity::getBukkitEntity).orElse(null);
    }

    public void setTongueTarget(Entity target) {
        if (target == null) {
            this.getHandle().s();
        } else {
            this.getHandle().a(((CraftEntity)target).getHandle());
        }
    }

    public Frog.Variant getVariant() {
        return CraftVariant.minecraftToBukkit(this.getHandle().y());
    }

    public void setVariant(Frog.Variant variant) {
        Preconditions.checkArgument((variant != null ? 1 : 0) != 0, (Object)"variant");
        this.getHandle().a(CraftVariant.bukkitToMinecraft(variant));
    }

    public static class CraftVariant {
        public static Frog.Variant minecraftToBukkit(FrogVariant minecraft) {
            Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
            IRegistry registry = CraftRegistry.getMinecraftRegistry(Registries.y);
            Frog.Variant bukkit = (Frog.Variant)Registry.FROG_VARIANT.get(CraftNamespacedKey.fromMinecraft(registry.c(minecraft).orElseThrow().a()));
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            return bukkit;
        }

        public static FrogVariant bukkitToMinecraft(Frog.Variant bukkit) {
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            return (FrogVariant)CraftRegistry.getMinecraftRegistry(Registries.y).b(CraftNamespacedKey.toMinecraft(bukkit.getKey())).orElseThrow();
        }
    }
}

