/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R2.entity;

import com.destroystokyo.paper.entity.PaperPathfinder;
import com.destroystokyo.paper.entity.Pathfinder;
import com.google.common.base.Preconditions;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.entity.EntityInsentient;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.craftbukkit.v1_20_R2.CraftServer;
import org.bukkit.craftbukkit.v1_20_R2.CraftSound;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftNamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.loot.LootTable;
import org.jetbrains.annotations.NotNull;

public abstract class CraftMob
extends CraftLivingEntity
implements Mob {
    private final PaperPathfinder paperPathfinder;

    public CraftMob(CraftServer server, EntityInsentient entity) {
        super(server, entity);
        this.paperPathfinder = new PaperPathfinder(entity);
    }

    public Pathfinder getPathfinder() {
        return this.paperPathfinder;
    }

    public void setTarget(LivingEntity target) {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot set target during world generation");
        EntityInsentient entity = this.getHandle();
        if (target == null) {
            entity.setTarget(null, null, false);
        } else if (target instanceof CraftLivingEntity) {
            entity.setTarget(((CraftLivingEntity)target).getHandle(), null, false);
        }
    }

    public CraftLivingEntity getTarget() {
        if (this.getHandle().q() == null) {
            return null;
        }
        return (CraftLivingEntity)this.getHandle().q().getBukkitEntity();
    }

    public void setAware(boolean aware) {
        this.getHandle().aware = aware;
    }

    public boolean isAware() {
        return this.getHandle().aware;
    }

    public Sound getAmbientSound() {
        SoundEffect sound = this.getHandle().getAmbientSound0();
        return sound != null ? CraftSound.minecraftToBukkit(sound) : null;
    }

    @Override
    public EntityInsentient getHandle() {
        return (EntityInsentient)this.entity;
    }

    @Override
    public void setHandle(net.minecraft.world.entity.Entity entity) {
        super.setHandle(entity);
        this.paperPathfinder.setHandle(this.getHandle());
    }

    @Override
    public String toString() {
        return "CraftMob";
    }

    public void setLootTable(LootTable table) {
        this.getHandle().cc = table == null ? null : CraftNamespacedKey.toMinecraft(table.getKey());
    }

    public LootTable getLootTable() {
        NamespacedKey key = CraftNamespacedKey.fromMinecraft(this.getHandle().ez());
        return Bukkit.getLootTable((NamespacedKey)key);
    }

    public void setSeed(long seed) {
        this.getHandle().cd = seed;
    }

    public long getSeed() {
        return this.getHandle().cd;
    }

    public boolean isInDaylight() {
        return this.getHandle().fX();
    }

    public void lookAt(@NotNull Location location) {
        Preconditions.checkNotNull((Object)location, (Object)"location cannot be null");
        Preconditions.checkArgument((boolean)location.getWorld().equals(this.getWorld()), (Object)"location in a different world");
        this.getHandle().G().a(location.getX(), location.getY(), location.getZ());
    }

    public void lookAt(@NotNull Location location, float headRotationSpeed, float maxHeadPitch) {
        Preconditions.checkNotNull((Object)location, (Object)"location cannot be null");
        Preconditions.checkArgument((boolean)location.getWorld().equals(this.getWorld()), (Object)"location in a different world");
        this.getHandle().G().a(location.getX(), location.getY(), location.getZ(), headRotationSpeed, maxHeadPitch);
    }

    public void lookAt(@NotNull Entity entity) {
        Preconditions.checkNotNull((Object)entity, (Object)"entity cannot be null");
        Preconditions.checkArgument((boolean)entity.getWorld().equals(this.getWorld()), (Object)"entity in a different world");
        this.getHandle().G().a(((CraftEntity)entity).getHandle());
    }

    public void lookAt(@NotNull Entity entity, float headRotationSpeed, float maxHeadPitch) {
        Preconditions.checkNotNull((Object)entity, (Object)"entity cannot be null");
        Preconditions.checkArgument((boolean)entity.getWorld().equals(this.getWorld()), (Object)"entity in a different world");
        this.getHandle().G().a(((CraftEntity)entity).getHandle(), headRotationSpeed, maxHeadPitch);
    }

    public void lookAt(double x2, double y2, double z2) {
        this.getHandle().G().a(x2, y2, z2);
    }

    public void lookAt(double x2, double y2, double z2, float headRotationSpeed, float maxHeadPitch) {
        this.getHandle().G().a(x2, y2, z2, headRotationSpeed, maxHeadPitch);
    }

    public int getHeadRotationSpeed() {
        return this.getHandle().fG();
    }

    public int getMaxHeadPitch() {
        return this.getHandle().Y();
    }

    public boolean isLeftHanded() {
        return this.getHandle().fU();
    }

    public void setLeftHanded(boolean leftHanded) {
        this.getHandle().u(leftHanded);
    }

    public boolean isAggressive() {
        return this.getHandle().fV();
    }

    public void setAggressive(boolean aggressive) {
        this.getHandle().v(aggressive);
    }

    public int getPossibleExperienceReward() {
        return this.getHandle().ed();
    }
}

