/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R2.entity;

import com.google.common.base.Preconditions;
import io.papermc.paper.entity.PaperShearable;
import io.papermc.paper.potion.SuspiciousEffectEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.entity.animal.EntityMushroomCow;
import net.minecraft.world.level.block.SuspiciousEffectHolder;
import org.bukkit.craftbukkit.v1_20_R2.CraftServer;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftCow;
import org.bukkit.craftbukkit.v1_20_R2.potion.CraftPotionEffectType;
import org.bukkit.entity.MushroomCow;
import org.bukkit.potion.PotionEffectType;

public class CraftMushroomCow
extends CraftCow
implements MushroomCow,
PaperShearable {
    public CraftMushroomCow(CraftServer server, EntityMushroomCow entity) {
        super(server, entity);
    }

    @Override
    public EntityMushroomCow getHandle() {
        return (EntityMushroomCow)this.entity;
    }

    public MushroomCow.Variant getVariant() {
        return MushroomCow.Variant.values()[this.getHandle().t().ordinal()];
    }

    public void setVariant(MushroomCow.Variant variant) {
        Preconditions.checkArgument((variant != null ? 1 : 0) != 0, (Object)"variant");
        this.getHandle().a(EntityMushroomCow.Type.values()[variant.ordinal()]);
    }

    public List<SuspiciousEffectEntry> getStewEffects() {
        if (this.getHandle().bX == null) {
            return List.of();
        }
        ArrayList<SuspiciousEffectEntry> nmsPairs = new ArrayList<SuspiciousEffectEntry>(this.getHandle().bX.size());
        for (SuspiciousEffectHolder.a effect : this.getHandle().bX) {
            nmsPairs.add(SuspiciousEffectEntry.create((PotionEffectType)CraftPotionEffectType.minecraftToBukkit(effect.b()), (int)effect.c()));
        }
        return Collections.unmodifiableList(nmsPairs);
    }

    public void setStewEffects(List<SuspiciousEffectEntry> effects) {
        if (effects.isEmpty()) {
            this.getHandle().bX = null;
            return;
        }
        ArrayList<SuspiciousEffectHolder.a> nmsPairs = new ArrayList<SuspiciousEffectHolder.a>(effects.size());
        for (SuspiciousEffectEntry effect : effects) {
            nmsPairs.add(new SuspiciousEffectHolder.a(CraftPotionEffectType.bukkitToMinecraft(effect.effect()), effect.duration()));
        }
        this.getHandle().bX = nmsPairs;
    }

    @Override
    public String toString() {
        return "CraftMushroomCow";
    }
}

