/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R2.entity;

import com.google.common.base.Preconditions;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.raid.EntityRaider;
import org.bukkit.Raid;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_20_R2.CraftRaid;
import org.bukkit.craftbukkit.v1_20_R2.CraftServer;
import org.bukkit.craftbukkit.v1_20_R2.CraftSound;
import org.bukkit.craftbukkit.v1_20_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftMonster;
import org.bukkit.entity.Raider;

public abstract class CraftRaider
extends CraftMonster
implements Raider {
    public CraftRaider(CraftServer server, EntityRaider entity) {
        super(server, entity);
    }

    @Override
    public EntityRaider getHandle() {
        return (EntityRaider)super.getHandle();
    }

    @Override
    public String toString() {
        return "CraftRaider";
    }

    public void setRaid(Raid raid) {
        this.getHandle().a(raid != null ? ((CraftRaid)raid).getHandle() : null);
    }

    public Raid getRaid() {
        return this.getHandle().gr() == null ? null : new CraftRaid(this.getHandle().gr());
    }

    public void setWave(int wave) {
        Preconditions.checkArgument((wave >= 0 ? 1 : 0) != 0, (Object)"wave must be >= 0");
        this.getHandle().b(wave);
    }

    public int getWave() {
        return this.getHandle().gt();
    }

    public Block getPatrolTarget() {
        return this.getHandle().gf() == null ? null : CraftBlock.at(this.getHandle().dL(), this.getHandle().gf());
    }

    public void setPatrolTarget(Block block) {
        if (block == null) {
            this.getHandle().i((BlockPosition)null);
        } else {
            Preconditions.checkArgument((boolean)block.getWorld().equals(this.getWorld()), (Object)"Block must be in same world");
            this.getHandle().i(((CraftBlock)block).getPosition());
        }
    }

    public boolean isPatrolLeader() {
        return this.getHandle().gh();
    }

    public void setPatrolLeader(boolean leader) {
        this.getHandle().w(leader);
    }

    public boolean isCanJoinRaid() {
        return this.getHandle().gq();
    }

    public void setCanJoinRaid(boolean join) {
        this.getHandle().z(join);
    }

    public boolean isCelebrating() {
        return this.getHandle().gu();
    }

    public void setCelebrating(boolean celebrating) {
        this.getHandle().A(celebrating);
    }

    public int getTicksOutsideRaid() {
        return this.getHandle().gv();
    }

    public void setTicksOutsideRaid(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks must be >= 0");
        this.getHandle().c(ticks);
    }

    public Sound getCelebrationSound() {
        return CraftSound.minecraftToBukkit(this.getHandle().ac_());
    }
}

