/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R2.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.projectile.EntityTippedArrow;
import org.bukkit.Color;
import org.bukkit.craftbukkit.v1_20_R2.CraftServer;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftArrow;
import org.bukkit.craftbukkit.v1_20_R2.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_20_R2.potion.CraftPotionType;
import org.bukkit.craftbukkit.v1_20_R2.potion.CraftPotionUtil;
import org.bukkit.entity.Arrow;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;

public class CraftTippedArrow
extends CraftArrow
implements Arrow {
    public CraftTippedArrow(CraftServer server, EntityTippedArrow entity) {
        super(server, entity);
    }

    @Override
    public EntityTippedArrow getHandle() {
        return (EntityTippedArrow)this.entity;
    }

    @Override
    public String toString() {
        return "CraftTippedArrow";
    }

    public boolean addCustomEffect(PotionEffect effect, boolean override) {
        MobEffectList minecraft = CraftPotionEffectType.bukkitToMinecraft(effect.getType());
        MobEffect existing = null;
        for (MobEffect mobEffect : this.getHandle().k) {
            if (mobEffect.c() != minecraft) continue;
            existing = mobEffect;
        }
        if (existing != null) {
            if (!override) {
                return false;
            }
            this.getHandle().k.remove(existing);
        }
        this.getHandle().a(CraftPotionUtil.fromBukkit(effect));
        this.getHandle().I();
        return true;
    }

    public void clearCustomEffects() {
        this.getHandle().k.clear();
        this.getHandle().I();
    }

    public List<PotionEffect> getCustomEffects() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (MobEffect effect : this.getHandle().k) {
            builder.add((Object)CraftPotionUtil.toBukkit(effect));
        }
        return builder.build();
    }

    public boolean hasCustomEffect(PotionEffectType type) {
        for (MobEffect effect : this.getHandle().k) {
            if (!CraftPotionUtil.equals(effect.c(), type)) continue;
            return true;
        }
        return false;
    }

    public boolean hasCustomEffects() {
        return !this.getHandle().k.isEmpty();
    }

    public boolean removeCustomEffect(PotionEffectType effect) {
        MobEffectList minecraft = CraftPotionEffectType.bukkitToMinecraft(effect);
        MobEffect existing = null;
        for (MobEffect mobEffect : this.getHandle().k) {
            if (mobEffect.c() != minecraft) continue;
            existing = mobEffect;
        }
        if (existing == null) {
            return false;
        }
        this.getHandle().k.remove(existing);
        this.getHandle().I();
        return true;
    }

    public void setBasePotionData(PotionData data) {
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"PotionData cannot be null");
        this.getHandle().j = CraftPotionType.bukkitToMinecraft(CraftPotionUtil.fromBukkit(data));
    }

    public PotionData getBasePotionData() {
        return CraftPotionUtil.toBukkit(CraftPotionType.minecraftToBukkit(this.getHandle().j));
    }

    public void setBasePotionType(@NotNull PotionType potionType) {
        Preconditions.checkArgument((potionType != null ? 1 : 0) != 0, (Object)"PotionType cannot be null use PotionType.UNCRAFTABLE to represent no effect instead.");
        this.getHandle().j = CraftPotionType.bukkitToMinecraft(potionType);
    }

    @NotNull
    public PotionType getBasePotionType() {
        return CraftPotionType.minecraftToBukkit(this.getHandle().j);
    }

    public void setColor(Color color) {
        int colorRGB = color == null ? -1 : color.asRGB();
        this.getHandle().d(colorRGB);
    }

    public Color getColor() {
        if (this.getHandle().F() <= -1) {
            return null;
        }
        return Color.fromRGB((int)this.getHandle().F());
    }
}

