/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R2.entity;

import com.destroystokyo.paper.entity.villager.Reputation;
import com.destroystokyo.paper.entity.villager.ReputationType;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.ai.gossip.Reputation;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.monster.EntityZombieVillager;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Location;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_20_R2.CraftRegistry;
import org.bukkit.craftbukkit.v1_20_R2.CraftServer;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftAbstractVillager;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftLocation;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftNamespacedKey;
import org.bukkit.entity.Villager;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class CraftVillager
extends CraftAbstractVillager
implements Villager {
    public CraftVillager(CraftServer server, EntityVillager entity) {
        super(server, entity);
    }

    @Override
    public EntityVillager getHandle() {
        return (EntityVillager)this.entity;
    }

    @Override
    public String toString() {
        return "CraftVillager";
    }

    @Override
    public void remove() {
        this.getHandle().gG();
        super.remove();
    }

    public Villager.Profession getProfession() {
        return CraftProfession.minecraftToBukkit(this.getHandle().go().b());
    }

    public void setProfession(Villager.Profession profession) {
        Preconditions.checkArgument((profession != null ? 1 : 0) != 0, (Object)"Profession cannot be null");
        this.getHandle().a(this.getHandle().go().a(CraftProfession.bukkitToMinecraft(profession)));
    }

    public Villager.Type getVillagerType() {
        return CraftType.minecraftToBukkit(this.getHandle().go().a());
    }

    public void setVillagerType(Villager.Type type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Type cannot be null");
        this.getHandle().a(this.getHandle().go().a(CraftType.bukkitToMinecraft(type)));
    }

    public int getVillagerLevel() {
        return this.getHandle().go().c();
    }

    public void setVillagerLevel(int level) {
        Preconditions.checkArgument((1 <= level && level <= 5 ? 1 : 0) != 0, (String)"level (%s) must be between [1, 5]", (int)level);
        this.getHandle().a(this.getHandle().go().a(level));
    }

    public int getVillagerExperience() {
        return this.getHandle().t();
    }

    public void setVillagerExperience(int experience) {
        Preconditions.checkArgument((experience >= 0 ? 1 : 0) != 0, (String)"Experience (%s) must be positive", (int)experience);
        this.getHandle().u(experience);
    }

    public boolean increaseLevel(int amount) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Level earned must be positive");
        int supposedFinalLevel = this.getVillagerLevel() + amount;
        Preconditions.checkArgument((1 <= supposedFinalLevel && supposedFinalLevel <= 5 ? 1 : 0) != 0, (Object)"Final level reached after the donation (%d) must be between [%d, %d]".formatted(supposedFinalLevel, 1, 5));
        Int2ObjectMap<VillagerTrades.IMerchantRecipeOption[]> trades = VillagerTrades.a.get(this.getHandle().go().b());
        if (trades == null || trades.isEmpty()) {
            this.getHandle().a(this.getHandle().go().a(supposedFinalLevel));
            return false;
        }
        while (amount > 0) {
            this.getHandle().gK();
            --amount;
        }
        return true;
    }

    public boolean addTrades(int amount) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Number of trades unlocked must be positive");
        return this.getHandle().updateTrades(amount);
    }

    public int getRestocksToday() {
        return this.getHandle().cu;
    }

    public void setRestocksToday(int restocksToday) {
        this.getHandle().cu = restocksToday;
    }

    public boolean sleep(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"Location needs to be in a world");
        Preconditions.checkArgument((boolean)location.getWorld().equals(this.getWorld()), (Object)"Cannot sleep across worlds");
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot sleep during world generation");
        BlockPosition position = CraftLocation.toBlockPosition(location);
        IBlockData iblockdata = this.getHandle().dL().a_(position);
        if (!(iblockdata.b() instanceof BlockBed)) {
            return false;
        }
        this.getHandle().b(position);
        return true;
    }

    public void wakeup() {
        Preconditions.checkState((boolean)this.isSleeping(), (Object)"Cannot wakeup if not sleeping");
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot wakeup during world generation");
        this.getHandle().fD();
    }

    public void shakeHead() {
        this.getHandle().gz();
    }

    public ZombieVillager zombify() {
        EntityZombieVillager entityzombievillager = EntityZombie.zombifyVillager(this.getHandle().dL().getMinecraftWorld(), this.getHandle(), this.getHandle().dl(), this.isSilent(), CreatureSpawnEvent.SpawnReason.CUSTOM);
        return entityzombievillager != null ? (ZombieVillager)entityzombievillager.getBukkitEntity() : null;
    }

    public Reputation getReputation(UUID uniqueId) {
        Reputation.a rep = this.getHandle().gy().c.get(uniqueId);
        if (rep == null) {
            return new Reputation(new EnumMap(ReputationType.class));
        }
        return rep.getPaperReputation();
    }

    public Map<UUID, Reputation> getReputations() {
        return this.getHandle().gy().c.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Reputation.a)entry.getValue()).getPaperReputation()));
    }

    public void setReputation(UUID uniqueId, Reputation reputation) {
        Reputation.a nmsReputation = this.getHandle().gy().c.computeIfAbsent(uniqueId, key -> new Reputation.a());
        nmsReputation.assignFromPaperReputation(reputation);
    }

    public void setReputations(Map<UUID, Reputation> reputations) {
        for (Map.Entry<UUID, Reputation> entry : reputations.entrySet()) {
            this.setReputation(entry.getKey(), entry.getValue());
        }
    }

    public void clearReputations() {
        this.getHandle().gy().c.clear();
    }

    public static class CraftProfession {
        public static Villager.Profession minecraftToBukkit(VillagerProfession minecraft) {
            Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
            IRegistry registry = CraftRegistry.getMinecraftRegistry(Registries.am);
            Villager.Profession bukkit = (Villager.Profession)Registry.VILLAGER_PROFESSION.get(CraftNamespacedKey.fromMinecraft(registry.c(minecraft).orElseThrow().a()));
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            return bukkit;
        }

        public static VillagerProfession bukkitToMinecraft(Villager.Profession bukkit) {
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            return (VillagerProfession)CraftRegistry.getMinecraftRegistry(Registries.am).b(CraftNamespacedKey.toMinecraft(bukkit.getKey())).orElseThrow();
        }
    }

    public static class CraftType {
        public static Villager.Type minecraftToBukkit(VillagerType minecraft) {
            Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
            IRegistry registry = CraftRegistry.getMinecraftRegistry(Registries.an);
            Villager.Type bukkit = (Villager.Type)Registry.VILLAGER_TYPE.get(CraftNamespacedKey.fromMinecraft(registry.c(minecraft).orElseThrow().a()));
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            return bukkit;
        }

        public static VillagerType bukkitToMinecraft(Villager.Type bukkit) {
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            return (VillagerType)CraftRegistry.getMinecraftRegistry(Registries.an).b(CraftNamespacedKey.toMinecraft(bukkit.getKey())).orElseThrow();
        }
    }
}

