/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R2.inventory;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import org.bukkit.Material;
import org.bukkit.MusicInstrument;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftMetaItem;
import org.bukkit.inventory.meta.MusicInstrumentMeta;

@DelegateDeserialization(value=CraftMetaItem.SerializableMeta.class)
public class CraftMetaMusicInstrument
extends CraftMetaItem
implements MusicInstrumentMeta {
    static final CraftMetaItem.ItemMetaKey GOAT_HORN_INSTRUMENT = new CraftMetaItem.ItemMetaKey("instrument");
    private MusicInstrument instrument;

    CraftMetaMusicInstrument(CraftMetaItem meta) {
        super(meta);
        if (meta instanceof CraftMetaMusicInstrument) {
            CraftMetaMusicInstrument craftMetaMusicInstrument = (CraftMetaMusicInstrument)meta;
            this.instrument = craftMetaMusicInstrument.instrument;
        }
    }

    CraftMetaMusicInstrument(NBTTagCompound tag) {
        super(tag);
        if (tag.e(CraftMetaMusicInstrument.GOAT_HORN_INSTRUMENT.NBT)) {
            String string = tag.l(CraftMetaMusicInstrument.GOAT_HORN_INSTRUMENT.NBT);
            this.instrument = (MusicInstrument)Registry.INSTRUMENT.get(NamespacedKey.fromString((String)string));
        }
    }

    CraftMetaMusicInstrument(Map<String, Object> map) {
        super(map);
        String instrumentString = CraftMetaItem.SerializableMeta.getString(map, CraftMetaMusicInstrument.GOAT_HORN_INSTRUMENT.BUKKIT, true);
        if (instrumentString != null) {
            this.instrument = (MusicInstrument)Registry.INSTRUMENT.get(NamespacedKey.fromString((String)instrumentString));
        }
    }

    @Override
    void applyToItem(NBTTagCompound tag) {
        super.applyToItem(tag);
        if (this.instrument != null) {
            tag.a(CraftMetaMusicInstrument.GOAT_HORN_INSTRUMENT.NBT, this.instrument.getKey().toString());
        }
    }

    @Override
    boolean applicableTo(Material type) {
        return type == Material.GOAT_HORN;
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaMusicInstrument) {
            CraftMetaMusicInstrument that = (CraftMetaMusicInstrument)meta;
            return this.instrument == that.instrument;
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaMusicInstrument || this.isInstrumentEmpty());
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isInstrumentEmpty();
    }

    boolean isInstrumentEmpty() {
        return this.instrument == null;
    }

    @Override
    int applyHash() {
        int orginal;
        int hash = orginal = super.applyHash();
        if (this.hasInstrument()) {
            hash = 61 * hash + this.instrument.hashCode();
        }
        return orginal != hash ? CraftMetaMusicInstrument.class.hashCode() ^ hash : hash;
    }

    @Override
    public CraftMetaMusicInstrument clone() {
        CraftMetaMusicInstrument meta = (CraftMetaMusicInstrument)super.clone();
        meta.instrument = this.instrument;
        return meta;
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        if (this.hasInstrument()) {
            builder.put((Object)CraftMetaMusicInstrument.GOAT_HORN_INSTRUMENT.BUKKIT, (Object)this.instrument.getKey().toString());
        }
        return builder;
    }

    public MusicInstrument getInstrument() {
        return this.instrument;
    }

    public boolean hasInstrument() {
        return this.instrument != null;
    }

    public void setInstrument(MusicInstrument instrument) {
        this.instrument = instrument;
    }
}

