/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R2.inventory;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.SharedPlayerProfile;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_20_R2.profile.CraftPlayerProfile;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftNamespacedKey;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.Nullable;

@DelegateDeserialization(value=CraftMetaItem.SerializableMeta.class)
class CraftMetaSkull
extends CraftMetaItem
implements SkullMeta {
    private static final Set<Material> SKULL_MATERIALS = Sets.newHashSet((Object[])new Material[]{Material.CREEPER_HEAD, Material.CREEPER_WALL_HEAD, Material.DRAGON_HEAD, Material.DRAGON_WALL_HEAD, Material.PIGLIN_HEAD, Material.PIGLIN_WALL_HEAD, Material.PLAYER_HEAD, Material.PLAYER_WALL_HEAD, Material.SKELETON_SKULL, Material.SKELETON_WALL_SKULL, Material.WITHER_SKELETON_SKULL, Material.WITHER_SKELETON_WALL_SKULL, Material.ZOMBIE_HEAD, Material.ZOMBIE_WALL_HEAD});
    static final CraftMetaItem.ItemMetaKey SKULL_PROFILE = new CraftMetaItem.ItemMetaKey("SkullProfile");
    static final CraftMetaItem.ItemMetaKey SKULL_OWNER = new CraftMetaItem.ItemMetaKey("SkullOwner", "skull-owner");
    static final CraftMetaItem.ItemMetaKey BLOCK_ENTITY_TAG = new CraftMetaItem.ItemMetaKey("BlockEntityTag");
    static final CraftMetaItem.ItemMetaKey NOTE_BLOCK_SOUND = new CraftMetaItem.ItemMetaKey("note_block_sound");
    static final int MAX_OWNER_LENGTH = 16;
    private GameProfile profile;
    private NBTTagCompound serializedProfile;
    private MinecraftKey noteBlockSound;

    CraftMetaSkull(CraftMetaItem meta) {
        super(meta);
        if (!(meta instanceof CraftMetaSkull)) {
            return;
        }
        CraftMetaSkull skullMeta = (CraftMetaSkull)meta;
        this.setProfile(skullMeta.profile);
        this.noteBlockSound = skullMeta.noteBlockSound;
    }

    CraftMetaSkull(NBTTagCompound tag) {
        super(tag);
        NBTTagCompound nbtTagCompound;
        try {
            if (tag.b(CraftMetaSkull.SKULL_OWNER.NBT, 10)) {
                this.setProfile(GameProfileSerializer.a(tag.p(CraftMetaSkull.SKULL_OWNER.NBT)));
            } else if (tag.b(CraftMetaSkull.SKULL_OWNER.NBT, 8) && !tag.l(CraftMetaSkull.SKULL_OWNER.NBT).isEmpty()) {
                this.setProfile(new GameProfile(SystemUtils.d, tag.l(CraftMetaSkull.SKULL_OWNER.NBT)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tag.b(CraftMetaSkull.BLOCK_ENTITY_TAG.NBT, 10) && (nbtTagCompound = tag.p(CraftMetaSkull.BLOCK_ENTITY_TAG.NBT).h()).b(CraftMetaSkull.NOTE_BLOCK_SOUND.NBT, 8)) {
            this.noteBlockSound = MinecraftKey.a(nbtTagCompound.l(CraftMetaSkull.NOTE_BLOCK_SOUND.NBT));
        }
    }

    CraftMetaSkull(Map<String, Object> map) {
        super(map);
        Object object;
        if (this.profile == null) {
            object = map.get(CraftMetaSkull.SKULL_OWNER.BUKKIT);
            if (object instanceof org.bukkit.profile.PlayerProfile) {
                this.setOwnerProfile((org.bukkit.profile.PlayerProfile)object);
            } else {
                this.setOwner(CraftMetaItem.SerializableMeta.getString(map, CraftMetaSkull.SKULL_OWNER.BUKKIT, true));
            }
        }
        if (this.noteBlockSound == null && (object = map.get(CraftMetaSkull.NOTE_BLOCK_SOUND.BUKKIT)) != null) {
            this.setNoteBlockSound(NamespacedKey.fromString((String)object.toString()));
        }
    }

    @Override
    void deserializeInternal(NBTTagCompound tag, Object context) {
        NBTTagCompound nbtTagCompound;
        super.deserializeInternal(tag, context);
        if (tag.b(CraftMetaSkull.SKULL_PROFILE.NBT, 10)) {
            NBTTagCompound skullTag = tag.p(CraftMetaSkull.SKULL_PROFILE.NBT);
            if (skullTag.b("Id", 8)) {
                UUID uuid = UUID.fromString(skullTag.l("Id"));
                skullTag.a("Id", uuid);
            }
            this.setProfile(GameProfileSerializer.a(skullTag));
        }
        if (tag.b(CraftMetaSkull.BLOCK_ENTITY_TAG.NBT, 10) && (nbtTagCompound = tag.p(CraftMetaSkull.BLOCK_ENTITY_TAG.NBT).h()).b(CraftMetaSkull.NOTE_BLOCK_SOUND.NBT, 8)) {
            this.noteBlockSound = MinecraftKey.a(nbtTagCompound.l(CraftMetaSkull.NOTE_BLOCK_SOUND.NBT));
        }
    }

    private void setProfile(GameProfile profile) {
        this.profile = profile;
        this.serializedProfile = profile == null ? null : GameProfileSerializer.a(new NBTTagCompound(), profile);
    }

    @Override
    void applyToItem(NBTTagCompound tag) {
        super.applyToItem(tag);
        if (this.profile != null) {
            this.checkForInconsistency();
            tag.a(CraftMetaSkull.SKULL_OWNER.NBT, this.serializedProfile);
            CraftPlayerProfile ownerProfile = new CraftPlayerProfile(this.profile);
            if (ownerProfile.getTextures().isEmpty()) {
                ownerProfile.update().thenAccept(filledProfile -> {
                    this.setOwnerProfile((org.bukkit.profile.PlayerProfile)filledProfile);
                    tag.a(CraftMetaSkull.SKULL_OWNER.NBT, this.serializedProfile);
                });
            }
        }
        if (this.noteBlockSound != null) {
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            nbtTagCompound.a(CraftMetaSkull.NOTE_BLOCK_SOUND.NBT, this.noteBlockSound.toString());
            tag.a(CraftMetaSkull.BLOCK_ENTITY_TAG.NBT, nbtTagCompound);
        }
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isSkullEmpty();
    }

    boolean isSkullEmpty() {
        return this.profile == null && this.noteBlockSound == null;
    }

    @Override
    boolean applicableTo(Material type) {
        return SKULL_MATERIALS.contains(type);
    }

    @Override
    public CraftMetaSkull clone() {
        return (CraftMetaSkull)super.clone();
    }

    public boolean hasOwner() {
        return this.profile != null && !this.profile.getName().isEmpty();
    }

    public String getOwner() {
        return this.hasOwner() ? this.profile.getName() : null;
    }

    public void setPlayerProfile(@Nullable PlayerProfile profile) {
        this.setProfile(profile == null ? null : com.destroystokyo.paper.profile.CraftPlayerProfile.asAuthlibCopy(profile));
    }

    @Nullable
    public PlayerProfile getPlayerProfile() {
        return this.profile != null ? com.destroystokyo.paper.profile.CraftPlayerProfile.asBukkitCopy(this.profile) : null;
    }

    public OfflinePlayer getOwningPlayer() {
        if (this.hasOwner()) {
            if (!this.profile.getId().equals(SystemUtils.d)) {
                return Bukkit.getOfflinePlayer((UUID)this.profile.getId());
            }
            if (!this.profile.getName().isEmpty()) {
                return Bukkit.getOfflinePlayer((String)this.profile.getName());
            }
        }
        return null;
    }

    public boolean setOwner(String name) {
        if (name != null && name.length() > 16) {
            return false;
        }
        if (name == null) {
            this.setProfile(null);
        } else {
            GameProfile newProfile = null;
            EntityPlayer player = MinecraftServer.getServer().ac().a(name);
            if (player != null) {
                newProfile = player.fQ();
            }
            if (newProfile == null) {
                newProfile = new GameProfile(SystemUtils.d, name);
            }
            this.setProfile(newProfile);
        }
        return true;
    }

    public boolean setOwningPlayer(OfflinePlayer owner) {
        if (owner == null) {
            this.setProfile(null);
        } else if (owner instanceof CraftPlayer) {
            this.setProfile(((CraftPlayer)owner).getProfile());
        } else {
            this.setProfile(new GameProfile(owner.getUniqueId(), owner.getName()));
        }
        return true;
    }

    @Deprecated
    public org.bukkit.profile.PlayerProfile getOwnerProfile() {
        if (!this.hasOwner()) {
            return null;
        }
        return new CraftPlayerProfile(this.profile);
    }

    @Deprecated
    public void setOwnerProfile(org.bukkit.profile.PlayerProfile profile) {
        if (profile == null) {
            this.setProfile(null);
        } else {
            this.setProfile(CraftPlayerProfile.validateSkullProfile(((SharedPlayerProfile)profile).buildGameProfile()));
        }
    }

    public void setNoteBlockSound(NamespacedKey noteBlockSound) {
        this.noteBlockSound = noteBlockSound == null ? null : CraftNamespacedKey.toMinecraft(noteBlockSound);
    }

    public NamespacedKey getNoteBlockSound() {
        return this.noteBlockSound == null ? null : CraftNamespacedKey.fromMinecraft(this.noteBlockSound);
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.hasOwner()) {
            hash = 61 * hash + this.profile.hashCode();
        }
        if (this.noteBlockSound != null) {
            hash = 61 * hash + this.noteBlockSound.hashCode();
        }
        return original != hash ? CraftMetaSkull.class.hashCode() ^ hash : hash;
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaSkull) {
            CraftMetaSkull that = (CraftMetaSkull)meta;
            this.checkForInconsistency();
            return (this.profile != null ? that.profile != null && this.serializedProfile.equals(that.serializedProfile) : that.profile == null) && Objects.equals(this.noteBlockSound, that.noteBlockSound);
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaSkull || this.isSkullEmpty());
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        if (this.profile != null) {
            return builder.put((Object)CraftMetaSkull.SKULL_OWNER.BUKKIT, (Object)new com.destroystokyo.paper.profile.CraftPlayerProfile(this.profile));
        }
        NamespacedKey namespacedKeyNB = this.getNoteBlockSound();
        if (namespacedKeyNB != null) {
            return builder.put((Object)CraftMetaSkull.NOTE_BLOCK_SOUND.BUKKIT, (Object)namespacedKeyNB.toString());
        }
        return builder;
    }

    private void checkForInconsistency() {
        if (this.profile != null && this.serializedProfile == null) {
            Bukkit.getLogger().warning("Found inconsistent skull meta, this should normally not happen and is not a Bukkit / Spigot issue, but one from a plugin you are using.\nBukkit will attempt to fix it this time for you, but may not be able to do this every time.\nIf you see this message after typing a command from a plugin, please report this to the plugin developer, they should use the api instead of relying on reflection (and doing it the wrong way).");
            this.serializedProfile = GameProfileSerializer.a(new NBTTagCompound(), this.profile);
        }
    }
}

