/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R2.map;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_20_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R2.map.CraftMapCanvas;
import org.bukkit.craftbukkit.v1_20_R2.map.CraftMapRenderer;
import org.bukkit.craftbukkit.v1_20_R2.map.RenderData;
import org.bukkit.entity.Player;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;

public final class CraftMapView
implements MapView {
    private final Map<CraftPlayer, RenderData> renderCache = new HashMap<CraftPlayer, RenderData>();
    private final List<MapRenderer> renderers = new ArrayList<MapRenderer>();
    private final Map<MapRenderer, Map<CraftPlayer, CraftMapCanvas>> canvases = new HashMap<MapRenderer, Map<CraftPlayer, CraftMapCanvas>>();
    protected final WorldMap worldMap;

    public CraftMapView(WorldMap worldMap) {
        this.worldMap = worldMap;
        this.addRenderer(new CraftMapRenderer(this, worldMap));
    }

    public int getId() {
        String text = this.worldMap.id;
        Preconditions.checkState((boolean)text.startsWith("map_"), (Object)"Map has a invalid ID");
        try {
            return Integer.parseInt(text.substring("map_".length()));
        }
        catch (NumberFormatException ex) {
            throw new IllegalStateException("Map has non-numeric ID");
        }
    }

    public boolean isVirtual() {
        return this.renderers.size() > 0 && !(this.renderers.get(0) instanceof CraftMapRenderer);
    }

    public MapView.Scale getScale() {
        return MapView.Scale.valueOf((byte)this.worldMap.f);
    }

    public void setScale(MapView.Scale scale) {
        this.worldMap.f = scale.getValue();
    }

    public World getWorld() {
        ResourceKey<net.minecraft.world.level.World> dimension = this.worldMap.e;
        WorldServer world = MinecraftServer.getServer().a(dimension);
        if (world != null) {
            return world.getWorld();
        }
        if (this.worldMap.uniqueId != null) {
            return Bukkit.getServer().getWorld(this.worldMap.uniqueId);
        }
        return null;
    }

    public void setWorld(World world) {
        this.worldMap.e = ((CraftWorld)world).getHandle().ac();
        this.worldMap.uniqueId = world.getUID();
    }

    public int getCenterX() {
        return this.worldMap.c;
    }

    public int getCenterZ() {
        return this.worldMap.d;
    }

    public void setCenterX(int x2) {
        this.worldMap.c = x2;
    }

    public void setCenterZ(int z2) {
        this.worldMap.d = z2;
    }

    public List<MapRenderer> getRenderers() {
        return new ArrayList<MapRenderer>(this.renderers);
    }

    public void addRenderer(MapRenderer renderer) {
        if (!this.renderers.contains(renderer)) {
            this.renderers.add(renderer);
            this.canvases.put(renderer, new HashMap());
            renderer.initialize((MapView)this);
        }
    }

    public boolean removeRenderer(MapRenderer renderer) {
        if (this.renderers.contains(renderer)) {
            this.renderers.remove(renderer);
            for (Map.Entry<CraftPlayer, CraftMapCanvas> entry : this.canvases.get(renderer).entrySet()) {
                for (int x2 = 0; x2 < 128; ++x2) {
                    for (int y2 = 0; y2 < 128; ++y2) {
                        entry.getValue().setPixel(x2, y2, (byte)-1);
                    }
                }
            }
            this.canvases.remove(renderer);
            return true;
        }
        return false;
    }

    private boolean isContextual() {
        for (MapRenderer renderer : this.renderers) {
            if (!renderer.isContextual()) continue;
            return true;
        }
        return false;
    }

    public RenderData render(CraftPlayer player) {
        boolean context = this.isContextual();
        RenderData render = this.renderCache.get(context ? player : null);
        if (render == null) {
            render = new RenderData();
            this.renderCache.put(context ? player : null, render);
        }
        if (context && this.renderCache.containsKey(null)) {
            this.renderCache.remove(null);
        }
        Arrays.fill(render.buffer, (byte)0);
        render.cursors.clear();
        Iterator<MapRenderer> iterator = this.renderers.iterator();
        while (iterator.hasNext()) {
            int i2;
            MapRenderer renderer;
            CraftMapCanvas canvas = this.canvases.get(renderer).get((renderer = iterator.next()).isContextual() ? player : null);
            if (canvas == null) {
                canvas = new CraftMapCanvas(this);
                this.canvases.get(renderer).put(renderer.isContextual() ? player : null, canvas);
            }
            canvas.setBase(render.buffer);
            try {
                renderer.render((MapView)this, (MapCanvas)canvas, (Player)player);
            }
            catch (Throwable ex) {
                Bukkit.getLogger().log(Level.SEVERE, "Could not render map using renderer " + renderer.getClass().getName(), ex);
            }
            byte[] buf = canvas.getBuffer();
            for (i2 = 0; i2 < buf.length; ++i2) {
                byte color = buf[i2];
                if (color < 0 && color > -9) continue;
                render.buffer[i2] = color;
            }
            for (i2 = 0; i2 < canvas.getCursors().size(); ++i2) {
                render.cursors.add(canvas.getCursors().getCursor(i2));
            }
        }
        return render;
    }

    public boolean isTrackingPosition() {
        return this.worldMap.l;
    }

    public void setTrackingPosition(boolean trackingPosition) {
        this.worldMap.l = trackingPosition;
    }

    public boolean isUnlimitedTracking() {
        return this.worldMap.m;
    }

    public void setUnlimitedTracking(boolean unlimited) {
        this.worldMap.m = unlimited;
    }

    public boolean isLocked() {
        return this.worldMap.h;
    }

    public void setLocked(boolean locked) {
        this.worldMap.h = locked;
    }
}

