/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R2.projectiles;

import com.google.common.base.Preconditions;
import java.util.function.Consumer;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.core.dispenser.SourceBlock;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityEgg;
import net.minecraft.world.entity.projectile.EntityEnderPearl;
import net.minecraft.world.entity.projectile.EntityFireball;
import net.minecraft.world.entity.projectile.EntityPotion;
import net.minecraft.world.entity.projectile.EntityProjectile;
import net.minecraft.world.entity.projectile.EntitySmallFireball;
import net.minecraft.world.entity.projectile.EntitySnowball;
import net.minecraft.world.entity.projectile.EntitySpectralArrow;
import net.minecraft.world.entity.projectile.EntityThrownExpBottle;
import net.minecraft.world.entity.projectile.EntityTippedArrow;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.level.block.entity.TileEntityDispenser;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftItemStack;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Egg;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.LingeringPotion;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.SmallFireball;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.TippedArrow;
import org.bukkit.entity.WitherSkull;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;
import org.bukkit.projectiles.BlockProjectileSource;
import org.bukkit.util.Vector;

public class CraftBlockProjectileSource
implements BlockProjectileSource {
    private final TileEntityDispenser dispenserBlock;

    public CraftBlockProjectileSource(TileEntityDispenser dispenserBlock) {
        this.dispenserBlock = dispenserBlock;
    }

    public Block getBlock() {
        return this.dispenserBlock.k().getWorld().getBlockAt(this.dispenserBlock.p().u(), this.dispenserBlock.p().v(), this.dispenserBlock.p().w());
    }

    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile) {
        return this.launchProjectile(projectile, null);
    }

    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile, Vector velocity) {
        return this.launchProjectile(projectile, velocity, null);
    }

    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile, Vector velocity, Consumer<? super T> function) {
        Preconditions.checkArgument((this.getBlock().getType() == Material.DISPENSER ? 1 : 0) != 0, (Object)"Block is no longer dispenser");
        SourceBlock sourceblock = new SourceBlock((WorldServer)this.dispenserBlock.k(), this.dispenserBlock.p(), this.dispenserBlock.q(), this.dispenserBlock);
        IPosition iposition = BlockDispenser.a(sourceblock);
        EnumDirection enumdirection = sourceblock.d().c(BlockDispenser.a);
        World world = this.dispenserBlock.k();
        IProjectile launch = null;
        if (Snowball.class.isAssignableFrom(projectile)) {
            launch = new EntitySnowball(world, iposition.a(), iposition.b(), iposition.c());
        } else if (Egg.class.isAssignableFrom(projectile)) {
            launch = new EntityEgg(world, iposition.a(), iposition.b(), iposition.c());
        } else if (EnderPearl.class.isAssignableFrom(projectile)) {
            launch = new EntityEnderPearl(world, null);
            launch.e(iposition.a(), iposition.b(), iposition.c());
        } else if (ThrownExpBottle.class.isAssignableFrom(projectile)) {
            launch = new EntityThrownExpBottle(world, iposition.a(), iposition.b(), iposition.c());
        } else if (ThrownPotion.class.isAssignableFrom(projectile)) {
            if (LingeringPotion.class.isAssignableFrom(projectile)) {
                launch = new EntityPotion(world, iposition.a(), iposition.b(), iposition.c());
                ((EntityPotion)launch).a(CraftItemStack.asNMSCopy(new ItemStack(Material.LINGERING_POTION, 1)));
            } else {
                launch = new EntityPotion(world, iposition.a(), iposition.b(), iposition.c());
                ((EntityPotion)launch).a(CraftItemStack.asNMSCopy(new ItemStack(Material.SPLASH_POTION, 1)));
            }
        } else if (AbstractArrow.class.isAssignableFrom(projectile)) {
            if (TippedArrow.class.isAssignableFrom(projectile)) {
                launch = new EntityTippedArrow(world, iposition.a(), iposition.b(), iposition.c());
                ((Arrow)launch.getBukkitEntity()).setBasePotionData(new PotionData(PotionType.WATER, false, false));
            } else {
                launch = SpectralArrow.class.isAssignableFrom(projectile) ? new EntitySpectralArrow(world, iposition.a(), iposition.b(), iposition.c()) : new EntityTippedArrow(world, iposition.a(), iposition.b(), iposition.c());
            }
            ((EntityArrow)launch).d = EntityArrow.PickupStatus.b;
            ((EntityArrow)launch).projectileSource = this;
        } else if (Fireball.class.isAssignableFrom(projectile)) {
            double d0 = iposition.a() + (double)((float)enumdirection.j() * 0.3f);
            double d1 = iposition.b() + (double)((float)enumdirection.k() * 0.3f);
            double d2 = iposition.c() + (double)((float)enumdirection.l() * 0.3f);
            RandomSource random = world.z;
            double d3 = random.k() * 0.05 + (double)enumdirection.j();
            double d4 = random.k() * 0.05 + (double)enumdirection.k();
            double d5 = random.k() * 0.05 + (double)enumdirection.l();
            if (SmallFireball.class.isAssignableFrom(projectile)) {
                launch = new EntitySmallFireball(world, null, d0, d1, d2);
            } else if (WitherSkull.class.isAssignableFrom(projectile)) {
                launch = EntityTypes.bm.a(world);
                launch.e(d0, d1, d2);
                double d6 = Math.sqrt(d3 * d3 + d4 * d4 + d5 * d5);
                ((EntityFireball)launch).b = d3 / d6 * 0.1;
                ((EntityFireball)launch).c = d4 / d6 * 0.1;
                ((EntityFireball)launch).d = d5 / d6 * 0.1;
            } else {
                launch = EntityTypes.ag.a(world);
                launch.e(d0, d1, d2);
                double d6 = Math.sqrt(d3 * d3 + d4 * d4 + d5 * d5);
                ((EntityFireball)launch).b = d3 / d6 * 0.1;
                ((EntityFireball)launch).c = d4 / d6 * 0.1;
                ((EntityFireball)launch).d = d5 / d6 * 0.1;
            }
            ((EntityFireball)launch).projectileSource = this;
        }
        Preconditions.checkArgument((launch != null ? 1 : 0) != 0, (Object)"Projectile not supported");
        if (launch instanceof IProjectile) {
            if (launch instanceof EntityProjectile) {
                ((EntityProjectile)launch).projectileSource = this;
            }
            float a2 = 6.0f;
            float b2 = 1.1f;
            if (launch instanceof EntityPotion || launch instanceof ThrownExpBottle) {
                a2 *= 0.5f;
                b2 *= 1.25f;
            }
            ((IProjectile)launch).c(enumdirection.j(), (float)enumdirection.k() + 0.1f, enumdirection.l(), b2, a2);
        }
        if (velocity != null) {
            ((Projectile)launch.getBukkitEntity()).setVelocity(velocity);
        }
        if (function != null) {
            function.accept((Projectile)launch.getBukkitEntity());
        }
        world.b(launch);
        return (T)((Projectile)launch.getBukkitEntity());
    }
}

