/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.bot;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.generator.WorldInfo;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.PluginManager;
import org.jetbrains.annotations.NotNull;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.bot.ServerBot;
import top.leavesmc.leaves.bot.agent.Actions;
import top.leavesmc.leaves.bot.agent.BotAction;
import top.leavesmc.leaves.bot.agent.actions.CraftCustomBotAction;
import top.leavesmc.leaves.entity.Bot;

public class BotCommand
extends Command {
    public BotCommand(String name) {
        super(name);
        this.description = "FakePlayer Command";
        this.usageMessage = "/bot [create | remove | action | list]";
        this.setPermission("bukkit.command.bot");
        PluginManager pluginManager = Bukkit.getServer().getPluginManager();
        if (pluginManager.getPermission("bukkit.command.bot") == null) {
            pluginManager.addPermission(new Permission("bukkit.command.bot", PermissionDefault.OP));
        }
    }

    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, String @NotNull [] args, Location location) throws IllegalArgumentException {
        BotAction action;
        ArrayList<String> list = new ArrayList<String>();
        if (args.length <= 1) {
            list.add("create");
            list.add("remove");
            list.add("action");
            list.add("list");
        }
        if (args.length == 2) {
            switch (args[0]) {
                case "create": {
                    list.add("<BotName>");
                    break;
                }
                case "remove": 
                case "action": {
                    list.addAll(ServerBot.getBots().stream().map(e2 -> e2.ab().getString()).toList());
                    break;
                }
                case "list": {
                    list.addAll(Bukkit.getWorlds().stream().map(WorldInfo::getName).toList());
                }
            }
        }
        if (args.length == 3) {
            switch (args[0]) {
                case "action": {
                    list.add("list");
                    list.addAll(Actions.getNames());
                    break;
                }
                case "create": {
                    list.add("<BotSkinName>");
                }
            }
        }
        if (args.length >= 4 && args[0].equals("action") && (action = Actions.getForName(args[2])) != null) {
            list.addAll(action.getArgument().tabComplete(args.length - 4));
        }
        return list;
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage(ChatColor.RED + "Usage: " + this.usageMessage);
            return false;
        }
        switch (args[0]) {
            case "create": {
                this.onCreate(sender, args);
                break;
            }
            case "remove": {
                this.onRemove(sender, args);
                break;
            }
            case "action": {
                this.onAction(sender, args);
                break;
            }
            case "list": {
                this.onList(sender, args);
                break;
            }
            default: {
                sender.sendMessage(ChatColor.RED + "Usage: " + this.usageMessage);
                return false;
            }
        }
        return true;
    }

    private void onCreate(CommandSender sender, String @NotNull [] args) {
        if (args.length < 2) {
            sender.sendMessage(ChatColor.RED + "Use /bot create <name> [skin_name] to create a fakeplayer");
            return;
        }
        if (this.canCreate(sender, args[1])) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                new ServerBot.BotCreateState(player.getLocation(), args[1], args.length < 3 ? args[1] : args[2]).createAsync(bot -> {
                    bot.createPlayer = player.getUniqueId();
                });
            } else if (sender instanceof ConsoleCommandSender) {
                if (args.length < 6) {
                    sender.sendMessage(ChatColor.RED + "Use /bot create <name> <skin_name> <bukkit_world_name> <x> <y> <z> to create a fakeplayer");
                    return;
                }
                try {
                    World world = Bukkit.getWorld((String)args[3]);
                    double x2 = Double.parseDouble(args[4]);
                    double y2 = Double.parseDouble(args[5]);
                    double z2 = Double.parseDouble(args[6]);
                    if (world != null) {
                        new ServerBot.BotCreateState(new Location(world, x2, y2, z2), args[1], args[2]).createAsync(null);
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
    }

    private boolean canCreate(CommandSender sender, @NotNull String name) {
        if (!name.matches("^[a-zA-Z0-9_]{4,16}$")) {
            sender.sendMessage(ChatColor.RED + "This name is illegal");
            return false;
        }
        if (Bukkit.getPlayer((String)name) != null || ServerBot.getBot(name) != null) {
            sender.sendMessage(ChatColor.RED + "This player is in server");
            return false;
        }
        if (LeavesConfig.unableFakeplayerNames.contains(name)) {
            sender.sendMessage(ChatColor.RED + "This name is not allowed");
            return false;
        }
        if (ServerBot.getBots().size() >= LeavesConfig.fakeplayerLimit) {
            sender.sendMessage(ChatColor.RED + "Fakeplayer limit is full");
            return false;
        }
        return true;
    }

    private void onRemove(CommandSender sender, String @NotNull [] args) {
        if (args.length < 2) {
            sender.sendMessage(ChatColor.RED + "Use /bot remove <name> to remove a fakeplayer");
            return;
        }
        ServerBot bot = ServerBot.getBot(args[1]);
        if (bot == null) {
            sender.sendMessage(ChatColor.RED + "This fakeplayer is not in server");
            return;
        }
        bot.a(bot.dM().m());
    }

    private void onAction(CommandSender sender, String @NotNull [] args) {
        BotAction newAction;
        if (args.length < 3) {
            sender.sendMessage(ChatColor.RED + "Use /bot action <name> <action> to make fakeplayer do action");
            return;
        }
        ServerBot bot = ServerBot.getBot(args[1]);
        if (bot == null) {
            sender.sendMessage(ChatColor.RED + "This fakeplayer is not in server");
            return;
        }
        if (args[2].equals("list")) {
            sender.sendMessage(bot.cx() + "'s action list:");
            for (BotAction action : bot.getBotActions()) {
                sender.sendMessage(action.getName());
            }
            return;
        }
        BotAction action = Actions.getForName(args[2]);
        if (action == null) {
            sender.sendMessage(ChatColor.RED + "Invalid action");
            return;
        }
        CraftPlayer player = sender instanceof CraftPlayer ? (CraftPlayer)sender : bot.getBukkitEntity();
        if (action instanceof CraftCustomBotAction) {
            CraftCustomBotAction customBotAction = (CraftCustomBotAction)action;
            String[] realArgs = new String[args.length - 3];
            if (realArgs.length != 0) {
                System.arraycopy(args, 3, realArgs, 0, realArgs.length);
            }
            newAction = customBotAction.getNew(player, realArgs);
        } else {
            newAction = action.getNew(player.getHandle(), action.getArgument().parse(3, args));
        }
        if (newAction == null) {
            sender.sendMessage(ChatColor.RED + "Action create error, please check your arguments");
            return;
        }
        bot.setBotAction(newAction);
        sender.sendMessage("Action " + action.getName() + " has been issued to " + bot.ab().getString());
    }

    private void onList(CommandSender sender, String @NotNull [] args) {
        if (args.length < 2) {
            HashMap botMap = new HashMap();
            for (World world : Bukkit.getWorlds()) {
                botMap.put(world, new ArrayList());
            }
            for (ServerBot bot : ServerBot.getBots()) {
                Bot bukkitBot = bot.getBukkitPlayer();
                ((List)botMap.get(bukkitBot.getWorld())).add(bukkitBot.getName());
            }
            sender.sendMessage("Total number: (" + ServerBot.getBots().size() + "/" + LeavesConfig.fakeplayerLimit + ")");
            for (World world : botMap.keySet()) {
                sender.sendMessage(world.getName() + "(" + ((List)botMap.get(world)).size() + "): " + BotCommand.formatPlayerNameList((List)botMap.get(world)));
            }
        } else {
            World world = Bukkit.getWorld((String)args[2]);
            if (world == null) {
                sender.sendMessage(ChatColor.RED + "Unknown world");
                return;
            }
            ArrayList<String> botList = new ArrayList<String>();
            for (ServerBot bot : ServerBot.getBots()) {
                Bot bukkitBot = bot.getBukkitPlayer();
                if (bukkitBot.getWorld() != world) continue;
                botList.add(bukkitBot.getName());
            }
            sender.sendMessage(world.getName() + "(" + botList.size() + "): " + BotCommand.formatPlayerNameList(botList));
        }
    }

    @NotNull
    private static String formatPlayerNameList(@NotNull List<String> list) {
        if (list.isEmpty()) {
            return "";
        }
        String string = list.toString();
        return string.substring(1, string.length() - 1);
    }
}

