/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.bot;

import com.google.common.base.Charsets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.SavedFile;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import top.leavesmc.leaves.bot.ServerBot;
import top.leavesmc.leaves.bot.agent.Actions;
import top.leavesmc.leaves.bot.agent.BotAction;

public class BotUtil {
    public static void replenishment(@NotNull ItemStack itemStack, NonNullList<ItemStack> itemStackList) {
        int count = itemStack.g() / 2;
        if (itemStack.L() <= 8 && count > 8) {
            for (ItemStack itemStack1 : itemStackList) {
                if (itemStack1 == ItemStack.b || itemStack1 == itemStack || !ItemStack.c(itemStack1, itemStack)) continue;
                if (itemStack1.L() > count) {
                    itemStack.f(itemStack.L() + count);
                    itemStack1.f(itemStack1.L() - count);
                    break;
                }
                itemStack.f(itemStack.L() + itemStack1.L());
                itemStack1.f(0);
                break;
            }
        }
    }

    public static void replaceTool(@NotNull EnumItemSlot slot, @NotNull ServerBot bot) {
        ItemStack itemStack1;
        int i2;
        ItemStack itemStack = bot.c(slot);
        for (i2 = 0; i2 < 36; ++i2) {
            itemStack1 = bot.fR().a(i2);
            if (itemStack1 == ItemStack.b || itemStack1 == itemStack || itemStack1.d().getClass() != itemStack.d().getClass() || BotUtil.isDamage(itemStack1, 10)) continue;
            ItemStack itemStack2 = itemStack1.p();
            bot.fR().a(i2, itemStack);
            bot.a(slot, itemStack2);
            return;
        }
        for (i2 = 0; i2 < 36; ++i2) {
            itemStack1 = bot.fR().a(i2);
            if (itemStack1 != ItemStack.b || itemStack1 == itemStack) continue;
            bot.fR().a(i2, itemStack);
            bot.a(slot, ItemStack.b);
            return;
        }
    }

    public static boolean isDamage(@NotNull ItemStack item, int minDamage) {
        return item.i() && item.l() - item.k() <= minDamage;
    }

    @NotNull
    public static JsonObject saveBot(@NotNull ServerBot bot) {
        double pos_x = bot.dq();
        double pos_y = bot.ds();
        double pos_z = bot.dw();
        float yaw = bot.dB();
        float pitch = bot.dD();
        String dimension = bot.getLocation().getWorld().getName();
        String skin = bot.createState.skinName;
        JsonObject fakePlayer = new JsonObject();
        fakePlayer.addProperty("pos_x", (Number)pos_x);
        fakePlayer.addProperty("pos_y", (Number)pos_y);
        fakePlayer.addProperty("pos_z", (Number)pos_z);
        fakePlayer.addProperty("yaw", (Number)Float.valueOf(yaw));
        fakePlayer.addProperty("pitch", (Number)Float.valueOf(pitch));
        fakePlayer.addProperty("dimension", dimension);
        fakePlayer.addProperty("skin", skin);
        Collection<BotAction> actions = bot.getBotActions();
        JsonArray botActions = new JsonArray();
        for (BotAction action : actions) {
            JsonObject actionObj = new JsonObject();
            actionObj.addProperty("name", action.getName());
            actionObj.addProperty("number", String.valueOf(action.getNumber()));
            actionObj.addProperty("delay", String.valueOf(action.getTickDelay()));
            botActions.add((JsonElement)actionObj);
        }
        fakePlayer.add("actions", (JsonElement)botActions);
        NBTTagCompound invnbt = new NBTTagCompound();
        invnbt.a("Inventory", bot.fR().a(new NBTTagList()));
        File file = MinecraftServer.getServer().a(SavedFile.l).resolve("fakeplayer/" + bot.cw() + ".dat").toFile();
        File parent = file.getParentFile();
        try {
            if (!parent.exists() || !parent.isDirectory()) {
                parent.mkdirs();
            }
            if (file.exists() && file.isFile()) {
                file.delete();
            }
            file.createNewFile();
            NBTCompressedStreamTools.a(invnbt, file);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return fakePlayer;
    }

    public static void loadBot( @NotNull Map.Entry<String, JsonElement> entry) {
        String username = entry.getKey();
        JsonObject fakePlayer = entry.getValue().getAsJsonObject();
        double pos_x = fakePlayer.get("pos_x").getAsDouble();
        double pos_y = fakePlayer.get("pos_y").getAsDouble();
        double pos_z = fakePlayer.get("pos_z").getAsDouble();
        float yaw = fakePlayer.get("yaw").getAsFloat();
        float pitch = fakePlayer.get("pitch").getAsFloat();
        String dimension = fakePlayer.get("dimension").getAsString();
        String skin = fakePlayer.get("skin").getAsString();
        Location location = new Location(Bukkit.getWorld((String)dimension), pos_x, pos_y, pos_z, yaw, pitch);
        ServerBot.BotCreateState state = new ServerBot.BotCreateState(location, username, skin);
        NBTTagList inv = null;
        File file = MinecraftServer.getServer().a(SavedFile.l).resolve("fakeplayer/" + BotUtil.getBotUUID(state) + ".dat").toFile();
        if (file.exists()) {
            try {
                NBTTagCompound nbt = NBTCompressedStreamTools.a(file);
                inv = nbt.c("Inventory", 10);
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            file.delete();
        }
        JsonArray finalActions = fakePlayer.get("actions").getAsJsonArray();
        NBTTagList finalInv = inv;
        state.createAsync(serverBot -> {
            if (finalInv != null) {
                serverBot.fR().b(finalInv);
            }
            for (JsonElement element : finalActions) {
                JsonObject actionObj = element.getAsJsonObject();
                BotAction action = Actions.getForName(actionObj.get("name").getAsString());
                if (action == null) continue;
                BotAction newAction = action.getNew((EntityPlayer)serverBot, action.getArgument().parse(0, new String[]{actionObj.get("delay").getAsString(), actionObj.get("number").getAsString()}));
                serverBot.setBotAction(newAction);
            }
        });
    }

    @NotNull
    public static UUID getBotUUID(@NotNull ServerBot.BotCreateState state) {
        return UUID.nameUUIDFromBytes(("Fakeplayer:" + state.getRealName()).getBytes(Charsets.UTF_8));
    }
}

