/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.protocol;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockDirectional;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.level.block.BlockGlazedTerracotta;
import net.minecraft.world.level.block.BlockObserver;
import net.minecraft.world.level.block.BlockRedstoneComparator;
import net.minecraft.world.level.block.BlockRepeater;
import net.minecraft.world.level.block.BlockStairs;
import net.minecraft.world.level.block.BlockTrapdoor;
import net.minecraft.world.level.block.piston.BlockPiston;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyComparatorMode;
import net.minecraft.world.level.block.state.properties.BlockPropertyHalf;
import net.minecraft.world.level.block.state.properties.BlockPropertySlabType;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.phys.Vec3D;
import org.jetbrains.annotations.NotNull;

public class CarpetAlternativeBlockPlacement {
    @Nullable
    public static IBlockData alternativeBlockPlacement(@NotNull Block block, @NotNull BlockActionContext context) {
        Vec3D hitPos = context.l();
        BlockPosition blockPos = context.a();
        double relativeHitX = hitPos.c - (double)blockPos.u();
        IBlockData state = block.a(context);
        if (relativeHitX < 2.0 || state == null) {
            return null;
        }
        BlockStateDirection directionProp = CarpetAlternativeBlockPlacement.getFirstDirectionProperty(state);
        int protocolValue = ((int)relativeHitX - 2) / 2;
        if (directionProp != null) {
            EnumDirection origFacing;
            EnumDirection facing = origFacing = state.c(directionProp);
            int facingIndex = protocolValue & 0xF;
            if (facingIndex == 6) {
                facing = facing.g();
            } else if (facingIndex <= 5) {
                facing = EnumDirection.a(facingIndex);
            }
            if (!directionProp.a().contains(facing)) {
                facing = context.o().cD().g();
            }
            if (facing != origFacing && directionProp.a().contains(facing)) {
                if (state.b() instanceof BlockBed) {
                    BlockPosition headPos = blockPos.a(facing);
                    if (!context.q().a_(headPos).a(context)) {
                        return null;
                    }
                }
                state = (IBlockData)state.a(directionProp, facing);
            }
        } else if (state.b(BlockProperties.I)) {
            EnumDirection.EnumAxis axis = EnumDirection.EnumAxis.d[protocolValue % 3];
            state = (IBlockData)state.a(BlockProperties.I, axis);
        }
        if ((protocolValue &= 0xFFFFFFF0) >= 16) {
            if (block instanceof BlockRepeater) {
                Integer delay = protocolValue / 16;
                if (BlockRepeater.d.a().contains(delay)) {
                    state = (IBlockData)state.a(BlockRepeater.d, delay);
                }
            } else if (protocolValue == 16) {
                if (block instanceof BlockRedstoneComparator) {
                    state = (IBlockData)state.a(BlockRedstoneComparator.a, BlockPropertyComparatorMode.b);
                } else if (state.b(BlockProperties.af) && state.c(BlockProperties.af) == BlockPropertyHalf.b) {
                    state = (IBlockData)state.a(BlockProperties.af, BlockPropertyHalf.a);
                } else if (state.b(BlockProperties.bh) && state.c(BlockProperties.bh) == BlockPropertySlabType.b) {
                    state = (IBlockData)state.a(BlockProperties.bh, BlockPropertySlabType.a);
                }
            }
        }
        return state;
    }

    public static IBlockData alternativeBlockPlacementFix(Block block, BlockActionContext context) {
        Vec3D vec3d = context.l();
        BlockPosition pos = context.a();
        double hitX = vec3d.c - (double)pos.u();
        if (hitX < 2.0) {
            return null;
        }
        int code = (int)(hitX - 2.0) / 2;
        EntityHuman placer = Objects.requireNonNull(context.o());
        World world = context.q();
        if (block instanceof BlockGlazedTerracotta) {
            EnumDirection facing = EnumDirection.a(code);
            if (facing == EnumDirection.b || facing == EnumDirection.a) {
                facing = placer.cD().g();
            }
            return (IBlockData)block.n().a(BlockGlazedTerracotta.aC, facing);
        }
        if (block instanceof BlockObserver) {
            return (IBlockData)((IBlockData)block.n().a(BlockObserver.a, EnumDirection.a(code))).a(BlockObserver.b, true);
        }
        if (block instanceof BlockRepeater) {
            EnumDirection facing = EnumDirection.a(code % 16);
            if (facing == EnumDirection.b || facing == EnumDirection.a) {
                facing = placer.cD().g();
            }
            return (IBlockData)((IBlockData)((IBlockData)block.n().a(BlockRepeater.aC, facing)).a(BlockRepeater.d, MathHelper.a(code / 16, 1, 4))).a(BlockRepeater.a, Boolean.FALSE);
        }
        if (block instanceof BlockTrapdoor) {
            EnumDirection facing = EnumDirection.a(code % 16);
            if (facing == EnumDirection.b || facing == EnumDirection.a) {
                facing = placer.cD().g();
            }
            return (IBlockData)((IBlockData)((IBlockData)((IBlockData)block.n().a(BlockTrapdoor.aC, facing)).a(BlockTrapdoor.a, Boolean.FALSE)).a(BlockTrapdoor.b, code >= 16 ? BlockPropertyHalf.a : BlockPropertyHalf.b)).a(BlockTrapdoor.a, world.B(pos));
        }
        if (block instanceof BlockRedstoneComparator) {
            EnumDirection facing = EnumDirection.a(code % 16);
            if (facing == EnumDirection.b || facing == EnumDirection.a) {
                facing = placer.cD().g();
            }
            BlockPropertyComparatorMode m2 = hitX >= 16.0 ? BlockPropertyComparatorMode.b : BlockPropertyComparatorMode.a;
            return (IBlockData)((IBlockData)((IBlockData)block.n().a(BlockRedstoneComparator.aC, facing)).a(BlockRedstoneComparator.c, Boolean.FALSE)).a(BlockRedstoneComparator.a, m2);
        }
        if (block instanceof BlockDispenser) {
            return (IBlockData)((IBlockData)block.n().a(BlockDispenser.a, EnumDirection.a(code))).a(BlockDispenser.b, Boolean.FALSE);
        }
        if (block instanceof BlockPiston) {
            return (IBlockData)((IBlockData)block.n().a(BlockDirectional.a, EnumDirection.a(code))).a(BlockPiston.b, Boolean.FALSE);
        }
        if (block instanceof BlockStairs) {
            return (IBlockData)((IBlockData)Objects.requireNonNull(block.a(context)).a(BlockStairs.a, EnumDirection.a(code % 16))).a(BlockStairs.b, hitX >= 16.0 ? BlockPropertyHalf.a : BlockPropertyHalf.b);
        }
        return null;
    }

    @Nullable
    public static BlockStateDirection getFirstDirectionProperty(@NotNull IBlockData state) {
        for (IBlockState<?> prop : state.B()) {
            if (!(prop instanceof BlockStateDirection)) continue;
            return (BlockStateDirection)prop;
        }
        return null;
    }
}

