/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.protocol;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.LeavesLogger;
import top.leavesmc.leaves.protocol.core.LeavesProtocol;
import top.leavesmc.leaves.protocol.core.ProtocolHandler;
import top.leavesmc.leaves.protocol.core.ProtocolUtils;

@LeavesProtocol(namespace="carpet")
public class CarpetServerProtocol {
    public static final String PROTOCOL_ID = "carpet";
    public static final String VERSION = "leaves-carpet-1.0.0";
    private static final MinecraftKey HELLO_ID = CarpetServerProtocol.id("hello");
    private static final String HI = "69";
    private static final String HELLO = "420";

    @Contract(value="_ -> new")
    @NotNull
    public static MinecraftKey id(String path) {
        return new MinecraftKey(PROTOCOL_ID, path);
    }

    @ProtocolHandler.PlayerJoin
    public static void onPlayerJoin(EntityPlayer player) {
        if (LeavesConfig.leavesCarpetSupport) {
            NBTTagCompound data = new NBTTagCompound();
            data.a(HI, VERSION);
            ProtocolUtils.sendPayloadPacket(player, new CarpetPayload(data));
        }
    }

    @ProtocolHandler.PayloadReceiver(payload=CarpetPayload.class, payloadId="hello")
    private static void handleHello(@NotNull EntityPlayer player, @NotNull CarpetPayload payload) {
        if (LeavesConfig.leavesCarpetSupport && payload.nbt.e(HELLO)) {
            LeavesLogger.LOGGER.info("Player " + player.cx() + " joined with carpet " + payload.nbt.l(HELLO));
            NBTTagCompound data = new NBTTagCompound();
            CarpetRules.write(data);
            ProtocolUtils.sendPayloadPacket(player, new CarpetPayload(data));
        }
    }

    public record CarpetPayload(NBTTagCompound nbt) implements CustomPacketPayload
    {
        public CarpetPayload(MinecraftKey location, PacketDataSerializer buf) {
            this(buf.p());
        }

        @Override
        public void a(PacketDataSerializer buf) {
            buf.a(this.nbt);
        }

        @Override
        @NotNull
        public MinecraftKey a() {
            return HELLO_ID;
        }
    }

    public static class CarpetRules {
        private static final Map<String, CarpetRule> rules = new HashMap<String, CarpetRule>();

        public static void write(@NotNull NBTTagCompound tag) {
            NBTTagCompound rulesNbt = new NBTTagCompound();
            rules.values().forEach(rule -> rule.writeNBT(rulesNbt));
            tag.a("Rules", rulesNbt);
        }

        public static void register(CarpetRule rule) {
            rules.put(rule.name, rule);
        }
    }

    public record CarpetRule(String identifier, String name, String value) {
        @NotNull
        @Contract(value="_, _, _ -> new")
        public static CarpetRule of(String identifier, String name, boolean value) {
            return new CarpetRule(identifier, name, Boolean.toString(value));
        }

        public void writeNBT(@NotNull NBTTagCompound rules) {
            NBTTagCompound rule = new NBTTagCompound();
            rule.a("Value", this.value);
            rule.a("Manager", this.identifier);
            rule.a("Rule", this.name);
            rules.a(this.name, rule);
        }
    }
}

