/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.protocol;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Comparator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertySlabType;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.phys.Vec3D;
import top.leavesmc.leaves.LeavesLogger;
import top.leavesmc.leaves.util.MathUtils;

public class LitematicaEasyPlaceProtocol {
    public static final ImmutableSet<IBlockState<?>> WHITELISTED_PROPERTIES = ImmutableSet.of((Object)BlockProperties.p, (Object)BlockProperties.u, (Object)BlockProperties.v, BlockProperties.I, BlockProperties.af, BlockProperties.bc, (Object[])new IBlockState[]{BlockProperties.bd, BlockProperties.be, BlockProperties.bh, BlockProperties.bi, BlockProperties.U, BlockProperties.ay, BlockProperties.aA, BlockProperties.aR, BlockProperties.ba});

    public static <T extends Comparable<T>> IBlockData applyPlacementProtocol(IBlockData state, BlockActionContext context) {
        return LitematicaEasyPlaceProtocol.applyPlacementProtocolV3(state, UseContext.from(context, context.p()));
    }

    private static <T extends Comparable<T>> IBlockData applyPlacementProtocolV3(IBlockData state, UseContext context) {
        int protocolValue = (int)(context.getHitVec().c - (double)context.getPos().u()) - 2;
        if (protocolValue < 0) {
            return state;
        }
        BlockStateDirection property = LitematicaEasyPlaceProtocol.getFirstDirectionProperty(state);
        if (property != null && property != BlockProperties.bm) {
            if ((state = LitematicaEasyPlaceProtocol.applyDirectionProperty(state, context, property, protocolValue)) == null) {
                return null;
            }
            protocolValue >>>= 3;
        }
        protocolValue >>>= 1;
        ArrayList propList = new ArrayList(state.b().l().d());
        propList.sort(Comparator.comparing(IBlockState::f));
        try {
            for (IBlockState iBlockState : propList) {
                if (iBlockState instanceof BlockStateDirection || !WHITELISTED_PROPERTIES.contains((Object)iBlockState)) continue;
                IBlockState prop = iBlockState;
                ArrayList list = new ArrayList(prop.a());
                list.sort(Comparable::compareTo);
                int requiredBits = MathUtils.floorLog2(MathUtils.smallestEncompassingPowerOfTwo(list.size()));
                int bitMask = ~(-1 << requiredBits);
                int valueIndex = protocolValue & bitMask;
                if (valueIndex < 0 || valueIndex >= list.size()) continue;
                Comparable value = (Comparable)list.get(valueIndex);
                if (!state.c(prop).equals(value) && value != BlockPropertySlabType.c) {
                    state = (IBlockData)state.a(prop, value);
                }
                protocolValue >>>= requiredBits;
            }
        }
        catch (Exception e2) {
            LeavesLogger.LOGGER.warning("Exception trying to apply placement protocol value");
        }
        return state;
    }

    private static IBlockData applyDirectionProperty(IBlockData state, UseContext context, BlockStateDirection property, int protocolValue) {
        EnumDirection facingOrig;
        EnumDirection facing = facingOrig = state.c(property);
        int decodedFacingIndex = (protocolValue & 0xF) >> 1;
        if (decodedFacingIndex == 6) {
            facing = facing.g();
        } else if (decodedFacingIndex >= 0 && decodedFacingIndex <= 5) {
            facing = EnumDirection.a(decodedFacingIndex);
            if (!property.a().contains(facing)) {
                facing = context.getEntity().cD().g();
            }
        }
        if (facing != facingOrig && property.a().contains(facing)) {
            if (state.b() instanceof BlockBed) {
                BlockPosition headPos = context.pos.a(facing);
                BlockActionContext ctx = context.getItemPlacementContext();
                if (ctx == null || !context.getWorld().a_(headPos).a(ctx)) {
                    return null;
                }
            }
            state = (IBlockData)state.a(property, facing);
        }
        return state;
    }

    private static BlockStateDirection getFirstDirectionProperty(IBlockData state) {
        for (IBlockState<?> prop : state.B()) {
            if (!(prop instanceof BlockStateDirection)) continue;
            return (BlockStateDirection)prop;
        }
        return null;
    }

    public static class UseContext {
        private final World world;
        private final BlockPosition pos;
        private final EnumDirection side;
        private final Vec3D hitVec;
        private final EntityLiving entity;
        private final EnumHand hand;
        @Nullable
        private final BlockActionContext itemPlacementContext;

        private UseContext(World world, BlockPosition pos, EnumDirection side, Vec3D hitVec, EntityLiving entity, EnumHand hand, @Nullable BlockActionContext itemPlacementContext) {
            this.world = world;
            this.pos = pos;
            this.side = side;
            this.hitVec = hitVec;
            this.entity = entity;
            this.hand = hand;
            this.itemPlacementContext = itemPlacementContext;
        }

        public static UseContext from(BlockActionContext ctx, EnumHand hand) {
            Vec3D pos = ctx.l();
            return new UseContext(ctx.q(), ctx.a(), ctx.k(), new Vec3D(pos.c, pos.d, pos.e), ctx.o(), hand, ctx);
        }

        public World getWorld() {
            return this.world;
        }

        public BlockPosition getPos() {
            return this.pos;
        }

        public EnumDirection getSide() {
            return this.side;
        }

        public Vec3D getHitVec() {
            return this.hitVec;
        }

        public EntityLiving getEntity() {
            return this.entity;
        }

        public EnumHand getHand() {
            return this.hand;
        }

        @Nullable
        public BlockActionContext getItemPlacementContext() {
            return this.itemPlacementContext;
        }
    }
}

