/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.protocol;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyChestType;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.LeavesLogger;
import top.leavesmc.leaves.bot.ServerBot;
import top.leavesmc.leaves.protocol.core.LeavesProtocol;
import top.leavesmc.leaves.protocol.core.LeavesProtocolManager;
import top.leavesmc.leaves.protocol.core.ProtocolHandler;
import top.leavesmc.leaves.protocol.core.ProtocolUtils;

@LeavesProtocol(namespace="pca")
public class PcaSyncProtocol {
    public static final String PROTOCOL_ID = "pca";
    public static final ReentrantLock lock = new ReentrantLock(true);
    public static final ReentrantLock pairLock = new ReentrantLock(true);
    private static final MinecraftKey ENABLE_PCA_SYNC_PROTOCOL = PcaSyncProtocol.id("enable_pca_sync_protocol");
    private static final MinecraftKey DISABLE_PCA_SYNC_PROTOCOL = PcaSyncProtocol.id("disable_pca_sync_protocol");
    private static final MinecraftKey UPDATE_ENTITY = PcaSyncProtocol.id("update_entity");
    private static final MinecraftKey UPDATE_BLOCK_ENTITY = PcaSyncProtocol.id("update_block_entity");
    private static final Map<EntityPlayer, Pair<MinecraftKey, BlockPosition>> playerWatchBlockPos = new HashMap<EntityPlayer, Pair<MinecraftKey, BlockPosition>>();
    private static final Map<EntityPlayer, Pair<MinecraftKey, Entity>> playerWatchEntity = new HashMap<EntityPlayer, Pair<MinecraftKey, Entity>>();
    private static final Map<Pair<MinecraftKey, BlockPosition>, Set<EntityPlayer>> blockPosWatchPlayerSet = new HashMap<Pair<MinecraftKey, BlockPosition>, Set<EntityPlayer>>();
    private static final Map<Pair<MinecraftKey, Entity>, Set<EntityPlayer>> entityWatchPlayerSet = new HashMap<Pair<MinecraftKey, Entity>, Set<EntityPlayer>>();
    private static final MutablePair<MinecraftKey, Entity> ResourceLocationEntityPair = new MutablePair();
    private static final MutablePair<MinecraftKey, BlockPosition> ResourceLocationBlockPosPair = new MutablePair();

    @Contract(value="_ -> new")
    @NotNull
    public static MinecraftKey id(String path) {
        return new MinecraftKey(PROTOCOL_ID, path);
    }

    @ProtocolHandler.PlayerJoin
    private static void onJoin(EntityPlayer player) {
        if (LeavesConfig.pcaSyncProtocol) {
            PcaSyncProtocol.enablePcaSyncProtocol(player);
        }
    }

    @ProtocolHandler.ReloadServer
    private static void onServerReload() {
        if (LeavesConfig.pcaSyncProtocol) {
            PcaSyncProtocol.enablePcaSyncProtocolGlobal();
        } else {
            PcaSyncProtocol.disablePcaSyncProtocolGlobal();
        }
    }

    @ProtocolHandler.PayloadReceiver(payload=LeavesProtocolManager.EmptyPayload.class, payloadId="cancel_sync_block_entity")
    private static void cancelSyncBlockEntityHandler(EntityPlayer player, LeavesProtocolManager.EmptyPayload payload) {
        if (!LeavesConfig.pcaSyncProtocol) {
            return;
        }
        PcaSyncProtocol.clearPlayerWatchBlock(player);
    }

    @ProtocolHandler.PayloadReceiver(payload=LeavesProtocolManager.EmptyPayload.class, payloadId="cancel_sync_entity")
    private static void cancelSyncEntityHandler(EntityPlayer player, LeavesProtocolManager.EmptyPayload payload) {
        if (!LeavesConfig.pcaSyncProtocol) {
            return;
        }
        PcaSyncProtocol.clearPlayerWatchEntity(player);
    }

    @ProtocolHandler.PayloadReceiver(payload=SyncBlockEntityPayload.class, payloadId="sync_block_entity")
    private static void syncBlockEntityHandler(EntityPlayer player, SyncBlockEntityPayload payload) {
        if (!LeavesConfig.pcaSyncProtocol) {
            return;
        }
        MinecraftServer server = MinecraftServer.getServer();
        BlockPosition pos = payload.pos;
        WorldServer world = player.x();
        server.execute(() -> {
            TileEntity blockEntity;
            IBlockData blockState = world.a_(pos);
            PcaSyncProtocol.clearPlayerWatchData(player);
            TileEntity blockEntityAdj = null;
            if (blockState.b() instanceof BlockChest && blockState.c(BlockChest.c) != BlockPropertyChestType.a) {
                BlockPosition posAdj = pos.a(BlockChest.h(blockState).q());
                blockEntityAdj = world.x(posAdj).c_(posAdj);
            }
            if (blockEntityAdj != null) {
                PcaSyncProtocol.updateBlockEntity(player, blockEntityAdj);
            }
            if ((blockEntity = world.x(pos).c_(pos)) != null) {
                PcaSyncProtocol.updateBlockEntity(player, blockEntity);
            }
            ImmutablePair pair = new ImmutablePair((Object)player.dL().ac().a(), (Object)pos);
            lock.lock();
            playerWatchBlockPos.put(player, (Pair<MinecraftKey, BlockPosition>)pair);
            if (!blockPosWatchPlayerSet.containsKey(pair)) {
                blockPosWatchPlayerSet.put((Pair<MinecraftKey, BlockPosition>)pair, new HashSet());
            }
            blockPosWatchPlayerSet.get(pair).add(player);
            lock.unlock();
        });
    }

    @ProtocolHandler.PayloadReceiver(payload=SyncEntityPayload.class, payloadId="sync_entity")
    private static void syncEntityHandler(EntityPlayer player, SyncEntityPayload payload) {
        if (!LeavesConfig.pcaSyncProtocol) {
            return;
        }
        MinecraftServer server = MinecraftServer.getServer();
        int entityId = payload.entityId;
        WorldServer world = player.x();
        server.execute(() -> {
            Entity entity = world.a(entityId);
            if (entity != null) {
                PcaSyncProtocol.clearPlayerWatchData(player);
                if (entity instanceof EntityHuman) {
                    if (LeavesConfig.pcaSyncPlayerEntity.equals("NOBODY")) {
                        return;
                    }
                    if (LeavesConfig.pcaSyncPlayerEntity.equals("BOT")) {
                        if (!(entity instanceof ServerBot)) {
                            return;
                        }
                    } else if (LeavesConfig.pcaSyncPlayerEntity.equals("OPS")) {
                        if (!(entity instanceof ServerBot) && server.c(player.fQ()) < 2) {
                            return;
                        }
                    } else if (LeavesConfig.pcaSyncPlayerEntity.equals("OPS_AND_SELF")) {
                        if (!(entity instanceof ServerBot) && server.c(player.fQ()) < 2 && entity != player) {
                            return;
                        }
                    } else if (!LeavesConfig.pcaSyncPlayerEntity.equals("EVERYONE")) {
                        LeavesLogger.LOGGER.warning("pcaSyncPlayerEntity wtf???");
                        return;
                    }
                }
                PcaSyncProtocol.updateEntity(player, entity);
                ImmutablePair pair = new ImmutablePair((Object)entity.dL().ac().a(), (Object)entity);
                lock.lock();
                playerWatchEntity.put(player, (Pair<MinecraftKey, Entity>)pair);
                if (!entityWatchPlayerSet.containsKey(pair)) {
                    entityWatchPlayerSet.put((Pair<MinecraftKey, Entity>)pair, new HashSet());
                }
                entityWatchPlayerSet.get(pair).add(player);
                lock.unlock();
            }
        });
    }

    public static void enablePcaSyncProtocol(@NotNull EntityPlayer player) {
        ProtocolUtils.sendEmptyPayloadPacket(player, ENABLE_PCA_SYNC_PROTOCOL);
    }

    public static void disablePcaSyncProtocol(@NotNull EntityPlayer player) {
        ProtocolUtils.sendEmptyPayloadPacket(player, DISABLE_PCA_SYNC_PROTOCOL);
    }

    public static void updateEntity(@NotNull EntityPlayer player, @NotNull Entity entity) {
        NBTTagCompound nbt = entity.f(new NBTTagCompound());
        ProtocolUtils.sendPayloadPacket(player, UPDATE_ENTITY, buf -> {
            buf.a(entity.dL().ac().a());
            buf.p(entity.ah());
            buf.a(nbt);
        });
    }

    public static void updateBlockEntity(@NotNull EntityPlayer player, @NotNull TileEntity blockEntity) {
        World world = blockEntity.k();
        if (world == null) {
            return;
        }
        ProtocolUtils.sendPayloadPacket(player, UPDATE_BLOCK_ENTITY, buf -> {
            buf.a(world.ac().a());
            buf.a(blockEntity.p());
            buf.a(blockEntity.n());
        });
    }

    private static MutablePair<MinecraftKey, Entity> getResourceLocationEntityPair(MinecraftKey ResourceLocation, Entity entity) {
        pairLock.lock();
        ResourceLocationEntityPair.setLeft((Object)ResourceLocation);
        ResourceLocationEntityPair.setRight((Object)entity);
        pairLock.unlock();
        return ResourceLocationEntityPair;
    }

    private static MutablePair<MinecraftKey, BlockPosition> getResourceLocationBlockPosPair(MinecraftKey ResourceLocation, BlockPosition pos) {
        pairLock.lock();
        ResourceLocationBlockPosPair.setLeft((Object)ResourceLocation);
        ResourceLocationBlockPosPair.setRight((Object)pos);
        pairLock.unlock();
        return ResourceLocationBlockPosPair;
    }

    @Nullable
    private static Set<EntityPlayer> getWatchPlayerList(@NotNull Entity entity) {
        return entityWatchPlayerSet.get(PcaSyncProtocol.getResourceLocationEntityPair(entity.dL().ac().a(), entity));
    }

    @Nullable
    private static Set<EntityPlayer> getWatchPlayerList(@NotNull World world, @NotNull BlockPosition blockPos) {
        return blockPosWatchPlayerSet.get(PcaSyncProtocol.getResourceLocationBlockPosPair(world.ac().a(), blockPos));
    }

    public static boolean syncEntityToClient(@NotNull Entity entity) {
        if (entity.dL().w_()) {
            return false;
        }
        lock.lock();
        Set<EntityPlayer> playerList = PcaSyncProtocol.getWatchPlayerList(entity);
        boolean ret = false;
        if (playerList != null) {
            for (EntityPlayer player : playerList) {
                PcaSyncProtocol.updateEntity(player, entity);
                ret = true;
            }
        }
        lock.unlock();
        return ret;
    }

    public static boolean syncBlockEntityToClient(@NotNull TileEntity blockEntity) {
        boolean ret = false;
        World world = blockEntity.k();
        BlockPosition pos = blockEntity.p();
        if (world != null) {
            if (world.w_()) {
                return false;
            }
            IBlockData blockState = world.a_(pos);
            lock.lock();
            Set<EntityPlayer> playerList = PcaSyncProtocol.getWatchPlayerList(world, blockEntity.p());
            Set<EntityPlayer> playerListAdj = null;
            if (blockState.b() instanceof BlockChest && blockState.c(BlockChest.c) != BlockPropertyChestType.a) {
                BlockPosition posAdj = pos.a(BlockChest.h(blockState).q());
                playerListAdj = PcaSyncProtocol.getWatchPlayerList(world, posAdj);
            }
            if (playerListAdj != null) {
                if (playerList == null) {
                    playerList = playerListAdj;
                } else {
                    playerList.addAll(playerListAdj);
                }
            }
            if (playerList != null) {
                for (EntityPlayer player : playerList) {
                    PcaSyncProtocol.updateBlockEntity(player, blockEntity);
                    ret = true;
                }
            }
            lock.unlock();
        }
        return ret;
    }

    private static void clearPlayerWatchEntity(EntityPlayer player) {
        lock.lock();
        Pair<MinecraftKey, Entity> pair = playerWatchEntity.get(player);
        if (pair != null) {
            Set<EntityPlayer> playerSet = entityWatchPlayerSet.get(pair);
            playerSet.remove(player);
            if (playerSet.isEmpty()) {
                entityWatchPlayerSet.remove(pair);
            }
            playerWatchEntity.remove(player);
        }
        lock.unlock();
    }

    private static void clearPlayerWatchBlock(EntityPlayer player) {
        lock.lock();
        Pair<MinecraftKey, BlockPosition> pair = playerWatchBlockPos.get(player);
        if (pair != null) {
            Set<EntityPlayer> playerSet = blockPosWatchPlayerSet.get(pair);
            playerSet.remove(player);
            if (playerSet.isEmpty()) {
                blockPosWatchPlayerSet.remove(pair);
            }
            playerWatchBlockPos.remove(player);
        }
        lock.unlock();
    }

    public static void disablePcaSyncProtocolGlobal() {
        lock.lock();
        playerWatchBlockPos.clear();
        playerWatchEntity.clear();
        blockPosWatchPlayerSet.clear();
        entityWatchPlayerSet.clear();
        lock.unlock();
        for (EntityPlayer player : MinecraftServer.getServer().ac().t()) {
            PcaSyncProtocol.disablePcaSyncProtocol(player);
        }
    }

    public static void enablePcaSyncProtocolGlobal() {
        for (EntityPlayer player : MinecraftServer.getServer().ac().t()) {
            PcaSyncProtocol.enablePcaSyncProtocol(player);
        }
    }

    public static void clearPlayerWatchData(EntityPlayer player) {
        PcaSyncProtocol.clearPlayerWatchBlock(player);
        PcaSyncProtocol.clearPlayerWatchEntity(player);
    }

    public record SyncBlockEntityPayload(BlockPosition pos) implements CustomPacketPayload
    {
        public static final MinecraftKey SYNC_BLOCK_ENTITY = PcaSyncProtocol.id("sync_block_entity");

        public SyncBlockEntityPayload(MinecraftKey id, PacketDataSerializer buf) {
            this(buf.e());
        }

        @Override
        public void a(PacketDataSerializer buf) {
            buf.a(this.pos);
        }

        @Override
        @NotNull
        public MinecraftKey a() {
            return SYNC_BLOCK_ENTITY;
        }
    }

    public record SyncEntityPayload(int entityId) implements CustomPacketPayload
    {
        public static final MinecraftKey SYNC_ENTITY = PcaSyncProtocol.id("sync_entity");

        public SyncEntityPayload(MinecraftKey id, PacketDataSerializer buf) {
            this(buf.readInt());
        }

        @Override
        public void a(PacketDataSerializer buf) {
            buf.p(this.entityId);
        }

        @Override
        @NotNull
        public MinecraftKey a() {
            return SYNC_ENTITY;
        }
    }
}

