/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.protocol.bladeren;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.protocol.core.LeavesProtocol;
import top.leavesmc.leaves.protocol.core.ProtocolHandler;
import top.leavesmc.leaves.protocol.core.ProtocolUtils;

@LeavesProtocol(namespace="bladeren")
public class BladerenProtocol {
    public static final String PROTOCOL_ID = "bladeren";
    public static final String PROTOCOL_VERSION = "1.0.0";
    private static final MinecraftKey HELLO_ID = BladerenProtocol.id("hello");
    private static final MinecraftKey FEATURE_MODIFY_ID = BladerenProtocol.id("feature_modify");
    private static final Map<String, BiConsumer<EntityPlayer, NBTTagCompound>> registeredFeatures = new HashMap<String, BiConsumer<EntityPlayer, NBTTagCompound>>();

    @Contract(value="_ -> new")
    @NotNull
    public static MinecraftKey id(String path) {
        return new MinecraftKey(PROTOCOL_ID, path);
    }

    @ProtocolHandler.PayloadReceiver(payload=BladerenHelloPayload.class, payloadId="hello")
    private static void handleHello(@NotNull EntityPlayer player, @NotNull BladerenHelloPayload payload) {
        if (LeavesConfig.bladerenLeavesProtocol) {
            String clientVersion = payload.version;
            NBTTagCompound tag = payload.nbt;
            if (tag != null) {
                NBTTagCompound featureNbt = tag.p("Features");
                for (String name : featureNbt.e()) {
                    if (!registeredFeatures.containsKey(name)) continue;
                    registeredFeatures.get(name).accept(player, featureNbt.p(name));
                }
            }
        }
    }

    @ProtocolHandler.PayloadReceiver(payload=BladerenFeatureModifyPayload.class, payloadId="feature_modify")
    private static void handleModify(@NotNull EntityPlayer player, @NotNull BladerenFeatureModifyPayload payload) {
        if (LeavesConfig.bladerenLeavesProtocol) {
            String name = payload.name;
            NBTTagCompound tag = payload.nbt;
            if (registeredFeatures.containsKey(name)) {
                registeredFeatures.get(name).accept(player, tag);
            }
        }
    }

    @ProtocolHandler.PlayerJoin
    public static void onPlayerJoin(@NotNull EntityPlayer player) {
        if (LeavesConfig.bladerenLeavesProtocol) {
            NBTTagCompound tag = new NBTTagCompound();
            LeavesFeatureSet.writeNBT(tag);
            ProtocolUtils.sendPayloadPacket(player, new BladerenHelloPayload(PROTOCOL_VERSION, tag));
        }
    }

    public static void registerFeature(String name, BiConsumer<EntityPlayer, NBTTagCompound> consumer) {
        registeredFeatures.put(name, consumer);
    }

    public record BladerenHelloPayload(String version, NBTTagCompound nbt) implements CustomPacketPayload
    {
        public BladerenHelloPayload(MinecraftKey location, @NotNull PacketDataSerializer buf) {
            this(buf.d(64), buf.p());
        }

        @Override
        public void a(@NotNull PacketDataSerializer buf) {
            buf.a(this.version);
            buf.a(this.nbt);
        }

        @Override
        @NotNull
        public MinecraftKey a() {
            return HELLO_ID;
        }
    }

    public record BladerenFeatureModifyPayload(String name, NBTTagCompound nbt) implements CustomPacketPayload
    {
        public BladerenFeatureModifyPayload(MinecraftKey location, PacketDataSerializer buf) {
            this(buf.r(), buf.p());
        }

        @Override
        public void a(@NotNull PacketDataSerializer buf) {
            buf.a(this.name);
            buf.a(this.nbt);
        }

        @Override
        @NotNull
        public MinecraftKey a() {
            return FEATURE_MODIFY_ID;
        }
    }

    public static class LeavesFeatureSet {
        private static final Map<String, LeavesFeature> features = new HashMap<String, LeavesFeature>();

        public static void writeNBT(@NotNull NBTTagCompound tag) {
            NBTTagCompound featureNbt = new NBTTagCompound();
            features.values().forEach(feature -> feature.writeNBT(featureNbt));
            tag.a("Features", featureNbt);
        }

        public static void register(LeavesFeature feature) {
            features.put(feature.name, feature);
        }
    }

    public record LeavesFeature(String name, String value) {
        @NotNull
        @Contract(value="_, _ -> new")
        public static LeavesFeature of(String name, boolean value) {
            return new LeavesFeature(name, Boolean.toString(value));
        }

        public void writeNBT(@NotNull NBTTagCompound rules) {
            NBTTagCompound rule = new NBTTagCompound();
            rule.a("Feature", this.name);
            rule.a("Value", this.value);
            rules.a(this.name, rule);
        }
    }
}

