/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.protocol.bladeren;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.protocol.bladeren.BladerenProtocol;
import top.leavesmc.leaves.protocol.core.LeavesProtocol;
import top.leavesmc.leaves.protocol.core.ProtocolHandler;
import top.leavesmc.leaves.protocol.core.ProtocolUtils;

@LeavesProtocol(namespace="bladeren")
public class MsptSyncProtocol {
    public static final String PROTOCOL_ID = "bladeren";
    private static final MinecraftKey MSPT_SYNC = MsptSyncProtocol.id("mspt_sync");
    private static final List<EntityPlayer> players = new ArrayList<EntityPlayer>();

    @Contract(value="_ -> new")
    @NotNull
    public static MinecraftKey id(String path) {
        return new MinecraftKey(PROTOCOL_ID, path);
    }

    @ProtocolHandler.Init
    public static void init() {
        BladerenProtocol.registerFeature("mspt_sync", (player, compoundTag) -> {
            if (compoundTag.l("Value").equals("true")) {
                MsptSyncProtocol.onPlayerSubmit(player);
            } else {
                MsptSyncProtocol.onPlayerLoggedOut(player);
            }
        });
    }

    @ProtocolHandler.PlayerLeave
    public static void onPlayerLoggedOut(@NotNull EntityPlayer player) {
        if (LeavesConfig.msptSyncProtocol) {
            players.remove(player);
        }
    }

    @ProtocolHandler.Ticker
    public static void tick() {
        if (LeavesConfig.msptSyncProtocol) {
            if (players.isEmpty()) {
                return;
            }
            MinecraftServer server = MinecraftServer.getServer();
            if (server.ag() % LeavesConfig.msptSyncTickInterval == 0) {
                double mspt = Arrays.stream(server.k).average().getAsDouble() * 1.0E-6;
                double tps = 1000.0 / Math.max(mspt, 50.0);
                players.forEach(player -> ProtocolUtils.sendPayloadPacket(player, MSPT_SYNC, buf -> {
                    buf.a(mspt);
                    buf.a(tps);
                }));
            }
        }
    }

    public static void onPlayerSubmit(@NotNull EntityPlayer player) {
        if (LeavesConfig.msptSyncProtocol) {
            players.add(player);
        }
    }
}

