/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.protocol.syncmatica;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.UUID;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.leavesmc.leaves.protocol.syncmatica.PlayerIdentifier;
import top.leavesmc.leaves.protocol.syncmatica.ServerPosition;
import top.leavesmc.leaves.protocol.syncmatica.SubRegionData;
import top.leavesmc.leaves.protocol.syncmatica.SyncmaticaProtocol;

public class ServerPlacement {
    private final UUID id;
    private final String fileName;
    private final UUID hashValue;
    private PlayerIdentifier owner;
    private PlayerIdentifier lastModifiedBy;
    private ServerPosition origin;
    private EnumBlockRotation rotation;
    private EnumBlockMirror mirror;
    private SubRegionData subRegionData = new SubRegionData();

    public ServerPlacement(UUID id, String fileName, UUID hashValue, PlayerIdentifier owner) {
        this.id = id;
        this.fileName = fileName;
        this.hashValue = hashValue;
        this.owner = owner;
        this.lastModifiedBy = owner;
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.fileName;
    }

    public UUID getHash() {
        return this.hashValue;
    }

    public String getDimension() {
        return this.origin.getDimensionId();
    }

    public BlockPosition getPosition() {
        return this.origin.getBlockPosition();
    }

    public ServerPosition getOrigin() {
        return this.origin;
    }

    public EnumBlockRotation getRotation() {
        return this.rotation;
    }

    public EnumBlockMirror getMirror() {
        return this.mirror;
    }

    public ServerPlacement move(String dimensionId, BlockPosition origin, EnumBlockRotation rotation, EnumBlockMirror mirror) {
        this.move(new ServerPosition(origin, dimensionId), rotation, mirror);
        return this;
    }

    public ServerPlacement move(ServerPosition origin, EnumBlockRotation rotation, EnumBlockMirror mirror) {
        this.origin = origin;
        this.rotation = rotation;
        this.mirror = mirror;
        return this;
    }

    public PlayerIdentifier getOwner() {
        return this.owner;
    }

    public void setOwner(PlayerIdentifier playerIdentifier) {
        this.owner = playerIdentifier;
    }

    public PlayerIdentifier getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(PlayerIdentifier lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public SubRegionData getSubRegionData() {
        return this.subRegionData;
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.add("id", (JsonElement)new JsonPrimitive(this.id.toString()));
        obj.add("file_name", (JsonElement)new JsonPrimitive(this.fileName));
        obj.add("hash", (JsonElement)new JsonPrimitive(this.hashValue.toString()));
        obj.add("origin", (JsonElement)this.origin.toJson());
        obj.add("rotation", (JsonElement)new JsonPrimitive(this.rotation.name()));
        obj.add("mirror", (JsonElement)new JsonPrimitive(this.mirror.name()));
        obj.add("owner", (JsonElement)this.owner.toJson());
        if (!this.owner.equals(this.lastModifiedBy)) {
            obj.add("lastModifiedBy", (JsonElement)this.lastModifiedBy.toJson());
        }
        if (this.subRegionData.isModified()) {
            obj.add("subregionData", this.subRegionData.toJson());
        }
        return obj;
    }

    @Nullable
    public static ServerPlacement fromJson(@NotNull JsonObject obj) {
        if (obj.has("id") && obj.has("file_name") && obj.has("hash") && obj.has("origin") && obj.has("rotation") && obj.has("mirror")) {
            UUID id = UUID.fromString(obj.get("id").getAsString());
            String name = obj.get("file_name").getAsString();
            UUID hashValue = UUID.fromString(obj.get("hash").getAsString());
            PlayerIdentifier owner = PlayerIdentifier.MISSING_PLAYER;
            if (obj.has("owner")) {
                owner = SyncmaticaProtocol.getPlayerIdentifierProvider().fromJson(obj.get("owner").getAsJsonObject());
            }
            ServerPlacement newPlacement = new ServerPlacement(id, name, hashValue, owner);
            ServerPosition pos = ServerPosition.fromJson(obj.get("origin").getAsJsonObject());
            if (pos == null) {
                return null;
            }
            newPlacement.origin = pos;
            newPlacement.rotation = EnumBlockRotation.valueOf(obj.get("rotation").getAsString());
            newPlacement.mirror = EnumBlockMirror.valueOf(obj.get("mirror").getAsString());
            newPlacement.lastModifiedBy = obj.has("lastModifiedBy") ? SyncmaticaProtocol.getPlayerIdentifierProvider().fromJson(obj.get("lastModifiedBy").getAsJsonObject()) : owner;
            if (obj.has("subregionData")) {
                newPlacement.subRegionData = SubRegionData.fromJson(obj.get("subregionData"));
            }
            return newPlacement;
        }
        return null;
    }
}

