/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.protocol.syncmatica;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubRegionPlacementModification {
    public final String name;
    public final BlockPosition position;
    public final EnumBlockRotation rotation;
    public final EnumBlockMirror mirror;

    SubRegionPlacementModification(String name, BlockPosition position, EnumBlockRotation rotation, EnumBlockMirror mirror) {
        this.name = name;
        this.position = position;
        this.rotation = rotation;
        this.mirror = mirror;
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        JsonArray arr = new JsonArray();
        arr.add((Number)this.position.u());
        arr.add((Number)this.position.v());
        arr.add((Number)this.position.w());
        obj.add("position", (JsonElement)arr);
        obj.add("name", (JsonElement)new JsonPrimitive(this.name));
        obj.add("rotation", (JsonElement)new JsonPrimitive(this.rotation.name()));
        obj.add("mirror", (JsonElement)new JsonPrimitive(this.mirror.name()));
        return obj;
    }

    @Nullable
    public static SubRegionPlacementModification fromJson(@NotNull JsonObject obj) {
        if (!(obj.has("name") && obj.has("position") && obj.has("rotation") && obj.has("mirror"))) {
            return null;
        }
        String name = obj.get("name").getAsString();
        JsonArray arr = obj.get("position").getAsJsonArray();
        if (arr.size() != 3) {
            return null;
        }
        BlockPosition position = new BlockPosition(arr.get(0).getAsInt(), arr.get(1).getAsInt(), arr.get(2).getAsInt());
        EnumBlockRotation rotation = EnumBlockRotation.valueOf(obj.get("rotation").getAsString());
        EnumBlockMirror mirror = EnumBlockMirror.valueOf(obj.get("mirror").getAsString());
        return new SubRegionPlacementModification(name, position, rotation, mirror);
    }

    public String toString() {
        return String.format("[name=%s, position=%s, rotation=%s, mirror=%s]", this.name, this.position, this.rotation, this.mirror);
    }
}

