/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.protocol.syncmatica.exchange;

import io.netty.buffer.Unpooled;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import org.jetbrains.annotations.NotNull;
import top.leavesmc.leaves.protocol.syncmatica.FeatureSet;
import top.leavesmc.leaves.protocol.syncmatica.PacketType;
import top.leavesmc.leaves.protocol.syncmatica.SyncmaticaProtocol;
import top.leavesmc.leaves.protocol.syncmatica.exchange.AbstractExchange;
import top.leavesmc.leaves.protocol.syncmatica.exchange.ExchangeTarget;

public abstract class FeatureExchange
extends AbstractExchange {
    protected FeatureExchange(ExchangeTarget partner) {
        super(partner);
    }

    @Override
    public boolean checkPacket(@NotNull MinecraftKey id, PacketDataSerializer packetBuf) {
        return id.equals(PacketType.FEATURE_REQUEST.identifier) || id.equals(PacketType.FEATURE.identifier);
    }

    @Override
    public void handle(@NotNull MinecraftKey id, PacketDataSerializer packetBuf) {
        if (id.equals(PacketType.FEATURE_REQUEST.identifier)) {
            this.sendFeatures();
        } else if (id.equals(PacketType.FEATURE.identifier)) {
            FeatureSet fs = FeatureSet.fromString(packetBuf.d(Short.MAX_VALUE));
            this.getPartner().setFeatureSet(fs);
            this.onFeatureSetReceive();
        }
    }

    protected void onFeatureSetReceive() {
        this.succeed();
    }

    public void requestFeatureSet() {
        this.getPartner().sendPacket(PacketType.FEATURE_REQUEST.identifier, new PacketDataSerializer(Unpooled.buffer()));
    }

    private void sendFeatures() {
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
        FeatureSet fs = SyncmaticaProtocol.getFeatureSet();
        buf.a(fs.toString(), Short.MAX_VALUE);
        this.getPartner().sendPacket(PacketType.FEATURE.identifier, buf);
    }
}

