/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.protocol.syncmatica.exchange;

import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import org.jetbrains.annotations.NotNull;
import top.leavesmc.leaves.protocol.syncmatica.CommunicationManager;
import top.leavesmc.leaves.protocol.syncmatica.PacketType;
import top.leavesmc.leaves.protocol.syncmatica.PlayerIdentifier;
import top.leavesmc.leaves.protocol.syncmatica.ServerPlacement;
import top.leavesmc.leaves.protocol.syncmatica.SyncmaticaProtocol;
import top.leavesmc.leaves.protocol.syncmatica.exchange.AbstractExchange;
import top.leavesmc.leaves.protocol.syncmatica.exchange.ExchangeTarget;

public class ModifyExchangeServer
extends AbstractExchange {
    private final ServerPlacement placement;
    UUID placementId;

    public ModifyExchangeServer(UUID placeId, ExchangeTarget partner) {
        super(partner);
        this.placementId = placeId;
        this.placement = SyncmaticaProtocol.getSyncmaticManager().getPlacement(this.placementId);
    }

    @Override
    public boolean checkPacket(@NotNull MinecraftKey id, PacketDataSerializer packetBuf) {
        return id.equals(PacketType.MODIFY_FINISH.identifier) && ModifyExchangeServer.checkUUID(packetBuf, this.placement.getId());
    }

    @Override
    public void handle(@NotNull MinecraftKey id, @NotNull PacketDataSerializer packetBuf) {
        packetBuf.o();
        if (id.equals(PacketType.MODIFY_FINISH.identifier)) {
            SyncmaticaProtocol.getCommunicationManager();
            CommunicationManager.receivePositionData(this.placement, packetBuf, this.getPartner());
            PlayerIdentifier identifier = SyncmaticaProtocol.getPlayerIdentifierProvider().createOrGet(this.getPartner());
            this.placement.setLastModifiedBy(identifier);
            SyncmaticaProtocol.getSyncmaticManager().updateServerPlacement();
            this.succeed();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void init() {
        block5: {
            block4: {
                if (this.getPlacement() == null) break block4;
                SyncmaticaProtocol.getCommunicationManager();
                if (CommunicationManager.getModifier(this.placement) == null) break block5;
            }
            this.close(true);
            return;
        }
        if (SyncmaticaProtocol.getPlayerIdentifierProvider().createOrGet((ExchangeTarget)this.getPartner()).uuid.equals(this.placement.getOwner().uuid)) {
            this.accept();
            return;
        }
        this.close(true);
    }

    private void accept() {
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
        buf.a(this.placement.getId());
        this.getPartner().sendPacket(PacketType.MODIFY_REQUEST_ACCEPT.identifier, buf);
        SyncmaticaProtocol.getCommunicationManager();
        CommunicationManager.setModifier(this.placement, this);
    }

    @Override
    protected void sendCancelPacket() {
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
        buf.a(this.placementId);
        this.getPartner().sendPacket(PacketType.MODIFY_REQUEST_DENY.identifier, buf);
    }

    public ServerPlacement getPlacement() {
        return this.placement;
    }

    @Override
    protected void onClose() {
        SyncmaticaProtocol.getCommunicationManager();
        if (CommunicationManager.getModifier(this.placement) == this) {
            SyncmaticaProtocol.getCommunicationManager();
            CommunicationManager.setModifier(this.placement, null);
        }
    }
}

