/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.replay;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Checksum;
import org.jetbrains.annotations.NotNull;

public class DigestOutputStream
extends OutputStream {
    private final Checksum sum;
    private final OutputStream out;

    public DigestOutputStream(OutputStream out, Checksum sum) {
        this.out = out;
        this.sum = sum;
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void write(int b2) throws IOException {
        this.sum.update(b2);
        this.out.write(b2);
    }

    @Override
    public void write(byte @NotNull [] b2) throws IOException {
        this.sum.update(b2);
        this.out.write(b2);
    }

    @Override
    public void write(byte @NotNull [] b2, int off, int len) throws IOException {
        this.sum.update(b2, off, len);
        this.out.write(b2, off, len);
    }
}

