/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.replay;

import java.util.List;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import top.leavesmc.leaves.replay.BukkitRecorderOption;

public class RecorderOption {
    public int recordDistance = -1;
    public String serverName = "Leaves";
    public RecordWeather forceWeather = null;
    public int forceDayTime = -1;
    public boolean ignoreChat = false;
    public boolean ignoreItem = false;

    @NotNull
    @Contract(value=" -> new")
    public static RecorderOption createDefaultOption() {
        return new RecorderOption();
    }

    @NotNull
    public static RecorderOption createFromBukkit(@NotNull BukkitRecorderOption bukkitRecorderOption) {
        RecorderOption recorderOption = new RecorderOption();
        recorderOption.serverName = bukkitRecorderOption.serverName;
        recorderOption.ignoreChat = bukkitRecorderOption.ignoreChat;
        recorderOption.forceDayTime = bukkitRecorderOption.forceDayTime;
        recorderOption.forceWeather = switch (bukkitRecorderOption.forceWeather) {
            default -> throw new IncompatibleClassChangeError();
            case BukkitRecorderOption.BukkitRecordWeather.RAIN -> RecordWeather.RAIN;
            case BukkitRecorderOption.BukkitRecordWeather.CLEAR -> RecordWeather.CLEAR;
            case BukkitRecorderOption.BukkitRecordWeather.THUNDER -> RecordWeather.THUNDER;
            case BukkitRecorderOption.BukkitRecordWeather.NULL -> null;
        };
        return recorderOption;
    }

    public static enum RecordWeather {
        CLEAR(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.c, 0.0f), new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.h, 0.0f), new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.i, 0.0f)),
        RAIN(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.b, 0.0f), new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.h, 1.0f), new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.i, 0.0f)),
        THUNDER(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.b, 0.0f), new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.h, 1.0f), new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.i, 1.0f));

        private final List<Packet<?>> packets;

        private RecordWeather(Packet<?> ... packets) {
            this.packets = List.of(packets);
        }

        public List<Packet<?>> getPackets() {
            return this.packets;
        }
    }
}

