/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.util;

import com.google.common.collect.Queues;
import java.util.Queue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import top.leavesmc.leaves.LeavesLogger;

public class AsyncExecutor
implements Runnable {
    private final Queue<Runnable> jobs = Queues.newArrayDeque();
    private final Lock mutex = new ReentrantLock();
    private final Condition cond = this.mutex.newCondition();
    private final Thread thread;
    private volatile boolean killswitch = false;

    public AsyncExecutor(String threadName) {
        this.thread = new Thread((Runnable)this, threadName);
    }

    public void start() {
        this.thread.start();
    }

    public void kill() {
        this.killswitch = true;
        this.cond.signalAll();
    }

    public void submit(Runnable runnable) {
        this.mutex.lock();
        try {
            this.jobs.offer(runnable);
            this.cond.signalAll();
        }
        finally {
            this.mutex.unlock();
        }
    }

    @Override
    public void run() {
        while (!this.killswitch) {
            try {
                Runnable runnable = this.takeRunnable();
                if (runnable == null) continue;
                runnable.run();
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e3) {
                LeavesLogger.LOGGER.log(Level.SEVERE, e3, () -> "Failed to execute async job for thread " + this.thread.getName());
            }
        }
    }

    private Runnable takeRunnable() throws InterruptedException {
        this.mutex.lock();
        try {
            while (this.jobs.isEmpty() && !this.killswitch) {
                this.cond.await();
            }
            if (this.jobs.isEmpty()) {
                Runnable runnable = null;
                return runnable;
            }
            Runnable runnable = this.jobs.remove();
            return runnable;
        }
        finally {
            this.mutex.unlock();
        }
    }
}

