/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDirectional;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.jetbrains.annotations.NotNull;
import top.leavesmc.leaves.LeavesConfig;

public class BreakBedrockList {
    private static final Map<World, Map<BlockPosition, EntityHuman>> pistonCache = new HashMap<World, Map<BlockPosition, EntityHuman>>();
    private static final List<ScoreboardObjective> BBL = new ArrayList<ScoreboardObjective>();
    private static final List<ScoreboardObjective> MBB = new ArrayList<ScoreboardObjective>();
    private static final List<ScoreboardObjective> LBL = new ArrayList<ScoreboardObjective>();

    public static void endTick() {
        for (Map<BlockPosition, EntityHuman> map : pistonCache.values()) {
            if (map.isEmpty()) continue;
            map.clear();
        }
    }

    public static void onPlayerPlacePiston(World level, EntityHuman player, BlockPosition pos) {
        EnumDirection pistonFacing;
        BlockPosition bedrockPos;
        if (LeavesConfig.bedrockBreakList && level.a_(bedrockPos = pos.a(pistonFacing = level.a_(pos).c(BlockDirectional.a))).b() == Blocks.F) {
            pistonCache.computeIfAbsent(level, k2 -> new HashMap()).put(bedrockPos, player);
        }
    }

    public static void onPistonBreakBedrock(World level, BlockPosition bedrock) {
        if (LeavesConfig.bedrockBreakList) {
            EntityHuman closestPlayer;
            boolean flag;
            Map<BlockPosition, EntityHuman> map = pistonCache.get(level);
            boolean bl = flag = map != null && map.get(bedrock) != null;
            if (flag) {
                if (!BBL.isEmpty()) {
                    String player = map.get(bedrock).cx();
                    for (ScoreboardObjective objective : BBL) {
                        level.I().c(player, objective).a();
                    }
                }
            } else if (!MBB.isEmpty()) {
                String world = "$" + level.ac().a();
                for (ScoreboardObjective objective : MBB) {
                    level.I().c(world, objective).a();
                    level.I().c("$total", objective).a();
                }
            }
            if (!LBL.isEmpty() && !level.v().isEmpty() && (closestPlayer = level.a((double)bedrock.u(), (double)bedrock.v(), (double)bedrock.w(), 10.5, null)) != null) {
                String player = closestPlayer.cx();
                for (ScoreboardObjective objective : LBL) {
                    level.I().c(player, objective).a();
                }
            }
        }
    }

    public static void onScoreboardAdd(@NotNull ScoreboardObjective objective) {
        String name;
        int i2;
        if (LeavesConfig.bedrockBreakList && objective.c() == IScoreboardCriteria.a && (i2 = (name = objective.b()).length() - 4) >= 0) {
            String suffix;
            switch (suffix = name.substring(i2)) {
                case ".bbl": {
                    BBL.add(objective);
                    break;
                }
                case ".mbb": {
                    MBB.add(objective);
                    break;
                }
                case ".lbl": {
                    LBL.add(objective);
                }
            }
        }
    }

    public static void onScoreboardRemove(@NotNull ScoreboardObjective objective) {
        String name;
        int i2;
        if (LeavesConfig.bedrockBreakList && objective.c() == IScoreboardCriteria.a && (i2 = (name = objective.b()).length() - 4) >= 0) {
            String suffix;
            switch (suffix = name.substring(i2)) {
                case ".bbl": {
                    BBL.remove(objective);
                    break;
                }
                case ".mbb": {
                    MBB.remove(objective);
                    break;
                }
                case ".lbl": {
                    LBL.remove(objective);
                }
            }
        }
    }
}

