/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.util;

import it.unimi.dsi.fastutil.objects.Object2LongLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBannerAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBeaconBeam;
import net.minecraft.world.level.material.MaterialMapColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HopperCounter {
    private static boolean enabled = false;
    private static final Map<EnumColor, HopperCounter> COUNTERS;
    public final EnumColor color;
    private final TextComponent coloredName;
    private final Object2LongMap<Item> counter = new Object2LongLinkedOpenHashMap();
    private long startTick = -1L;
    private long startMillis;
    private static final Map<Item, Block> DEFAULTS;

    private HopperCounter(EnumColor color) {
        this.color = color;
        this.coloredName = Component.text((String)color.b(), (TextColor)TextColor.color((int)color.g()));
    }

    public void add(MinecraftServer server, ItemStack stack) {
        if (this.startTick < 0L) {
            this.startTick = server.D().V();
            this.startMillis = System.currentTimeMillis();
        }
        Item item = stack.d();
        this.counter.put((Object)item, this.counter.getLong((Object)item) + (long)stack.L());
    }

    public void reset(MinecraftServer server) {
        this.counter.clear();
        this.startTick = server.D().V();
        this.startMillis = System.currentTimeMillis();
    }

    public List<Component> format(MinecraftServer server, boolean realTime) {
        long ticks = Math.max(realTime ? (System.currentTimeMillis() - this.startMillis) / 50L : server.D().V() - this.startTick, -1L);
        if (this.startTick < 0L || ticks == -1L) {
            return Collections.singletonList(((TextComponent.Builder)Component.text().append(new Component[]{this.coloredName, Component.text((String)" hasn't started counting yet")})).build());
        }
        long total = this.getTotalItems();
        if (total <= 0L) {
            return Collections.singletonList(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(new Component[]{Component.text((String)"No items for "), this.coloredName})).append(new Component[]{Component.text((String)" yet ("), Component.text((String)String.format("%.2f ", (double)ticks / 1200.0), (Style)Style.style((TextDecoration)TextDecoration.BOLD))})).append(new Component[]{Component.text((String)"min"), Component.text((String)(realTime ? " - real time" : "")), Component.text((String)")")})).build());
        }
        ArrayList<Component> items = new ArrayList<Component>();
        items.add((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(new Component[]{Component.text((String)"Items for "), this.coloredName, Component.text((String)" ")})).append(new Component[]{Component.text((String)"("), Component.text((String)String.format("%.2f ", (double)ticks * 1.0 / 1200.0), (Style)Style.style((TextDecoration)TextDecoration.BOLD))})).append(new Component[]{Component.text((String)"min"), Component.text((String)(realTime ? " - real time" : "")), Component.text((String)"), ")})).append(new Component[]{Component.text((String)"total: "), Component.text((long)total, (Style)Style.style((TextDecoration)TextDecoration.BOLD)), Component.text((String)", ")})).append(new Component[]{Component.text((String)"("), Component.text((String)String.format("%.1f", (double)total * 1.0 * 72000.0 / (double)ticks), (Style)Style.style((TextDecoration)TextDecoration.BOLD))})).append((Component)Component.text((String)"/h):"))).build());
        this.counter.object2LongEntrySet().forEach(entry -> {
            Item item = (Item)entry.getKey();
            TranslatableComponent name = Component.translatable((String)item.a());
            TextColor textColor = HopperCounter.guessColor(server, item);
            name = textColor != null ? name.style(name.style().merge(Style.style((TextColor)textColor))) : name.style(name.style().merge(Style.style((TextDecoration)TextDecoration.ITALIC)));
            long count = entry.getLongValue();
            items.add((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"- ", (TextColor)NamedTextColor.GRAY))).append((Component)name)).append((Component)Component.text((String)": ", (TextColor)NamedTextColor.GRAY))).append(new Component[]{Component.text((long)count, (Style)Style.style((TextDecoration)TextDecoration.BOLD)), Component.text((String)", ", (TextColor)NamedTextColor.GRAY)})).append((Component)Component.text((String)String.format("%.1f", (double)count * 72000.0 / (double)ticks), (Style)Style.style((TextDecoration)TextDecoration.BOLD)))).append((Component)Component.text((String)"/h"))).build());
        });
        return items;
    }

    @Nullable
    public static TextColor guessColor(@NotNull MinecraftServer server, Item item) {
        IRegistryCustom.Dimension registryAccess = server.aU();
        TextColor direct = HopperCounter.fromItem(item, registryAccess);
        if (direct != null) {
            return direct;
        }
        MinecraftKey id = registryAccess.d(Registries.D).b(item);
        for (Recipes recipes : registryAccess.d(Registries.X)) {
            for (IRecipe<?> r2 : HopperCounter.getAllMatching(server.aE(), recipes, id, registryAccess)) {
                for (RecipeItemStack ingredient : r2.a()) {
                    for (Collection<ItemStack> stacks : HopperCounter.getRecipeStacks(ingredient)) {
                        for (ItemStack itemStack : stacks) {
                            TextColor textColor = HopperCounter.fromItem(itemStack.d(), registryAccess);
                            if (textColor == null) continue;
                            return textColor;
                        }
                    }
                }
            }
        }
        return null;
    }

    @Nullable
    public static TextColor fromItem(Item item, IRegistryCustom registryAccess) {
        if (DEFAULTS.containsKey(item)) {
            return TextColor.color((int)HopperCounter.appropriateColor(HopperCounter.DEFAULTS.get((Object)item).s().ak));
        }
        if (item instanceof ItemDye) {
            ItemDye dye = (ItemDye)item;
            return TextColor.color((int)HopperCounter.appropriateColor(dye.d().e().ak));
        }
        Block block = null;
        IRegistry<Item> itemRegistry = registryAccess.d(Registries.D);
        IRegistry<Block> blockRegistry = registryAccess.d(Registries.e);
        MinecraftKey id = itemRegistry.b(item);
        if (item instanceof ItemBlock) {
            ItemBlock blockItem = (ItemBlock)item;
            block = blockItem.e();
        } else if (blockRegistry.b(id).isPresent()) {
            block = blockRegistry.a(id);
        }
        if (block != null) {
            if (block instanceof BlockBannerAbstract) {
                return TextColor.color((int)HopperCounter.appropriateColor(((BlockBannerAbstract)block).a().e().ak));
            }
            if (block instanceof IBeaconBeam) {
                return TextColor.color((int)HopperCounter.appropriateColor(((IBeaconBeam)((Object)block)).a().e().ak));
            }
            return TextColor.color((int)HopperCounter.appropriateColor(block.s().ak));
        }
        return null;
    }

    public static List<IRecipe<?>> getAllMatching(@NotNull CraftingManager manager, Recipes<?> type, MinecraftKey output, IRegistryCustom registryAccess) {
        Map typeRecipes = (Map)manager.c.get(type);
        if (typeRecipes == null) {
            return Collections.emptyList();
        }
        if (typeRecipes.containsKey(output)) {
            return Collections.singletonList(((RecipeHolder)typeRecipes.get(output)).b());
        }
        IRegistry<Item> regs = registryAccess.d(Registries.D);
        return typeRecipes.values().stream().filter(r2 -> Objects.equals(regs.b(r2.b().a(registryAccess).d()), output)).map(RecipeHolder::b).collect(Collectors.toList());
    }

    public static List<Collection<ItemStack>> getRecipeStacks(@NotNull RecipeItemStack ingredient) {
        return Arrays.stream(ingredient.d).map(RecipeItemStack.Provider::a).toList();
    }

    public static int appropriateColor(int color) {
        if (color == 0) {
            return MaterialMapColor.i.ak;
        }
        int r2 = color >> 16 & 0xFF;
        int g2 = color >> 8 & 0xFF;
        int b2 = color & 0xFF;
        if (r2 < 70) {
            r2 = 70;
        }
        if (g2 < 70) {
            g2 = 70;
        }
        if (b2 < 70) {
            b2 = 70;
        }
        return (r2 << 16) + (g2 << 8) + b2;
    }

    public long getTotalItems() {
        return this.counter.isEmpty() ? 0L : this.counter.values().longStream().sum();
    }

    public static void resetAll(MinecraftServer server, boolean fresh) {
        for (HopperCounter counter : COUNTERS.values()) {
            counter.reset(server);
            if (!fresh) continue;
            counter.startTick = -1L;
        }
    }

    public static HopperCounter getCounter(EnumColor color) {
        return COUNTERS.get(color);
    }

    public static void setEnabled(boolean is) {
        enabled = is;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    static {
        EnumMap<EnumColor, HopperCounter> counterMap = new EnumMap<EnumColor, HopperCounter>(EnumColor.class);
        for (EnumColor color : EnumColor.values()) {
            counterMap.put(color, new HopperCounter(color));
        }
        COUNTERS = Collections.unmodifiableMap(counterMap);
        DEFAULTS = Map.ofEntries(Map.entry(Items.cO, Blocks.bE), Map.entry(Items.cP, Blocks.bO), Map.entry(Items.cQ, Blocks.bD), Map.entry(Items.cR, Blocks.bC), Map.entry(Items.cS, Blocks.dP), Map.entry(Items.cT, Blocks.bO), Map.entry(Items.cU, Blocks.bB), Map.entry(Items.cV, Blocks.dP), Map.entry(Items.cW, Blocks.bG), Map.entry(Items.cX, Blocks.dP), Map.entry(Items.cY, Blocks.bL), Map.entry(Items.da, Blocks.bP), Map.entry(Items.cZ, Blocks.bA), Map.entry(Items.de, Blocks.eU), Map.entry(Items.df, Blocks.eV), Map.entry(Items.oB, Blocks.n), Map.entry(Items.nU, Blocks.ch), Map.entry(Items.nQ, Blocks.ci), Map.entry(Items.nK, Blocks.cz), Map.entry(Items.nV, Blocks.pi), Map.entry(Items.hB, Blocks.bE), Map.entry(Items.hC, Blocks.bC), Map.entry(Items.hD, Blocks.bO), Map.entry(Items.hE, Blocks.bG), Map.entry(Items.tl, Blocks.bB), Map.entry(Items.nF, Blocks.bO), Map.entry(Items.oI, Blocks.ij), Map.entry(Items.pj, Blocks.bG), Map.entry(Items.tG, Blocks.bG), Map.entry(Items.rn, Blocks.hj), Map.entry(Items.rl, Blocks.dW), Map.entry(Items.pn, Blocks.ch), Map.entry(Items.ql, Blocks.hj), Map.entry(Items.qm, Blocks.r), Map.entry(Items.rp, Blocks.bM), Map.entry(Items.qo, Blocks.hn), Map.entry(Items.qn, Blocks.bB), Map.entry(Items.tm, Blocks.hj), Map.entry(Items.tT, Blocks.bO), Map.entry(Items.uq, Blocks.dW), Map.entry(Items.rh, Blocks.fa), Map.entry(Items.to, Blocks.hV), Map.entry(Items.rx, Blocks.dW), Map.entry(Items.oG, Blocks.bH), Map.entry(Items.nD, Blocks.bF), Map.entry(Items.oF, Blocks.bA), Map.entry(Items.pi, Blocks.bP), Map.entry(Items.pP, Blocks.o), Map.entry(Items.qk, Blocks.ed), Map.entry(Items.qa, Blocks.bA), Map.entry(Items.pX, Blocks.cj), Map.entry(Items.qr, Blocks.bP), Map.entry(Items.pO, Blocks.dP), Map.entry(Items.pL, Blocks.G), Map.entry(Items.pM, Blocks.H), Map.entry(Items.pQ, Blocks.bA), Map.entry(Items.pY, Blocks.dR), Map.entry(Items.qt, Blocks.fC), Map.entry(Items.qL, Blocks.kM), Map.entry(Items.pT, Blocks.hv), Map.entry(Items.pR, Blocks.hn), Map.entry(Items.pS, Blocks.hp), Map.entry(Items.pU, Blocks.hk), Map.entry(Items.qM, Blocks.bA), Map.entry(Items.rz, Blocks.ch), Map.entry(Items.rq, Blocks.oF), Map.entry(Items.ty, Blocks.cz), Map.entry(Items.tF, Blocks.ii), Map.entry(Items.tE, Blocks.hZ), Map.entry(Items.tK, Blocks.n), Map.entry(Items.um, Blocks.kw), Map.entry(Items.uA, Blocks.kP), Map.entry(Items.uX, Blocks.kM), Map.entry(Items.uY, Blocks.mX), Map.entry(Items.vA, Blocks.ph), Map.entry(Items.tR, Blocks.kM), Map.entry(Items.uz, Blocks.hn), Map.entry(Items.uV, Blocks.hZ), Map.entry(Items.rs, Blocks.bA), Map.entry(Items.uW, Blocks.kM), Map.entry(Items.qd, Blocks.kM), Map.entry(Items.nS, Blocks.qM), Map.entry(Items.nO, Blocks.qt));
    }
}

