/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.util;

import java.util.regex.Pattern;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.Vector;

public class MathUtils {
    private static final Pattern numericPattern = Pattern.compile("^-?[1-9]\\d*$|^0$");
    private static final int[] MULTIPLY_DE_BRUIJN_BIT_POSITION = new int[]{0, 1, 28, 2, 29, 14, 24, 3, 30, 22, 20, 15, 25, 17, 4, 8, 31, 27, 13, 23, 21, 19, 16, 7, 26, 12, 18, 6, 11, 5, 10, 9};

    public static void clean(Vector vector) {
        if (!NumberConversions.isFinite((double)vector.getX())) {
            vector.setX(0);
        }
        if (!NumberConversions.isFinite((double)vector.getY())) {
            vector.setY(0);
        }
        if (!NumberConversions.isFinite((double)vector.getZ())) {
            vector.setZ(0);
        }
    }

    public static boolean isNumeric(String str) {
        return numericPattern.matcher(str).matches();
    }

    public static float[] fetchYawPitch(Vector dir) {
        double x2 = dir.getX();
        double z2 = dir.getZ();
        float[] out = new float[2];
        if (x2 == 0.0 && z2 == 0.0) {
            out[1] = dir.getY() > 0.0 ? -90 : 90;
        } else {
            double theta = Math.atan2(-x2, z2);
            out[0] = (float)Math.toDegrees((theta + Math.PI * 2) % (Math.PI * 2));
            double x22 = NumberConversions.square((double)x2);
            double z22 = NumberConversions.square((double)z2);
            double xz = Math.sqrt(x22 + z22);
            out[1] = (float)Math.toDegrees(Math.atan(-dir.getY() / xz));
        }
        return out;
    }

    public static float fetchPitch(Vector dir) {
        float result;
        double x2 = dir.getX();
        double z2 = dir.getZ();
        if (x2 == 0.0 && z2 == 0.0) {
            result = dir.getY() > 0.0 ? -90 : 90;
        } else {
            double x22 = NumberConversions.square((double)x2);
            double z22 = NumberConversions.square((double)z2);
            double xz = Math.sqrt(x22 + z22);
            result = (float)Math.toDegrees(Math.atan(-dir.getY() / xz));
        }
        return result;
    }

    public static Vector getDirection(double rotX, double rotY) {
        Vector vector = new Vector();
        rotX = Math.toRadians(rotX);
        rotY = Math.toRadians(rotY);
        double xz = Math.abs(Math.cos(rotY));
        vector.setX(-Math.sin(rotX) * xz);
        vector.setZ(Math.cos(rotX) * xz);
        vector.setY(-Math.sin(rotY));
        return vector;
    }

    public static int floorLog2(int value) {
        return MathUtils.ceilLog2(value) - (MathUtils.isPowerOfTwo(value) ? 0 : 1);
    }

    public static int ceilLog2(int value) {
        value = MathUtils.isPowerOfTwo(value) ? value : MathUtils.smallestEncompassingPowerOfTwo(value);
        return MULTIPLY_DE_BRUIJN_BIT_POSITION[(int)((long)value * 125613361L >> 27) & 0x1F];
    }

    public static boolean isPowerOfTwo(int value) {
        return value != 0 && (value & value - 1) == 0;
    }

    public static int smallestEncompassingPowerOfTwo(int value) {
        int i2 = value - 1;
        i2 |= i2 >> 1;
        i2 |= i2 >> 2;
        i2 |= i2 >> 4;
        i2 |= i2 >> 8;
        i2 |= i2 >> 16;
        return i2 + 1;
    }
}

