/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leavesclip;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import top.leavesmc.leavesclip.AutoUpdate;

class Util {
    public static MessageDigest sha256Digest = Util.getSha256Digest();

    private Util() {
    }

    private static MessageDigest getSha256Digest() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw Util.fail("Could not create hashing instance", e);
        }
    }

    static byte[] readBytes(Path file) {
        try {
            return Util.readFully(Files.newInputStream(file, new OpenOption[0]));
        }
        catch (IOException e) {
            throw Util.fail("Failed to read all of the data from " + file.toAbsolutePath(), e);
        }
    }

    static byte[] readFully(InputStream in) throws IOException {
        try (InputStream inputStream = in;){
            int read;
            byte[] buffer = new byte[16384];
            int off = 0;
            while ((read = in.read(buffer, off, buffer.length - off)) != -1) {
                if ((off += read) != buffer.length) continue;
                buffer = Arrays.copyOf(buffer, buffer.length * 2);
            }
            byte[] byArray = Arrays.copyOfRange(buffer, 0, off);
            return byArray;
        }
    }

    static String readResourceText(String path) throws IOException {
        Object p = path.startsWith("/") ? path : "/" + path;
        InputStream stream = AutoUpdate.getResourceAsStream(AutoUpdate.autoUpdateCorePath, (String)p);
        if (stream == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        try (InputStream inputStream = stream;){
            InputStreamReader reader = new InputStreamReader(stream);
            reader.transferTo(writer);
        }
        return writer.toString();
    }

    static boolean isDataValid(byte[] data, byte[] hash) {
        return Arrays.equals(hash, sha256Digest.digest(data));
    }

    static boolean isFileValid(Path file, byte[] hash) {
        if (Files.exists(file, new LinkOption[0])) {
            byte[] fileBytes = Util.readBytes(file);
            return Util.isDataValid(fileBytes, hash);
        }
        return false;
    }

    static byte[] fromHex(String s) {
        if (s.length() % 2 != 0) {
            throw new IllegalArgumentException("Length of hex " + s + " must be divisible by two");
        }
        try {
            byte[] bytes = new byte[s.length() / 2];
            for (int i = 0; i < bytes.length; ++i) {
                byte b;
                char left = s.charAt(i * 2);
                char right = s.charAt(i * 2 + 1);
                bytes[i] = b = (byte)(Util.getHexValue(left) << 4 | Util.getHexValue(right) & 0xF);
            }
            return bytes;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot convert non-hex string: " + s);
        }
    }

    private static int getHexValue(char c) {
        int i = Character.digit(c, 16);
        if (i < 0) {
            throw new IllegalArgumentException("Invalid hex char: " + c);
        }
        return i;
    }

    static RuntimeException fail(String message, Throwable err) {
        System.err.println(message);
        if (err != null) {
            err.printStackTrace();
        }
        System.exit(1);
        throw new InternalError();
    }

    static <X extends Throwable> RuntimeException sneakyThrow(Throwable ex) throws X {
        throw ex;
    }

    static String endingSlash(String dir) {
        if (dir.endsWith("/")) {
            return dir;
        }
        return dir + "/";
    }
}

