/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.concurrentutil.lock;

import ca.spottedleaf.concurrentutil.collection.MultiThreadedQueue;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.concurrent.locks.LockSupport;

public final class SyncReentrantAreaLock {
    private final int coordinateShift;
    private final Long2ReferenceOpenHashMap<Node> nodes = new Long2ReferenceOpenHashMap(128, 0.2f);

    public SyncReentrantAreaLock(int coordinateShift) {
        this.coordinateShift = coordinateShift;
    }

    private static long key(int x, int z) {
        return (long)z << 32 | (long)x & 0xFFFFFFFFL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node lock(int x, int z) {
        Thread currThread = Thread.currentThread();
        int shift = this.coordinateShift;
        int sectionX = x >> shift;
        int sectionZ = z >> shift;
        LongArrayList areaAffected = new LongArrayList();
        Node ret = new Node(this, areaAffected, currThread);
        long coordinate = SyncReentrantAreaLock.key(sectionX, sectionZ);
        long failures = 0L;
        while (true) {
            Node park;
            SyncReentrantAreaLock syncReentrantAreaLock = this;
            synchronized (syncReentrantAreaLock) {
                Node prev = (Node)this.nodes.putIfAbsent(coordinate, (Object)ret);
                if (prev == null) {
                    areaAffected.add(coordinate);
                    return ret;
                }
                if (prev.thread == currThread) {
                    return ret;
                }
                park = prev;
            }
            if (++failures > 128L && park.add(currThread)) {
                LockSupport.park();
                continue;
            }
            if (failures < 128L) {
                for (long i = 0L; i < failures; ++i) {
                    Thread.onSpinWait();
                }
                failures <<= 1;
                continue;
            }
            if (failures < 1200L) {
                LockSupport.parkNanos(1000L);
                ++failures;
                continue;
            }
            Thread.yield();
            LockSupport.parkNanos(100000L * failures);
            ++failures;
        }
    }

    public Node lock(int centerX, int centerZ, int radius) {
        return this.lock(centerX - radius, centerZ - radius, centerX + radius, centerZ + radius);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node lock(int fromX, int fromZ, int toX, int toZ) {
        if (fromX > toX || fromZ > toZ) {
            throw new IllegalArgumentException();
        }
        Thread currThread = Thread.currentThread();
        int shift = this.coordinateShift;
        int fromSectionX = fromX >> shift;
        int fromSectionZ = fromZ >> shift;
        int toSectionX = toX >> shift;
        int toSectionZ = toZ >> shift;
        LongArrayList areaAffected = new LongArrayList();
        Node ret = new Node(this, areaAffected, currThread);
        long failures = 0L;
        while (true) {
            MultiThreadedQueue park = null;
            boolean addedToArea = false;
            SyncReentrantAreaLock syncReentrantAreaLock = this;
            synchronized (syncReentrantAreaLock) {
                block4: for (int currZ = fromSectionZ; currZ <= toSectionZ; ++currZ) {
                    for (int currX = fromSectionX; currX <= toSectionX; ++currX) {
                        long coordinate = SyncReentrantAreaLock.key(currX, currZ);
                        Node prev = (Node)this.nodes.putIfAbsent(coordinate, (Object)ret);
                        if (prev == null) {
                            addedToArea = true;
                            areaAffected.add(coordinate);
                            continue;
                        }
                        if (prev.thread == currThread) continue;
                        park = prev;
                        continue block4;
                    }
                }
                if (park == null) {
                    return ret;
                }
                if (!areaAffected.isEmpty()) {
                    int len = areaAffected.size();
                    for (int i = 0; i < len; ++i) {
                        long key = areaAffected.getLong(i);
                        if (this.nodes.remove(key, (Object)ret)) continue;
                        throw new IllegalStateException();
                    }
                }
            }
            if (addedToArea) {
                Thread unpark;
                areaAffected.clear();
                while ((unpark = (Thread)ret.pollOrBlockAdds()) != null) {
                    LockSupport.unpark(unpark);
                }
            }
            if (++failures > 128L && park.add(currThread)) {
                LockSupport.park();
            } else if (failures < 128L) {
                for (long i = 0L; i < failures; ++i) {
                    Thread.onSpinWait();
                }
                failures <<= 1;
            } else if (failures < 1200L) {
                LockSupport.parkNanos(1000L);
                ++failures;
            } else {
                Thread.yield();
                LockSupport.parkNanos(100000L * failures);
                ++failures;
            }
            if (!addedToArea) continue;
            ret.allowAdds();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(Node node) {
        Thread unpark;
        if (node.lock != this) {
            throw new IllegalStateException("Unlock target lock mismatch");
        }
        LongArrayList areaAffected = node.areaAffected;
        if (areaAffected.isEmpty()) {
            return;
        }
        SyncReentrantAreaLock syncReentrantAreaLock = this;
        synchronized (syncReentrantAreaLock) {
            int len = areaAffected.size();
            for (int i = 0; i < len; ++i) {
                long coordinate = areaAffected.getLong(i);
                if (this.nodes.remove(coordinate, (Object)node)) continue;
                throw new IllegalStateException();
            }
        }
        while ((unpark = (Thread)node.pollOrBlockAdds()) != null) {
            LockSupport.unpark(unpark);
        }
    }

    public static final class Node
    extends MultiThreadedQueue<Thread> {
        private final SyncReentrantAreaLock lock;
        private final LongArrayList areaAffected;
        private final Thread thread;

        private Node(SyncReentrantAreaLock lock, LongArrayList areaAffected, Thread thread) {
            this.lock = lock;
            this.areaAffected = areaAffected;
            this.thread = thread;
        }
    }
}

