/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.converters.itemstack;

import ca.spottedleaf.dataconverter.minecraft.converters.helpers.RenameHelper;
import ca.spottedleaf.dataconverter.minecraft.util.ComponentUtils;
import ca.spottedleaf.dataconverter.minecraft.versions.V3818;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import ca.spottedleaf.dataconverter.types.TypeUtil;
import ca.spottedleaf.dataconverter.util.NamespaceUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.util.Mth;

public final class ConverterItemStackToDataComponents {
    private static final int TOOLTIP_FLAG_HIDE_ENCHANTMENTS = 1;
    private static final int TOOLTIP_FLAG_HIDE_MODIFIERS = 2;
    private static final int TOOLTIP_FLAG_HIDE_UNBREAKABLE = 4;
    private static final int TOOLTIP_FLAG_HIDE_CAN_DESTROY = 8;
    private static final int TOOLTIP_FLAG_HIDE_CAN_PLACE = 16;
    private static final int TOOLTIP_FLAG_HIDE_ADDITIONAL = 32;
    private static final int TOOLTIP_FLAG_HIDE_DYE = 64;
    private static final int TOOLTIP_FLAG_HIDE_UPGRADES = 128;
    private static final int DEFAULT_LEATHER_COLOUR = 10511680;
    private static final String[] BUCKETED_MOB_TAGS = new String[]{"NoAI", "Silent", "NoGravity", "Glowing", "Invulnerable", "Health", "Age", "Variant", "HuntingCooldown", "BucketVariantTag"};
    private static final Set<String> BOOLEAN_BLOCK_STATE_PROPERTIES = new HashSet<String>(Arrays.asList("attached", "bottom", "conditional", "disarmed", "drag", "enabled", "extended", "eye", "falling", "hanging", "has_bottle_0", "has_bottle_1", "has_bottle_2", "has_record", "has_book", "inverted", "in_wall", "lit", "locked", "occupied", "open", "persistent", "powered", "short", "signal_fire", "snowy", "triggered", "unstable", "waterlogged", "berries", "bloom", "shrieking", "can_summon", "up", "down", "north", "east", "south", "west", "slot_0_occupied", "slot_1_occupied", "slot_2_occupied", "slot_3_occupied", "slot_4_occupied", "slot_5_occupied", "cracked", "crafting"));
    private static final String[] MAP_DECORATION_CONVERSION_TABLE = new String[34];

    private static String convertMapDecorationId(int type) {
        return type >= 0 && type < MAP_DECORATION_CONVERSION_TABLE.length ? MAP_DECORATION_CONVERSION_TABLE[type] : MAP_DECORATION_CONVERSION_TABLE[0];
    }

    private static void convertBlockStateProperties(MapType<String> properties) {
        for (String key : properties.keys()) {
            Object value = properties.getGeneric(key);
            if (!(value instanceof Number)) continue;
            Number number = (Number)value;
            if (BOOLEAN_BLOCK_STATE_PROPERTIES.contains(key)) {
                properties.setString(key, Boolean.toString(number.byteValue() != 0));
                continue;
            }
            properties.setString(key, number.toString());
        }
    }

    private static void convertTileEntity(MapType<String> tileEntity, TransientItemStack transientItem) {
        String id;
        Object lootTable;
        Object lock = tileEntity.getGeneric("Lock");
        if (lock != null) {
            tileEntity.remove("Lock");
            transientItem.componentSetGeneric("minecraft:lock", lock);
        }
        if ((lootTable = tileEntity.getGeneric("LootTable")) != null) {
            MapType<String> containerLoot = tileEntity.getTypeUtil().createEmptyMap();
            transientItem.componentSetMap("minecraft:container_loot", containerLoot);
            containerLoot.setGeneric("loot_table", lootTable);
            long seed = tileEntity.getLong("LootTableSeed", 0L);
            if (seed != 0L) {
                containerLoot.setLong("seed", seed);
            }
            tileEntity.remove("LootTable");
            tileEntity.remove("LootTableSeed");
        }
        switch (id = NamespaceUtil.correctNamespace(tileEntity.getString("id", ""))) {
            case "minecraft:skull": {
                Object noteBlockSound = tileEntity.getGeneric("note_block_sound");
                if (noteBlockSound == null) break;
                tileEntity.remove("note_block_sound");
                transientItem.componentSetGeneric("minecraft:note_block_sound", noteBlockSound);
                break;
            }
            case "minecraft:decorated_pot": {
                Object item;
                Object sherds = tileEntity.getGeneric("sherds");
                if (sherds != null) {
                    tileEntity.remove("sherds");
                    transientItem.componentSetGeneric("minecraft:pot_decorations", sherds);
                }
                if ((item = tileEntity.getGeneric("item")) == null) break;
                tileEntity.remove("item");
                ListType container = tileEntity.getTypeUtil().createEmptyList();
                transientItem.componentSetList("minecraft:container", container);
                MapType<String> wrappedItem = tileEntity.getTypeUtil().createEmptyMap();
                container.addMap(wrappedItem);
                wrappedItem.setInt("slot", 0);
                wrappedItem.setGeneric("item", item);
                break;
            }
            case "minecraft:banner": {
                Number base;
                Object patterns = tileEntity.getGeneric("patterns");
                if (patterns != null) {
                    tileEntity.remove("patterns");
                    transientItem.componentSetGeneric("minecraft:banner_patterns", patterns);
                }
                if ((base = tileEntity.getNumber("Base")) == null) break;
                tileEntity.remove("Base");
                transientItem.componentSetString("minecraft:base_color", V3818.getBannerColour(base.intValue()));
                break;
            }
            case "minecraft:shulker_box": 
            case "minecraft:chest": 
            case "minecraft:trapped_chest": 
            case "minecraft:furnace": 
            case "minecraft:ender_chest": 
            case "minecraft:dispenser": 
            case "minecraft:dropper": 
            case "minecraft:brewing_stand": 
            case "minecraft:hopper": 
            case "minecraft:barrel": 
            case "minecraft:smoker": 
            case "minecraft:blast_furnace": 
            case "minecraft:campfire": 
            case "minecraft:chiseled_bookshelf": 
            case "minecraft:crafter": {
                ListType items = tileEntity.getList("Items", ObjectType.MAP);
                tileEntity.remove("Items");
                if (items == null || items.size() <= 0) break;
                transientItem.componentSetList("minecraft:container", items);
                int len = items.size();
                for (int i = 0; i < len; ++i) {
                    MapType item = items.getMap(i);
                    int slot = item.getByte("Slot", (byte)0) & 0xFF;
                    item.remove("Slot");
                    MapType<String> wrappedItem = item.getTypeUtil().createEmptyMap();
                    items.setMap(i, wrappedItem);
                    wrappedItem.setInt("slot", slot);
                    wrappedItem.setMap("item", item);
                }
                break;
            }
            case "minecraft:beehive": {
                Object bees = tileEntity.getGeneric("bees");
                if (bees == null) break;
                tileEntity.remove("bees");
                transientItem.componentSetGeneric("minecraft:bees", bees);
                break;
            }
        }
    }

    private static void convertEnchantments(TransientItemStack transientItem, TypeUtil type, String tagKey, String componentKey, boolean hideToolTip) {
        ListType enchantments = transientItem.tagRemoveList(tagKey, ObjectType.MAP);
        if (enchantments == null || enchantments.size() == 0) {
            if (hideToolTip) {
                MapType<String> newEnchants = type.createEmptyMap();
                transientItem.componentSetMap(componentKey, newEnchants);
                newEnchants.setMap("levels", type.createEmptyMap());
                newEnchants.setBoolean("show_in_tooltip", false);
            }
        } else {
            MapType<String> newEnchantments = type.createEmptyMap();
            int len = enchantments.size();
            for (int i = 0; i < len; ++i) {
                MapType enchantment = enchantments.getMap(i);
                String id = enchantment.getString("id");
                Number level = enchantment.getNumber("lvl");
                if (id == null || level == null) continue;
                newEnchantments.setInt(id, Mth.clamp(level.intValue(), 0, 255));
            }
            if (!newEnchantments.isEmpty() || hideToolTip) {
                MapType<String> newEnchants = type.createEmptyMap();
                transientItem.componentSetMap(componentKey, newEnchants);
                newEnchants.setMap("levels", newEnchantments);
                if (hideToolTip) {
                    newEnchants.setBoolean("show_in_tooltip", false);
                }
            }
        }
        if (enchantments != null && enchantments.size() == 0) {
            transientItem.componentSetBoolean("minecraft:enchantment_glint_override", true);
        }
    }

    private static void convertDisplay(TransientItemStack transientItem, TypeUtil type, int flags) {
        Object mapColor;
        Object locName;
        boolean hideDye;
        MapType display = transientItem.tag.getMap("display");
        if (display != null) {
            Object lore;
            Object name = display.getGeneric("Name");
            if (name != null) {
                display.remove("Name");
                transientItem.componentSetGeneric("minecraft:custom_name", name);
            }
            if ((lore = display.getGeneric("Lore")) != null) {
                display.remove("Lore");
                transientItem.componentSetGeneric("minecraft:lore", lore);
            }
        }
        Number color = display == null ? (Number)null : (Number)display.getNumber("color");
        boolean bl = hideDye = (flags & 0x40) != 0;
        if (hideDye || color != null) {
            if (color != null) {
                display.remove("color");
            }
            MapType<String> dyedColor = type.createEmptyMap();
            transientItem.componentSetMap("minecraft:dyed_color", dyedColor);
            dyedColor.setInt("rgb", color == null ? 10511680 : color.intValue());
            if (hideDye) {
                dyedColor.setBoolean("show_in_tooltip", false);
            }
        }
        Object object = locName = display == null ? null : display.getGeneric("LocName");
        if (locName != null) {
            display.remove("LocName");
            if (locName instanceof String) {
                String locNameString = (String)locName;
                transientItem.componentSetString("minecraft:item_name", ComponentUtils.createTranslatableComponent(locNameString));
            }
        }
        if (display != null && "minecraft:filled_map".equals(transientItem.id) && (mapColor = display.getGeneric("MapColor")) != null) {
            display.remove("MapColor");
            transientItem.componentSetGeneric("minecraft:map_color", mapColor);
        }
        if (display != null && display.isEmpty()) {
            transientItem.tagRemoveMap("display");
        }
    }

    public static MapType<String> convertBlockStatePredicate(String value, TypeUtil type) {
        int nbtEnd;
        int propertyEnd;
        int propertyStart = value.indexOf(91);
        int nbtStart = value.indexOf(123);
        int blockNameEnd = value.length();
        if (propertyStart != -1) {
            blockNameEnd = propertyStart;
        }
        if (nbtStart != -1) {
            blockNameEnd = Math.min(blockNameEnd, nbtStart);
        }
        MapType<String> ret = type.createEmptyMap();
        String blockName = value.substring(0, blockNameEnd);
        ret.setString("blocks", blockName.trim());
        if (propertyStart != -1 && (propertyEnd = value.indexOf(93, propertyStart + 1)) != -1) {
            MapType<String> state = type.createEmptyMap();
            ret.setMap("state", state);
            for (String property : value.substring(propertyStart + 1, propertyEnd).split(",")) {
                int separatorIdx = property.indexOf(61);
                if (separatorIdx == -1) continue;
                String propertyKey = property.substring(0, separatorIdx).trim();
                String propertyValue = property.substring(separatorIdx + 1);
                state.setString(propertyKey, propertyValue);
            }
        }
        if (nbtStart != -1 && (nbtEnd = value.indexOf(125, nbtStart + 1)) != -1) {
            ret.setString("nbt", value.substring(nbtStart, nbtEnd + 1));
        }
        return ret;
    }

    private static void convertBlockStatePredicates(TransientItemStack item, TypeUtil type, String tagKey, String componentKey, boolean hideInTooltip) {
        ListType blocks = item.tagRemoveListUnchecked(tagKey);
        if (blocks == null) {
            return;
        }
        MapType<String> blockPredicates = type.createEmptyMap();
        item.componentSetMap(componentKey, blockPredicates);
        if (hideInTooltip) {
            blockPredicates.setBoolean("show_in_tooltip", false);
        }
        ListType predicates = type.createEmptyList();
        blockPredicates.setList("predicates", predicates);
        int len = blocks.size();
        for (int i = 0; i < len; ++i) {
            Object block = blocks.getGeneric(i);
            if (!(block instanceof String)) {
                predicates.addGeneric(block);
                continue;
            }
            String blockString = (String)block;
            MapType<String> predicate = ConverterItemStackToDataComponents.convertBlockStatePredicate(blockString, type);
            predicates.addMap(predicate);
        }
    }

    private static void convertAdventureMode(TransientItemStack item, TypeUtil type, int flags) {
        ConverterItemStackToDataComponents.convertBlockStatePredicates(item, type, "CanDestroy", "minecraft:can_break", (flags & 8) != 0);
        ConverterItemStackToDataComponents.convertBlockStatePredicates(item, type, "CanPlaceOn", "minecraft:can_place_on", (flags & 0x10) != 0);
    }

    private static void copy(MapType<String> src, String srcKey, MapType<String> dst, String dstKey) {
        if (src == null || dst == null) {
            return;
        }
        Object srcValue = src.getGeneric(srcKey);
        if (srcValue != null) {
            dst.setGeneric(dstKey, srcValue);
        }
    }

    private static MapType<String> convertAttribute(Object inputGeneric, TypeUtil type) {
        MapType casted;
        MapType input = inputGeneric instanceof MapType ? (casted = (MapType)inputGeneric) : null;
        MapType<String> ret = type.createEmptyMap();
        ret.setString("name", "");
        ret.setDouble("amount", 0.0);
        ret.setString("operation", "add_value");
        ConverterItemStackToDataComponents.copy(input, "AttributeName", ret, "type");
        ConverterItemStackToDataComponents.copy(input, "Slot", ret, "slot");
        ConverterItemStackToDataComponents.copy(input, "UUID", ret, "uuid");
        ConverterItemStackToDataComponents.copy(input, "Name", ret, "name");
        ConverterItemStackToDataComponents.copy(input, "Amount", ret, "amount");
        if (input != null && input.hasKey("Operation")) {
            ret.setString("operation", switch (input.getInt("Operation", 0)) {
                case 1 -> "add_multiplied_base";
                case 2 -> "add_multiplied_total";
                default -> "add_value";
            });
        }
        return ret;
    }

    private static void convertAttributes(TransientItemStack item, TypeUtil type, int flags) {
        boolean hideModifiers;
        ListType attributes = item.tagRemoveListUnchecked("AttributeModifiers");
        ListType newAttributes = type.createEmptyList();
        if (attributes != null) {
            int len = attributes.size();
            for (int i = 0; i < len; ++i) {
                newAttributes.addMap(ConverterItemStackToDataComponents.convertAttribute(attributes.getGeneric(i), type));
            }
        }
        boolean bl = hideModifiers = (flags & 2) != 0;
        if (newAttributes.size() > 0 || hideModifiers) {
            MapType<String> newModifiers = type.createEmptyMap();
            item.componentSetMap("minecraft:attribute_modifiers", newModifiers);
            newModifiers.setList("modifiers", newAttributes);
            if (hideModifiers) {
                newModifiers.setBoolean("show_in_tooltip", false);
            }
        }
    }

    private static void convertMap(TransientItemStack item, TypeUtil type) {
        item.tagMigrateToComponent("map", "minecraft:map_id");
        ListType decorations = item.tagRemoveListUnchecked("Decorations");
        if (decorations != null) {
            MapType<String> newDecorations = type.createEmptyMap();
            int len = decorations.size();
            for (int i = 0; i < len; ++i) {
                String id;
                MapType casted;
                Object decorationGeneric = decorations.getGeneric(i);
                MapType decoration = decorationGeneric instanceof MapType ? (casted = (MapType)decorationGeneric) : null;
                String string = id = decoration == null ? "" : decoration.getForcedString("id", "");
                if (newDecorations.hasKey(id)) continue;
                int typeId = decoration == null ? 0 : decoration.getInt("type", 0);
                double x = decoration == null ? 0.0 : decoration.getDouble("x", 0.0);
                double z = decoration == null ? 0.0 : decoration.getDouble("z", 0.0);
                float rot = decoration == null ? 0.0f : (float)decoration.getDouble("rot", 0.0);
                MapType<String> newDecoration = type.createEmptyMap();
                newDecorations.setMap(id, newDecoration);
                newDecoration.setString("type", ConverterItemStackToDataComponents.convertMapDecorationId(typeId));
                newDecoration.setDouble("x", x);
                newDecoration.setDouble("z", z);
                newDecoration.setFloat("rotation", rot);
            }
            if (!newDecorations.isEmpty()) {
                item.componentSetMap("minecraft:map_decorations", newDecorations);
            }
        }
    }

    private static void convertPotion(TransientItemStack item, TypeUtil type) {
        MapType<String> potionContents = type.createEmptyMap();
        String potion = item.tagRemoveString("Potion");
        if (potion != null && !"minecraft:empty".equals(potion)) {
            potionContents.setString("potion", potion);
        }
        item.migrateTagTo("CustomPotionColor", potionContents, "custom_color");
        item.migrateTagTo("custom_potion_effects", potionContents, "custom_effects");
        if (!potionContents.isEmpty()) {
            item.componentSetMap("minecraft:potion_contents", potionContents);
        }
    }

    private static MapType<String> makeFilteredText(String raw, String filtered, TypeUtil type) {
        MapType<String> ret = type.createEmptyMap();
        ret.setString("raw", raw);
        if (filtered != null) {
            ret.setString("filtered", filtered);
        }
        return ret;
    }

    private static ListType convertBookPages(TransientItemStack item, TypeUtil type) {
        ListType oldPages = item.tagRemoveListUnchecked("pages");
        MapType<String> filteredPages = item.tagRemoveMap("filtered_pages");
        if (oldPages == null || oldPages.size() == 0) {
            return null;
        }
        ListType ret = type.createEmptyList();
        int len = oldPages.size();
        for (int i = 0; i < len; ++i) {
            String str;
            Object object = oldPages.getGeneric(i);
            String page = object instanceof String ? (str = (String)object) : "";
            String filtered = filteredPages == null ? null : filteredPages.getString(Integer.toString(i));
            ret.addMap(ConverterItemStackToDataComponents.makeFilteredText(page, filtered, type));
        }
        return ret;
    }

    private static void convertWritableBook(TransientItemStack item, TypeUtil type) {
        ListType pages = ConverterItemStackToDataComponents.convertBookPages(item, type);
        if (pages != null) {
            MapType<String> bookContent = type.createEmptyMap();
            item.componentSetMap("minecraft:writable_book_content", bookContent);
            bookContent.setList("pages", pages);
        }
    }

    private static void convertWrittenBook(TransientItemStack item, TypeUtil type) {
        ListType pages = ConverterItemStackToDataComponents.convertBookPages(item, type);
        MapType<String> bookContent = type.createEmptyMap();
        item.componentSetMap("minecraft:written_book_content", bookContent);
        if (pages != null) {
            bookContent.setList("pages", pages);
        }
        String title = item.tagRemoveString("title", "");
        String filteredTitle = item.tagRemoveString("filtered_title");
        bookContent.setMap("title", ConverterItemStackToDataComponents.makeFilteredText(title, filteredTitle, type));
        item.migrateTagTo("author", bookContent, "author");
        item.migrateTagTo("resolved", bookContent, "resolved");
        item.migrateTagTo("generation", bookContent, "generation");
    }

    private static void convertMobBucket(TransientItemStack item, TypeUtil type) {
        MapType<String> bucketEntityData = type.createEmptyMap();
        for (String oldKey : BUCKETED_MOB_TAGS) {
            item.migrateTagTo(oldKey, bucketEntityData, oldKey);
        }
        if (!bucketEntityData.isEmpty()) {
            item.componentSetMap("minecraft:bucket_entity_data", bucketEntityData);
        }
    }

    private static void convertCompass(TransientItemStack item, TypeUtil type) {
        boolean tracked;
        Object lodestonePos = item.tagRemoveGeneric("LodestonePos");
        Object lodestoneDim = item.tagRemoveGeneric("LodestoneDimension");
        if (lodestonePos == null && lodestoneDim == null) {
            return;
        }
        MapType<String> lodestoneTracker = type.createEmptyMap();
        item.componentSetMap("minecraft:lodestone_tracker", lodestoneTracker);
        if (lodestonePos != null && lodestoneDim != null) {
            MapType<String> target = type.createEmptyMap();
            lodestoneTracker.setMap("target", target);
            target.setGeneric("pos", lodestonePos);
            target.setGeneric("dimension", lodestoneDim);
        }
        if (!(tracked = item.tagRemoveBoolean("LodestoneTracked", true))) {
            lodestoneTracker.setBoolean("tracked", false);
        }
    }

    private static void convertFireworkExplosion(Object inputGeneric) {
        if (!(inputGeneric instanceof MapType)) {
            return;
        }
        MapType input = (MapType)inputGeneric;
        RenameHelper.renameSingle(input, "Colors", "colors");
        RenameHelper.renameSingle(input, "FadeColors", "fade_colors");
        RenameHelper.renameSingle(input, "Trail", "has_trail");
        RenameHelper.renameSingle(input, "Flicker", "has_twinkle");
        int type = input.getInt("Type", 0);
        input.remove("Type");
        input.setString("shape", switch (type) {
            case 1 -> "large_ball";
            case 2 -> "star";
            case 3 -> "creeper";
            case 4 -> "burst";
            default -> "small_ball";
        });
    }

    private static void convertFireworkRocket(TransientItemStack item, TypeUtil type) {
        Object fireworksGeneric = item.tag.getGeneric("Fireworks");
        if (fireworksGeneric == null) {
            return;
        }
        if (!(fireworksGeneric instanceof MapType)) {
            MapType<String> newFireworks = type.createEmptyMap();
            item.componentSetMap("minecraft:fireworks", newFireworks);
            newFireworks.setList("explosions", type.createEmptyList());
            newFireworks.setByte("flight_duration", (byte)0);
            return;
        }
        MapType fireworks = (MapType)fireworksGeneric;
        MapType<String> newFireworks = type.createEmptyMap();
        item.componentSetMap("minecraft:fireworks", newFireworks);
        int flight = fireworks.getInt("Flight", 0);
        newFireworks.setByte("flight_duration", (byte)flight);
        ListType explosions = fireworks.getListUnchecked("Explosions", type.createEmptyList());
        newFireworks.setList("explosions", explosions);
        int len = explosions.size();
        for (int i = 0; i < len; ++i) {
            ConverterItemStackToDataComponents.convertFireworkExplosion(explosions.getGeneric(i));
        }
        fireworks.remove("Explosions");
        fireworks.remove("Flight");
        if (fireworks.isEmpty()) {
            item.tag.remove("Fireworks");
        }
    }

    private static Object copyGeneric(Object value, TypeUtil type) {
        if (value == null || value instanceof Number || value instanceof String) {
            return value;
        }
        if (value instanceof MapType) {
            MapType mapType = (MapType)value;
            return mapType.copy();
        }
        if (value instanceof ListType) {
            ListType listType = (ListType)value;
            return listType.copy();
        }
        ListType dummy = type.createEmptyList();
        dummy.addGeneric(value);
        return dummy.copy().getGeneric(0);
    }

    private static void convertFireworkStar(TransientItemStack item, TypeUtil type) {
        Object explosionGeneric = item.tag.getGeneric("Explosion");
        if (explosionGeneric == null) {
            return;
        }
        if (!(explosionGeneric instanceof MapType)) {
            item.componentSetGeneric("minecraft:firework_explosion", ConverterItemStackToDataComponents.copyGeneric(explosionGeneric, type));
            return;
        }
        MapType explosion = (MapType)explosionGeneric;
        MapType explosionCopy = explosion.copy();
        item.componentSetGeneric("minecraft:firework_explosion", explosionCopy);
        ConverterItemStackToDataComponents.convertFireworkExplosion(explosionCopy);
        explosion.remove("Type");
        explosion.remove("Colors");
        explosion.remove("FadeColors");
        explosion.remove("Trail");
        explosion.remove("Flicker");
        if (explosion.isEmpty()) {
            item.tag.remove("Explosion");
        }
    }

    private static boolean isValidPlayerName(String name) {
        if (name.length() > 16) {
            return false;
        }
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char character = name.charAt(i);
            if (character > ' ' && character < '\u007f') continue;
            return false;
        }
        return true;
    }

    private static ListType convertProperties(MapType<String> properties, TypeUtil type) {
        ListType ret = type.createEmptyList();
        for (String propertyKey : properties.keys()) {
            ListType propertyValues = properties.getListUnchecked(propertyKey);
            if (propertyValues == null) continue;
            int len = propertyValues.size();
            for (int i = 0; i < len; ++i) {
                MapType casted;
                Object object = propertyValues.getGeneric(i);
                MapType property = object instanceof MapType ? (casted = (MapType)object) : null;
                String value = property == null ? "" : property.getString("Value", "");
                String signature = property == null ? null : property.getString("Signature");
                MapType<String> newProperty = type.createEmptyMap();
                ret.addMap(newProperty);
                newProperty.setString("name", propertyKey);
                newProperty.setString("value", value);
                if (signature == null) continue;
                newProperty.setString("signature", signature);
            }
        }
        return ret;
    }

    public static MapType<String> convertProfile(Object inputGeneric, TypeUtil type) {
        MapType<String> properties;
        Object id;
        String name;
        MapType casted;
        MapType<String> ret = type.createEmptyMap();
        if (inputGeneric instanceof String) {
            String name2 = (String)inputGeneric;
            if (!ConverterItemStackToDataComponents.isValidPlayerName(name2)) {
                return ret;
            }
            ret.setString("name", name2);
            return ret;
        }
        MapType input = inputGeneric instanceof MapType ? (casted = (MapType)inputGeneric) : null;
        String string = name = input == null ? "" : input.getString("Name", "");
        if (ConverterItemStackToDataComponents.isValidPlayerName(name)) {
            ret.setString("name", name);
        }
        Object object = id = input == null ? null : input.getGeneric("Id");
        if (id != null) {
            ret.setGeneric("id", id);
        }
        MapType<String> mapType = properties = input == null ? null : input.getMap("Properties");
        if (properties != null && !properties.isEmpty()) {
            ret.setList("properties", ConverterItemStackToDataComponents.convertProperties(properties, type));
        }
        return ret;
    }

    private static void convertSukll(TransientItemStack item, TypeUtil type) {
        Object skullOwnerGeneric = item.tagRemoveGeneric("SkullOwner");
        if (skullOwnerGeneric == null) {
            return;
        }
        item.componentSetMap("minecraft:profile", ConverterItemStackToDataComponents.convertProfile(skullOwnerGeneric, type));
    }

    public static MapType<String> convertItem(MapType<String> input) {
        if (!input.hasKey("id", ObjectType.STRING) || !input.hasKey("Count", ObjectType.NUMBER)) {
            return input.copy();
        }
        TypeUtil type = input.getTypeUtil();
        TransientItemStack item = new TransientItemStack(input);
        item.tagMigrateToComponent("Damage", "minecraft:damage", 0);
        item.tagMigrateToComponent("RepairCost", "minecraft:repair_cost", 0);
        item.tagMigrateToComponent("CustomModelData", "minecraft:custom_model_data");
        MapType<String> blockStateProperties = item.tagRemoveMap("BlockStateTag");
        if (blockStateProperties != null) {
            item.componentSetMap("minecraft:block_state", blockStateProperties);
            ConverterItemStackToDataComponents.convertBlockStateProperties(blockStateProperties);
        }
        item.tagMigrateToComponent("EntityTag", "minecraft:entity_data");
        MapType<String> tileEntityTag = item.tagRemoveMap("BlockEntityTag");
        if (tileEntityTag != null) {
            ConverterItemStackToDataComponents.convertTileEntity(tileEntityTag, item);
            if (tileEntityTag.size() > 1 || tileEntityTag.size() == 1 && !tileEntityTag.hasKey("id")) {
                item.componentSetMap("minecraft:block_entity_data", tileEntityTag);
            }
        }
        int flags = item.tagRemoveInt("HideFlags", 0);
        if (item.tagRemoveInt("Unbreakable", 0) != 0) {
            MapType<String> unbreakable = type.createEmptyMap();
            item.componentSetMap("minecraft:unbreakable", unbreakable);
            if ((flags & 4) != 0) {
                unbreakable.setBoolean("show_in_tooltip", false);
            }
        }
        ConverterItemStackToDataComponents.convertEnchantments(item, type, "Enchantments", "minecraft:enchantments", (flags & 1) != 0);
        ConverterItemStackToDataComponents.convertDisplay(item, type, flags);
        ConverterItemStackToDataComponents.convertAdventureMode(item, type, flags);
        ConverterItemStackToDataComponents.convertAttributes(item, type, flags);
        Object trim = item.tagRemoveGeneric("Trim");
        if (trim != null) {
            if ((flags & 0x80) != 0 && trim instanceof MapType) {
                ((MapType)trim).setBoolean("show_in_tooltip", false);
            }
            item.componentSetGeneric("minecraft:trim", trim);
        }
        if ((flags & 0x20) != 0) {
            item.componentSetMap("minecraft:hide_additional_tooltip", type.createEmptyMap());
        }
        switch (item.id) {
            case "minecraft:enchanted_book": {
                ConverterItemStackToDataComponents.convertEnchantments(item, type, "StoredEnchantments", "minecraft:stored_enchantments", (flags & 0x20) != 0);
                break;
            }
            case "minecraft:crossbow": {
                item.tagRemoveGeneric("Charged");
                item.tagMigrateNonEmptyListToComponent("ChargedProjectiles", "minecraft:charged_projectiles");
                break;
            }
            case "minecraft:bundle": {
                item.tagMigrateNonEmptyListToComponent("Items", "minecraft:bundle_contents");
                break;
            }
            case "minecraft:filled_map": {
                ConverterItemStackToDataComponents.convertMap(item, type);
                break;
            }
            case "minecraft:potion": 
            case "minecraft:splash_potion": 
            case "minecraft:lingering_potion": 
            case "minecraft:tipped_arrow": {
                ConverterItemStackToDataComponents.convertPotion(item, type);
                break;
            }
            case "minecraft:writable_book": {
                ConverterItemStackToDataComponents.convertWritableBook(item, type);
                break;
            }
            case "minecraft:written_book": {
                ConverterItemStackToDataComponents.convertWrittenBook(item, type);
                break;
            }
            case "minecraft:suspicious_stew": {
                item.tagMigrateToComponent("effects", "minecraft:suspicious_stew_effects");
                break;
            }
            case "minecraft:debug_stick": {
                item.tagMigrateToComponent("DebugProperty", "minecraft:debug_stick_state");
                break;
            }
            case "minecraft:pufferfish_bucket": 
            case "minecraft:salmon_bucket": 
            case "minecraft:cod_bucket": 
            case "minecraft:tropical_fish_bucket": 
            case "minecraft:axolotl_bucket": 
            case "minecraft:tadpole_bucket": {
                ConverterItemStackToDataComponents.convertMobBucket(item, type);
                break;
            }
            case "minecraft:goat_horn": {
                item.tagMigrateToComponent("instrument", "minecraft:instrument");
                break;
            }
            case "minecraft:knowledge_book": {
                item.tagMigrateToComponent("Recipes", "minecraft:recipes");
                break;
            }
            case "minecraft:compass": {
                ConverterItemStackToDataComponents.convertCompass(item, type);
                break;
            }
            case "minecraft:firework_rocket": {
                ConverterItemStackToDataComponents.convertFireworkRocket(item, type);
                break;
            }
            case "minecraft:firework_star": {
                ConverterItemStackToDataComponents.convertFireworkStar(item, type);
                break;
            }
            case "minecraft:player_head": {
                ConverterItemStackToDataComponents.convertSukll(item, type);
            }
        }
        return item.serialize();
    }

    private ConverterItemStackToDataComponents() {
    }

    static {
        ConverterItemStackToDataComponents.MAP_DECORATION_CONVERSION_TABLE[0] = "player";
        ConverterItemStackToDataComponents.MAP_DECORATION_CONVERSION_TABLE[1] = "frame";
        ConverterItemStackToDataComponents.MAP_DECORATION_CONVERSION_TABLE[2] = "red_marker";
        ConverterItemStackToDataComponents.MAP_DECORATION_CONVERSION_TABLE[3] = "blue_marker";
        ConverterItemStackToDataComponents.MAP_DECORATION_CONVERSION_TABLE[4] = "target_x";
        ConverterItemStackToDataComponents.MAP_DECORATION_CONVERSION_TABLE[5] = "target_point";
        ConverterItemStackToDataComponents.MAP_DECORATION_CONVERSION_TABLE[6] = "player_off_map";
        ConverterItemStackToDataComponents.MAP_DECORATION_CONVERSION_TABLE[7] = "player_off_limits";
        ConverterItemStackToDataComponents.MAP_DECORATION_CONVERSION_TABLE[8] = "mansion";
        ConverterItemStackToDataComponents.MAP_DECORATION_CONVERSION_TABLE[9] = "monument";
        ConverterItemStackToDataComponents.MAP_DECORATION_CONVERSION_TABLE[10] = "banner_white";
        ConverterItemStackToDataComponents.MAP_DECORATION_CONVERSION_TABLE[11] = "banner_orange";
        ConverterItemStackToDataComponents.MAP_DECORATION_CONVERSION_TABLE[12] = "banner_magenta";
        ConverterItemStackToDataComponents.MAP_DECORATION_CONVERSION_TABLE[13] = "banner_light_blue";
        ConverterItemStackToDataComponents.MAP_DECORATION_CONVERSION_TABLE[14] = "banner_yellow";
        ConverterItemStackToDataComponents.MAP_DECORATION_CONVERSION_TABLE[15] = "banner_lime";
        ConverterItemStackToDataComponents.MAP_DECORATION_CONVERSION_TABLE[16] = "banner_pink";
        ConverterItemStackToDataComponents.MAP_DECORATION_CONVERSION_TABLE[17] = "banner_gray";
        ConverterItemStackToDataComponents.MAP_DECORATION_CONVERSION_TABLE[18] = "banner_light_gray";
        ConverterItemStackToDataComponents.MAP_DECORATION_CONVERSION_TABLE[19] = "banner_cyan";
        ConverterItemStackToDataComponents.MAP_DECORATION_CONVERSION_TABLE[20] = "banner_purple";
        ConverterItemStackToDataComponents.MAP_DECORATION_CONVERSION_TABLE[21] = "banner_blue";
        ConverterItemStackToDataComponents.MAP_DECORATION_CONVERSION_TABLE[22] = "banner_brown";
        ConverterItemStackToDataComponents.MAP_DECORATION_CONVERSION_TABLE[23] = "banner_green";
        ConverterItemStackToDataComponents.MAP_DECORATION_CONVERSION_TABLE[24] = "banner_red";
        ConverterItemStackToDataComponents.MAP_DECORATION_CONVERSION_TABLE[25] = "banner_black";
        ConverterItemStackToDataComponents.MAP_DECORATION_CONVERSION_TABLE[26] = "red_x";
        ConverterItemStackToDataComponents.MAP_DECORATION_CONVERSION_TABLE[27] = "village_desert";
        ConverterItemStackToDataComponents.MAP_DECORATION_CONVERSION_TABLE[28] = "village_plains";
        ConverterItemStackToDataComponents.MAP_DECORATION_CONVERSION_TABLE[29] = "village_savanna";
        ConverterItemStackToDataComponents.MAP_DECORATION_CONVERSION_TABLE[30] = "village_snowy";
        ConverterItemStackToDataComponents.MAP_DECORATION_CONVERSION_TABLE[31] = "village_taiga";
        ConverterItemStackToDataComponents.MAP_DECORATION_CONVERSION_TABLE[32] = "jungle_temple";
        ConverterItemStackToDataComponents.MAP_DECORATION_CONVERSION_TABLE[33] = "swamp_hut";
    }

    private static final class TransientItemStack {
        private final String id;
        private final int count;
        private final MapType<String> components;
        private final MapType<String> tag;
        private final MapType<String> root;

        public TransientItemStack(MapType<String> root) {
            this.id = root.getString("id");
            this.count = root.getInt("Count");
            TypeUtil type = root.getTypeUtil();
            this.components = type.createEmptyMap();
            MapType<String> rootCopy = root.copy();
            MapType tag = rootCopy.getMap("tag");
            rootCopy.remove("id");
            rootCopy.remove("Count");
            rootCopy.remove("tag");
            this.tag = tag == null ? type.createEmptyMap() : tag;
            this.root = rootCopy;
        }

        public void migrateTagTo(String tagKey, MapType<String> dst, String dstKey) {
            Object value = this.tag.getGeneric(tagKey);
            if (value != null) {
                this.tag.remove(tagKey);
                dst.setGeneric(dstKey, value);
            }
        }

        public String tagRemoveString(String key) {
            String ret = this.tag.getString(key);
            this.tag.remove(key);
            return ret;
        }

        public String tagRemoveString(String key, String dfl) {
            String ret = this.tag.getString(key, dfl);
            this.tag.remove(key);
            return ret;
        }

        public ListType tagRemoveListUnchecked(String key) {
            ListType ret = this.tag.getListUnchecked(key);
            this.tag.remove(key);
            return ret;
        }

        public ListType tagRemoveList(String key, ObjectType listType) {
            ListType ret = this.tag.getList(key, listType);
            this.tag.remove(key);
            return ret;
        }

        public MapType<String> tagRemoveMap(String key) {
            MapType<String> ret = this.tag.getMap(key);
            this.tag.remove(key);
            return ret;
        }

        public boolean tagRemoveBoolean(String key, boolean dfl) {
            boolean ret = this.tag.getBoolean(key, dfl);
            this.tag.remove(key);
            return ret;
        }

        public int tagRemoveInt(String key, int dfl) {
            int ret = this.tag.getInt(key, dfl);
            this.tag.remove(key);
            return ret;
        }

        public Object tagRemoveGeneric(String key) {
            Object ret = this.tag.getGeneric(key);
            if (ret != null) {
                this.tag.remove(key);
                return ret;
            }
            return ret;
        }

        public void tagMigrateToComponent(String tagKey, String componentKey) {
            Object value = this.tag.getGeneric(tagKey);
            if (value != null) {
                this.tag.remove(tagKey);
                this.components.setGeneric(componentKey, value);
            }
        }

        public void tagMigrateNonEmptyListToComponent(String tagKey, String componentKey) {
            Object value = this.tag.getGeneric(tagKey);
            if (value != null) {
                ListType list;
                this.tag.remove(tagKey);
                if (!(value instanceof ListType) || (list = (ListType)value).size() > 0) {
                    this.components.setGeneric(componentKey, value);
                }
            }
        }

        public void tagMigrateToComponent(String tagKey, String componentKey, int defaultComponent) {
            int value = this.tag.getInt(tagKey, defaultComponent);
            this.tag.remove(tagKey);
            if (value != defaultComponent) {
                this.components.setGeneric(componentKey, value);
            }
        }

        public void componentSetBoolean(String key, boolean value) {
            this.components.setBoolean(key, value);
        }

        public void componentSetString(String key, String value) {
            this.components.setString(key, value);
        }

        public void componentSetList(String key, ListType value) {
            this.components.setList(key, value);
        }

        public void componentSetMap(String key, MapType<String> value) {
            this.components.setMap(key, value);
        }

        public void componentSetGeneric(String key, Object value) {
            this.components.setGeneric(key, value);
        }

        public MapType<String> serialize() {
            MapType<String> ret = this.components.getTypeUtil().createEmptyMap();
            ret.setString("id", this.id);
            ret.setInt("count", this.count);
            if (!this.tag.isEmpty()) {
                this.components.setMap("minecraft:custom_data", this.tag);
            }
            if (!this.components.isEmpty()) {
                ret.setMap("components", this.components);
            }
            if (!this.root.isEmpty()) {
                for (String key : this.root.keys()) {
                    if (ret.hasKey(key)) continue;
                    ret.setGeneric(key, this.root.getGeneric(key));
                }
            }
            return ret;
        }
    }
}

