/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.MapType;
import com.mojang.logging.LogUtils;
import java.util.UUID;
import org.slf4j.Logger;

public final class V108 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int VERSION = 108;

    public static void register() {
        MCTypeRegistry.ENTITY.addStructureConverter(new DataConverter<MapType<String>, MapType<String>>(108){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                UUID uuid;
                String uuidString = data.getString("UUID");
                if (uuidString == null) {
                    return null;
                }
                data.remove("UUID");
                try {
                    uuid = UUID.fromString(uuidString);
                }
                catch (Exception ex) {
                    LOGGER.warn("Failed to parse UUID for legacy entity (V108): " + uuidString, (Throwable)ex);
                    return null;
                }
                data.setLong("UUIDMost", uuid.getMostSignificantBits());
                data.setLong("UUIDLeast", uuid.getLeastSignificantBits());
                return null;
            }
        });
    }

    private V108() {
    }
}

