/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.versions.V1496;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import org.slf4j.Logger;

public final class V1624 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int VERSION = 1624;

    public static void register() {
        MCTypeRegistry.CHUNK.addStructureConverter(new DataConverter<MapType<String>, MapType<String>>(1624){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                MapType level = data.getMap("Level");
                if (level == null) {
                    return null;
                }
                ListType sections = level.getList("Sections", ObjectType.MAP);
                if (sections == null) {
                    return null;
                }
                IntOpenHashSet positionsToLook = new IntOpenHashSet();
                int len = sections.size();
                for (int i = 0; i < len; ++i) {
                    TrappedChestSection section = new TrappedChestSection(sections.getMap(i));
                    if (section.isSkippable()) continue;
                    for (int index = 0; index < 4096; ++index) {
                        if (!section.isTrappedChest(section.getBlock(index))) continue;
                        positionsToLook.add(section.getSectionY() << 12 | index);
                    }
                }
                int chunkX = level.getInt("xPos");
                int chunkZ = level.getInt("zPos");
                ListType tileEntities = level.getList("TileEntities", ObjectType.MAP);
                if (tileEntities != null) {
                    int len2 = tileEntities.size();
                    for (int i = 0; i < len2; ++i) {
                        int z;
                        int y;
                        MapType tile = tileEntities.getMap(i);
                        int x = tile.getInt("x");
                        int index = V1496.getIndex(x - (chunkX << 4), y = tile.getInt("y"), (z = tile.getInt("z")) - (chunkZ << 4));
                        if (!positionsToLook.contains(index)) continue;
                        String id = tile.getString("id");
                        if (!"minecraft:chest".equals(id)) {
                            LOGGER.warn("Block Entity ({},{},{}) was expected to be a chest (V1624)", new Object[]{x, y, z});
                        }
                        tile.setString("id", "minecraft:trapped_chest");
                    }
                }
                return null;
            }
        });
    }

    private V1624() {
    }

    public static final class TrappedChestSection
    extends V1496.Section {
        private IntOpenHashSet chestIds;

        public TrappedChestSection(MapType<String> section) {
            super(section);
        }

        @Override
        protected boolean initSkippable() {
            this.chestIds = new IntOpenHashSet();
            for (int i = 0; i < this.palette.size(); ++i) {
                MapType blockState = this.palette.getMap(i);
                String name = blockState.getString("Name");
                if (!"minecraft:trapped_chest".equals(name)) continue;
                this.chestIds.add(i);
            }
            return this.chestIds.isEmpty();
        }

        public boolean isTrappedChest(int id) {
            return this.chestIds.contains(id);
        }
    }
}

